/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2;

import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.buffer.ByteBuf;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.channel.ChannelPromise;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http.EmptyHttpHeaders;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http.FullHttpMessage;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http.HttpContent;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http.HttpMessage;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.EmptyHttp2Headers;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.Http2CodecUtil;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.Http2ConnectionDecoder;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.Http2ConnectionEncoder;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.Http2ConnectionHandler;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.Http2Headers;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.Http2Settings;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.handler.codec.http2.HttpConversionUtil;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.ReferenceCountUtil;

public class HttpToHttp2ConnectionHandler
extends Http2ConnectionHandler {
    private final boolean validateHeaders;
    private int currentStreamId;

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders) {
        super(decoder, encoder, initialSettings);
        this.validateHeaders = validateHeaders;
    }

    protected HttpToHttp2ConnectionHandler(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, boolean validateHeaders, boolean decoupleCloseAndGoAway) {
        super(decoder, encoder, initialSettings, decoupleCloseAndGoAway);
        this.validateHeaders = validateHeaders;
    }

    private int getStreamId(HttpHeaders httpHeaders) throws Exception {
        return httpHeaders.getInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), this.connection().local().incrementAndGetNextStreamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (!(msg instanceof HttpMessage) && !(msg instanceof HttpContent)) {
            ctx.write(msg, promise);
            return;
        }
        boolean release = true;
        Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
        try {
            Http2ConnectionEncoder encoder = this.encoder();
            boolean endStream = false;
            if (msg instanceof HttpMessage) {
                HttpMessage httpMsg = (HttpMessage)msg;
                this.currentStreamId = this.getStreamId(httpMsg.headers());
                Http2Headers http2Headers = HttpConversionUtil.toHttp2Headers(httpMsg, this.validateHeaders);
                endStream = msg instanceof FullHttpMessage && !((FullHttpMessage)msg).content().isReadable();
                HttpToHttp2ConnectionHandler.writeHeaders(ctx, encoder, this.currentStreamId, httpMsg.headers(), http2Headers, endStream, promiseAggregator);
            }
            if (!endStream && msg instanceof HttpContent) {
                boolean isLastContent = false;
                HttpHeaders trailers = EmptyHttpHeaders.INSTANCE;
                Http2Headers http2Trailers = EmptyHttp2Headers.INSTANCE;
                if (msg instanceof LastHttpContent) {
                    isLastContent = true;
                    LastHttpContent lastContent = (LastHttpContent)msg;
                    trailers = lastContent.trailingHeaders();
                    http2Trailers = HttpConversionUtil.toHttp2Headers(trailers, this.validateHeaders);
                }
                ByteBuf content = ((HttpContent)msg).content();
                endStream = isLastContent && trailers.isEmpty();
                encoder.writeData(ctx, this.currentStreamId, content, 0, endStream, promiseAggregator.newPromise());
                release = false;
                if (!trailers.isEmpty()) {
                    HttpToHttp2ConnectionHandler.writeHeaders(ctx, encoder, this.currentStreamId, trailers, http2Trailers, true, promiseAggregator);
                }
            }
        }
        catch (Throwable t) {
            this.onError(ctx, true, t);
            promiseAggregator.setFailure(t);
        }
        finally {
            if (release) {
                ReferenceCountUtil.release(msg);
            }
            promiseAggregator.doneAllocatingPromises();
        }
    }

    private static void writeHeaders(ChannelHandlerContext ctx, Http2ConnectionEncoder encoder, int streamId, HttpHeaders headers, Http2Headers http2Headers, boolean endStream, Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator) {
        int dependencyId = headers.getInt(HttpConversionUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), 0);
        short weight = headers.getShort(HttpConversionUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), (short)16);
        encoder.writeHeaders(ctx, streamId, http2Headers, dependencyId, weight, false, 0, endStream, promiseAggregator.newPromise());
    }
}

