/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Descriptors;
import org.apache.hive.kudu.org.apache.kudu.tserver.Tserver;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ResourceMetrics {
    private Map<String, LongAdder> metrics = new ConcurrentHashMap<String, LongAdder>();

    public Map<String, Long> get() {
        return this.metrics.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((LongAdder)e.getValue()).sum()));
    }

    public long getMetric(String name) {
        return this.metrics.getOrDefault(name, new LongAdder()).sum();
    }

    void update(Tserver.ResourceMetricsPB resourceMetricsPb) {
        Preconditions.checkNotNull(resourceMetricsPb);
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : resourceMetricsPb.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor field = entry.getKey();
            if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.LONG) continue;
            this.increment(field.getName(), (Long)entry.getValue());
        }
    }

    private void increment(String name, long amount) {
        this.metrics.computeIfAbsent(name, k -> new LongAdder()).add(amount);
    }
}

