/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.ColumnSchema;
import org.apache.hive.kudu.org.apache.kudu.ColumnTypeAttributes;
import org.apache.hive.kudu.org.apache.kudu.Common;
import org.apache.hive.kudu.org.apache.kudu.Schema;
import org.apache.hive.kudu.org.apache.kudu.Type;
import org.apache.hive.kudu.org.apache.kudu.client.Bytes;
import org.apache.hive.kudu.org.apache.kudu.client.HostAndPort;
import org.apache.hive.kudu.org.apache.kudu.client.Partition;
import org.apache.hive.kudu.org.apache.kudu.client.PartitionSchema;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.hive.kudu.org.apache.kudu.util.DateUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ProtobufHelper {
    public static List<Common.ColumnSchemaPB> schemaToListPb(Schema schema) {
        return ProtobufHelper.schemaToListPb(schema, EnumSet.noneOf(SchemaPBConversionFlags.class));
    }

    public static List<Common.ColumnSchemaPB> schemaToListPb(Schema schema, EnumSet<SchemaPBConversionFlags> flags) {
        ArrayList<Common.ColumnSchemaPB> columns = new ArrayList<Common.ColumnSchemaPB>(schema.getColumnCount());
        Common.ColumnSchemaPB.Builder schemaBuilder = Common.ColumnSchemaPB.newBuilder();
        for (ColumnSchema col : schema.getColumns()) {
            int id = schema.hasColumnIds() ? schema.getColumnId(col.getName()) : -1;
            columns.add(ProtobufHelper.columnToPb(schemaBuilder, id, col, flags));
            schemaBuilder.clear();
        }
        return columns;
    }

    public static Common.SchemaPB schemaToPb(Schema schema) {
        return ProtobufHelper.schemaToPb(schema, EnumSet.noneOf(SchemaPBConversionFlags.class));
    }

    public static Common.SchemaPB schemaToPb(Schema schema, EnumSet<SchemaPBConversionFlags> flags) {
        Common.SchemaPB.Builder builder = Common.SchemaPB.newBuilder();
        builder.addAllColumns(ProtobufHelper.schemaToListPb(schema, flags));
        return builder.build();
    }

    public static Common.ColumnSchemaPB columnToPb(ColumnSchema column) {
        return ProtobufHelper.columnToPb(Common.ColumnSchemaPB.newBuilder(), -1, column);
    }

    public static Common.ColumnSchemaPB columnToPb(Common.ColumnSchemaPB.Builder schemaBuilder, int colId, ColumnSchema column) {
        return ProtobufHelper.columnToPb(schemaBuilder, colId, column, EnumSet.noneOf(SchemaPBConversionFlags.class));
    }

    public static Common.ColumnSchemaPB columnToPb(Common.ColumnSchemaPB.Builder schemaBuilder, int colId, ColumnSchema column, EnumSet<SchemaPBConversionFlags> flags) {
        schemaBuilder.setName(column.getName()).setType(column.getWireType()).setIsKey(column.isKey()).setIsNullable(column.isNullable()).setCfileBlockSize(column.getDesiredBlockSize());
        if (!flags.contains((Object)SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_ID) && colId >= 0) {
            schemaBuilder.setId(colId);
        }
        if (column.getEncoding() != null) {
            schemaBuilder.setEncoding(column.getEncoding().getInternalPbType());
        }
        if (column.getCompressionAlgorithm() != null) {
            schemaBuilder.setCompression(column.getCompressionAlgorithm().getInternalPbType());
        }
        if (column.getDefaultValue() != null) {
            schemaBuilder.setReadDefaultValue(UnsafeByteOperations.unsafeWrap(ProtobufHelper.objectToWireFormat(column, column.getDefaultValue())));
        }
        if (column.getTypeAttributes() != null) {
            schemaBuilder.setTypeAttributes(ProtobufHelper.columnTypeAttributesToPb(Common.ColumnTypeAttributesPB.newBuilder(), column));
        }
        if (!flags.contains((Object)SchemaPBConversionFlags.SCHEMA_PB_WITHOUT_COMMENT) && !column.getComment().isEmpty()) {
            schemaBuilder.setComment(column.getComment());
        }
        return schemaBuilder.build();
    }

    public static Common.ColumnTypeAttributesPB columnTypeAttributesToPb(Common.ColumnTypeAttributesPB.Builder builder, ColumnSchema column) {
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        if (typeAttributes.hasPrecision()) {
            builder.setPrecision(typeAttributes.getPrecision());
        }
        if (typeAttributes.hasScale()) {
            builder.setScale(typeAttributes.getScale());
        }
        if (typeAttributes.hasLength()) {
            builder.setLength(typeAttributes.getLength());
        }
        return builder.build();
    }

    public static ColumnSchema pbToColumnSchema(Common.ColumnSchemaPB pb) {
        Type type = Type.getTypeForDataType(pb.getType());
        ColumnTypeAttributes typeAttributes = pb.hasTypeAttributes() ? ProtobufHelper.pbToColumnTypeAttributes(pb.getTypeAttributes()) : null;
        Object defaultValue = pb.hasWriteDefaultValue() ? ProtobufHelper.byteStringToObject(type, typeAttributes, pb.getWriteDefaultValue()) : null;
        ColumnSchema.Encoding encoding = ColumnSchema.Encoding.valueOf(pb.getEncoding().name());
        ColumnSchema.CompressionAlgorithm compressionAlgorithm = ColumnSchema.CompressionAlgorithm.valueOf(pb.getCompression().name());
        int desiredBlockSize = pb.getCfileBlockSize();
        return new ColumnSchema.ColumnSchemaBuilder(pb.getName(), type).key(pb.getIsKey()).nullable(pb.getIsNullable()).defaultValue(defaultValue).encoding(encoding).compressionAlgorithm(compressionAlgorithm).desiredBlockSize(desiredBlockSize).typeAttributes(typeAttributes).comment(pb.getComment()).build();
    }

    public static ColumnTypeAttributes pbToColumnTypeAttributes(Common.ColumnTypeAttributesPB pb) {
        ColumnTypeAttributes.ColumnTypeAttributesBuilder builder = new ColumnTypeAttributes.ColumnTypeAttributesBuilder();
        if (pb.hasPrecision()) {
            builder.precision(pb.getPrecision());
        }
        if (pb.hasScale()) {
            builder.scale(pb.getScale());
        }
        if (pb.hasLength()) {
            builder.length(pb.getLength());
        }
        return builder.build();
    }

    public static Schema pbToSchema(Common.SchemaPB schema) {
        ArrayList<ColumnSchema> columns = new ArrayList<ColumnSchema>(schema.getColumnsCount());
        ArrayList<Integer> columnIds = new ArrayList<Integer>(schema.getColumnsCount());
        for (Common.ColumnSchemaPB columnPb : schema.getColumnsList()) {
            columns.add(ProtobufHelper.pbToColumnSchema(columnPb));
            int id = columnPb.getId();
            if (id < 0) {
                throw new IllegalArgumentException("Illegal column ID: " + id);
            }
            columnIds.add(id);
        }
        return new Schema(columns, columnIds);
    }

    static PartitionSchema pbToPartitionSchema(Common.PartitionSchemaPB pb, Schema schema) {
        List<Integer> rangeColumns = ProtobufHelper.pbToIds(pb.getRangeSchema().getColumnsList());
        PartitionSchema.RangeSchema rangeSchema = new PartitionSchema.RangeSchema(rangeColumns);
        ImmutableList.Builder hashSchemas = ImmutableList.builder();
        for (Common.PartitionSchemaPB.HashBucketSchemaPB hashBucketSchemaPB : pb.getHashBucketSchemasList()) {
            List<Integer> hashColumnIds = ProtobufHelper.pbToIds(hashBucketSchemaPB.getColumnsList());
            PartitionSchema.HashBucketSchema hashSchema = new PartitionSchema.HashBucketSchema(hashColumnIds, hashBucketSchemaPB.getNumBuckets(), hashBucketSchemaPB.getSeed());
            hashSchemas.add(hashSchema);
        }
        return new PartitionSchema(rangeSchema, (List<PartitionSchema.HashBucketSchema>)((Object)hashSchemas.build()), schema);
    }

    static Partition pbToPartition(Common.PartitionPB pb) {
        return new Partition(pb.getPartitionKeyStart().toByteArray(), pb.getPartitionKeyEnd().toByteArray(), pb.getHashBucketsList());
    }

    private static List<Integer> pbToIds(List<Common.PartitionSchemaPB.ColumnIdentifierPB> columnIdentifiers) {
        ImmutableList.Builder columnIds = ImmutableList.builder();
        block5: for (Common.PartitionSchemaPB.ColumnIdentifierPB column : columnIdentifiers) {
            switch (column.getIdentifierCase()) {
                case ID: {
                    columnIds.add((Object)column.getId());
                    continue block5;
                }
                case NAME: {
                    throw new IllegalArgumentException(String.format("Expected column ID from master: %s", column));
                }
                case IDENTIFIER_NOT_SET: {
                    throw new IllegalArgumentException("Unknown column: " + column);
                }
            }
            throw new IllegalArgumentException("Unknown identifier type!");
        }
        return columnIds.build();
    }

    private static byte[] objectToWireFormat(ColumnSchema col, Object value) {
        switch (col.getType()) {
            case BOOL: {
                return Bytes.fromBoolean((Boolean)value);
            }
            case INT8: {
                return new byte[]{(Byte)value};
            }
            case INT16: {
                return Bytes.fromShort((Short)value);
            }
            case DATE: {
                return Bytes.fromInt(DateUtil.sqlDateToEpochDays((Date)value));
            }
            case INT32: {
                return Bytes.fromInt((Integer)value);
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                return Bytes.fromLong((Long)value);
            }
            case VARCHAR: 
            case STRING: {
                return ((String)value).getBytes(StandardCharsets.UTF_8);
            }
            case BINARY: {
                return (byte[])value;
            }
            case FLOAT: {
                return Bytes.fromFloat(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Bytes.fromDouble((Double)value);
            }
            case DECIMAL: {
                return Bytes.fromBigDecimal((BigDecimal)value, col.getTypeAttributes().getPrecision());
            }
        }
        throw new IllegalArgumentException("The column " + col.getName() + " is of type " + (Object)((Object)col.getType()) + " which is unknown");
    }

    private static Object byteStringToObject(Type type, ColumnTypeAttributes typeAttributes, ByteString value) {
        ByteBuffer buf = value.asReadOnlyByteBuffer();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        switch (type) {
            case BOOL: {
                return buf.get() != 0;
            }
            case INT8: {
                return buf.get();
            }
            case INT16: {
                return buf.getShort();
            }
            case DATE: {
                return DateUtil.epochDaysToSqlDate(buf.getInt());
            }
            case INT32: {
                return buf.getInt();
            }
            case INT64: 
            case UNIXTIME_MICROS: {
                return buf.getLong();
            }
            case FLOAT: {
                return Float.valueOf(buf.getFloat());
            }
            case DOUBLE: {
                return buf.getDouble();
            }
            case VARCHAR: 
            case STRING: {
                return value.toStringUtf8();
            }
            case BINARY: {
                return value.toByteArray();
            }
            case DECIMAL: {
                return Bytes.getDecimal(value.toByteArray(), typeAttributes.getPrecision(), typeAttributes.getScale());
            }
        }
        throw new IllegalArgumentException("This type is unknown: " + (Object)((Object)type));
    }

    protected static ByteString objectToByteStringNoType(String colName, Object value) {
        byte[] bytes;
        if (value instanceof Boolean) {
            bytes = Bytes.fromBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            bytes = new byte[]{(Byte)value};
        } else if (value instanceof Short) {
            bytes = Bytes.fromShort((Short)value);
        } else if (value instanceof Integer) {
            bytes = Bytes.fromInt((Integer)value);
        } else if (value instanceof Long) {
            bytes = Bytes.fromLong((Long)value);
        } else if (value instanceof String) {
            bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
        } else if (value instanceof byte[]) {
            bytes = (byte[])value;
        } else if (value instanceof ByteBuffer) {
            bytes = ((ByteBuffer)value).array();
        } else if (value instanceof Float) {
            bytes = Bytes.fromFloat(((Float)value).floatValue());
        } else if (value instanceof Double) {
            bytes = Bytes.fromDouble((Double)value);
        } else if (value instanceof BigDecimal) {
            bytes = Bytes.fromBigDecimal((BigDecimal)value, 38);
        } else {
            throw new IllegalArgumentException("The default value provided for column " + colName + " is of class " + value.getClass().getName() + " which does not map to a supported Kudu type");
        }
        return UnsafeByteOperations.unsafeWrap(bytes);
    }

    public static Common.HostPortPB hostAndPortToPB(HostAndPort hostAndPort) {
        return Common.HostPortPB.newBuilder().setHost(hostAndPort.getHost()).setPort(hostAndPort.getPort()).build();
    }

    public static HostAndPort hostAndPortFromPB(Common.HostPortPB hostPortPB) {
        return new HostAndPort(hostPortPB.getHost(), hostPortPB.getPort());
    }

    public static String hostPortPbListToString(List<Common.HostPortPB> pbs) {
        ArrayList<String> strs = new ArrayList<String>(pbs.size());
        for (Common.HostPortPB pb : pbs) {
            strs.add(pb.getHost() + ":" + pb.getPort());
        }
        return Joiner.on(',').join(strs);
    }

    public static enum SchemaPBConversionFlags {
        SCHEMA_PB_WITHOUT_COMMENT,
        SCHEMA_PB_WITHOUT_ID;

    }
}

