/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hive.kudu.com.stumbleupon.async.Deferred;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.CallResponse;
import org.apache.hive.kudu.org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.hive.kudu.org.apache.kudu.client.IPCUtil;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduTable;
import org.apache.hive.kudu.org.apache.kudu.client.NonRecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.RemoteTablet;
import org.apache.hive.kudu.org.apache.kudu.client.ReplicaSelection;
import org.apache.hive.kudu.org.apache.kudu.client.RpcTraceFrame;
import org.apache.hive.kudu.org.apache.kudu.client.Statistics;
import org.apache.hive.kudu.org.apache.kudu.client.Status;
import org.apache.hive.kudu.org.apache.kudu.client.TimeoutTracker;
import org.apache.hive.kudu.org.apache.kudu.security.Token;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.buffer.ByteBuf;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.buffer.ByteBufOutputStream;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timeout;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.TimerTask;
import org.apache.hive.kudu.org.apache.kudu.util.Pair;
import org.apache.hive.kudu.org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class KuduRpc<R> {
    @InterfaceAudience.LimitedPrivate(value={"Test"})
    public static final int MAX_TRACES_SIZE = 100;
    static final int MAX_RPC_SIZE = 0x10000000;
    protected static final String MASTER_SERVICE_NAME = "kudu.master.MasterService";
    protected static final String TABLET_SERVER_SERVICE_NAME = "kudu.tserver.TabletServerService";
    private static final Logger LOG = LoggerFactory.getLogger(KuduRpc.class);
    private final List<RpcTraceFrame> traces = Collections.synchronizedList(new ArrayList());
    private KuduRpc<?> parentRpc;
    private Deferred<R> deferred;
    private RemoteTablet tablet;
    final KuduTable table;
    final TimeoutTracker timeoutTracker;
    Timeout timeoutTask;
    long propagatedTimestamp = -1L;
    ExternalConsistencyMode externalConsistencyMode = ExternalConsistencyMode.CLIENT_PROPAGATED;
    int attempt;
    private long sequenceId = -1L;

    byte[] partitionKey() {
        return null;
    }

    void bindAuthzToken(Token.SignedTokenPB token) {
    }

    boolean needsAuthzToken() {
        return false;
    }

    KuduRpc(KuduTable table, Timer timer, long timeoutMillis) {
        this.table = table;
        this.timeoutTracker = new TimeoutTracker();
        this.timeoutTracker.setTimeout(timeoutMillis);
        if (timer != null) {
            this.timeoutTask = AsyncKuduClient.newTimeout(timer, new RpcTimeoutTask(), timeoutMillis);
        }
    }

    abstract Message createRequestPB();

    abstract String serviceName();

    abstract String method();

    Collection<Integer> getRequiredFeatures() {
        return ImmutableList.of();
    }

    abstract Pair<R, Object> deserialize(CallResponse var1, String var2) throws KuduException;

    void updateStatistics(Statistics statistics, R response) {
    }

    public void setExternalConsistencyMode(ExternalConsistencyMode externalConsistencyMode) {
        this.externalConsistencyMode = externalConsistencyMode;
    }

    public ExternalConsistencyMode getExternalConsistencyMode() {
        return this.externalConsistencyMode;
    }

    public void setPropagatedTimestamp(long propagatedTimestamp) {
        this.propagatedTimestamp = propagatedTimestamp;
    }

    private void handleCallback(Object result) {
        Deferred<R> d = this.deferred;
        if (d == null) {
            LOG.debug("Handling a callback on RPC {} with no deferred attached!", (Object)this);
            return;
        }
        this.deferred = null;
        this.attempt = 0;
        if (this.isRequestTracked() && this.sequenceId != -1L) {
            this.table.getAsyncClient().getRequestTracker().rpcCompleted(this.sequenceId);
            this.sequenceId = -1L;
        }
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.timeoutTracker.reset();
        this.traces.clear();
        this.parentRpc = null;
        d.callback(result);
    }

    void addTrace(RpcTraceFrame rpcTraceFrame) {
        if (this.parentRpc != null) {
            this.parentRpc.addTrace(rpcTraceFrame);
        }
        if (this.traces.size() == 100) {
            this.traces.add(new RpcTraceFrame.RpcTraceFrameBuilder(this.method(), RpcTraceFrame.Action.TRACE_TRUNCATED).build());
        } else if (this.traces.size() < 100) {
            this.traces.add(rpcTraceFrame);
        }
    }

    void setParentRpc(KuduRpc<?> parentRpc) {
        assert (this.parentRpc == null);
        assert (this != parentRpc);
        this.parentRpc = parentRpc;
    }

    final void callback(R result) {
        this.handleCallback(result);
    }

    final void errback(Exception e) {
        this.handleCallback(e);
    }

    final Deferred<R> getDeferred() {
        if (this.deferred == null) {
            this.deferred = new Deferred();
        }
        return this.deferred;
    }

    boolean hasDeferred() {
        return this.deferred != null;
    }

    RemoteTablet getTablet() {
        return this.tablet;
    }

    void setTablet(RemoteTablet tablet) {
        this.tablet = tablet;
    }

    public KuduTable getTable() {
        return this.table;
    }

    boolean isRequestTracked() {
        return false;
    }

    long getSequenceId() {
        return this.sequenceId;
    }

    ReplicaSelection getReplicaSelection() {
        return ReplicaSelection.LEADER_ONLY;
    }

    List<RpcTraceFrame> getImmutableTraces() {
        return ImmutableList.copyOf(this.traces);
    }

    void setSequenceId(long sequenceId) {
        assert (this.sequenceId == -1L);
        this.sequenceId = sequenceId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("KuduRpc(method=");
        buf.append(this.method());
        buf.append(", tablet=");
        if (this.tablet == null) {
            buf.append("null");
        } else {
            buf.append(this.tablet.getTabletId());
        }
        buf.append(", attempt=").append(this.attempt);
        buf.append(", ").append(this.timeoutTracker);
        if (LOG.isDebugEnabled()) {
            buf.append(", ").append(RpcTraceFrame.getHumanReadableStringForTraces(this.traces));
            buf.append(", deferred=").append(this.deferred);
        } else {
            buf.append(", ").append(RpcTraceFrame.getHumanReadableSummaryStringForTraces(this.traces));
        }
        buf.append(')');
        return buf.toString();
    }

    static void readProtobuf(Slice slice, Message.Builder builder) {
        int length = slice.length();
        byte[] payload = slice.getRawArray();
        int offset = slice.getRawOffset();
        try {
            builder.mergeFrom(payload, offset, length);
            if (!builder.isInitialized()) {
                throw new RuntimeException("Could not deserialize the response, incompatible RPC? Error is: " + builder.getInitializationErrorString());
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Invalid RPC response: length=" + length, e);
        }
    }

    static void toByteBuf(ByteBuf out, Message header, Message pb) {
        int totalSize = IPCUtil.getTotalSizeWhenWrittenDelimited(header, pb);
        out.capacity(totalSize + 4);
        out.writeInt(totalSize);
        try (ByteBufOutputStream bos = new ByteBufOutputStream(out);){
            CodedOutputStream cos = CodedOutputStream.newInstance(bos, totalSize);
            cos.writeUInt32NoTag(header.getSerializedSize());
            header.writeTo(cos);
            cos.writeUInt32NoTag(pb.getSerializedSize());
            pb.writeTo(cos);
            cos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot serialize the following message " + pb);
        }
    }

    final class RpcTimeoutTask
    implements TimerTask {
        RpcTimeoutTask() {
        }

        @Override
        public void run(Timeout timeout) {
            Status statusTimedOut = Status.TimedOut("cannot complete before timeout: " + KuduRpc.this);
            KuduRpc.this.errback(new NonRecoverableException(statusTimedOut));
        }
    }
}

