/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpcResponse;
import org.apache.hive.kudu.org.apache.kudu.client.Operation;
import org.apache.hive.kudu.org.apache.kudu.client.OperationResponse;
import org.apache.hive.kudu.org.apache.kudu.client.RowError;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.tserver.Tserver;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BatchResponse
extends KuduRpcResponse {
    private final long writeTimestamp;
    private final List<RowError> rowErrors;
    private final List<OperationResponse> individualResponses;
    private final List<Integer> responsesIndexes;

    BatchResponse(long elapsedMillis, String tsUUID, long writeTimestamp, List<Tserver.WriteResponsePB.PerRowErrorPB> errorsPB, List<Operation> operations, List<Integer> indexes) {
        super(elapsedMillis, tsUUID);
        this.writeTimestamp = writeTimestamp;
        this.individualResponses = new ArrayList<OperationResponse>(operations.size());
        this.responsesIndexes = indexes;
        this.rowErrors = errorsPB.isEmpty() ? Collections.emptyList() : new ArrayList<RowError>(errorsPB.size());
        int currentErrorIndex = 0;
        for (int i = 0; i < operations.size(); ++i) {
            RowError rowError = null;
            Operation currentOperation = operations.get(i);
            if (currentErrorIndex < errorsPB.size() && errorsPB.get(currentErrorIndex).getRowIndex() == i) {
                rowError = RowError.fromRowErrorPb(errorsPB.get(currentErrorIndex), currentOperation, tsUUID);
                this.rowErrors.add(rowError);
                ++currentErrorIndex;
            }
            this.individualResponses.add(new OperationResponse(currentOperation.timeoutTracker.getElapsedMillis(), tsUUID, writeTimestamp, currentOperation, rowError));
        }
        assert (this.rowErrors.size() == errorsPB.size());
        assert (this.individualResponses.size() == operations.size());
        assert (this.individualResponses.size() == this.responsesIndexes.size());
    }

    BatchResponse(List<OperationResponse> individualResponses, List<Integer> indexes) {
        super(0L, null);
        this.writeTimestamp = 0L;
        this.rowErrors = ImmutableList.of();
        this.individualResponses = individualResponses;
        this.responsesIndexes = indexes;
    }

    public long getWriteTimestamp() {
        return this.writeTimestamp;
    }

    List<OperationResponse> getIndividualResponses() {
        return this.individualResponses;
    }

    List<Integer> getResponseIndexes() {
        return this.responsesIndexes;
    }
}

