/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hive.kudu.com.stumbleupon.async.Callback;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.GetTableSchemaRequest;
import org.apache.hive.kudu.org.apache.kudu.client.GetTableSchemaResponse;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.KuduRpc;
import org.apache.hive.kudu.org.apache.kudu.client.NonRecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.RecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.Status;
import org.apache.hive.kudu.org.apache.kudu.security.Token;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@ThreadSafe
public class AuthzTokenCache {
    private static final Logger LOG = LoggerFactory.getLogger(AuthzTokenCache.class);
    private final AsyncKuduClient client;
    private final ConcurrentHashMap<String, Token.SignedTokenPB> authzTokens = new ConcurrentHashMap();
    @GuardedBy(value="retriesLock")
    private final Map<String, List<RpcAndException>> retriesForTable = new HashMap<String, List<RpcAndException>>();
    private final Object retriesLock = new Object();
    private AtomicInteger numRetrievalsSent;

    AuthzTokenCache(@Nonnull AsyncKuduClient client) {
        this.client = client;
        this.numRetrievalsSent = new AtomicInteger(0);
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    int numRetrievalsSent() {
        return this.numRetrievalsSent.get();
    }

    void put(@Nonnull String tableId, @Nonnull Token.SignedTokenPB token) {
        this.authzTokens.put(tableId, token);
    }

    Token.SignedTokenPB get(@Nonnull String tableId) {
        return this.authzTokens.get(tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RpcAndException> clearPendingRetries(@Nonnull String tableId) {
        List<RpcAndException> pendingRetries;
        Object object = this.retriesLock;
        synchronized (object) {
            pendingRetries = this.retriesForTable.remove(tableId);
        }
        Preconditions.checkState(!pendingRetries.isEmpty(), "no pending retries for table " + tableId);
        return pendingRetries;
    }

    private void sendRetrievalForRpc(@Nonnull KuduRpc<?> parentRpc, @Nonnull Callback<Void, GetTableSchemaResponse> cb, @Nonnull Callback<Void, Exception> eb) {
        String tableId = parentRpc.getTable().getTableId();
        LOG.debug("sending RPC to retrieve token for table ID " + tableId);
        GetTableSchemaRequest retrieveAuthzTokenReq = new GetTableSchemaRequest(this.client.getMasterTable(), tableId, null, this.client.getTimer(), this.client.getDefaultAdminOperationTimeoutMs(), true);
        retrieveAuthzTokenReq.setParentRpc(parentRpc);
        retrieveAuthzTokenReq.timeoutTracker.setTimeout(parentRpc.timeoutTracker.getTimeout());
        this.numRetrievalsSent.incrementAndGet();
        this.client.sendRpcToTablet(retrieveAuthzTokenReq).addCallback(cb).addErrback(eb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> void retrieveAuthzToken(@Nonnull KuduRpc<R> rpc, @Nonnull KuduException ex) {
        String tableId = rpc.getTable().getTableId();
        RpcAndException rpcAndEx = new RpcAndException(rpc, ex);
        Object object = this.retriesLock;
        synchronized (object) {
            List pendingRetries = this.retriesForTable.putIfAbsent(tableId, new ArrayList<RpcAndException>(Arrays.asList(rpcAndEx)));
            if (pendingRetries == null) {
                final class NewAuthzTokenCB
                implements Callback<Void, GetTableSchemaResponse> {
                    private final String tableId;

                    public NewAuthzTokenCB(String tableId) {
                        this.tableId = tableId;
                    }

                    @Override
                    public Void call(@Nonnull GetTableSchemaResponse resp) throws Exception {
                        if (resp.getAuthzToken() == null) {
                            throw new NonRecoverableException(Status.InvalidArgument("no authz token retrieved for " + this.tableId));
                        }
                        LOG.debug("retrieved authz token for " + this.tableId);
                        AuthzTokenCache.this.put(this.tableId, resp.getAuthzToken());
                        for (RpcAndException rpcAndEx : AuthzTokenCache.this.clearPendingRetries(this.tableId)) {
                            AuthzTokenCache.this.client.handleRetryableErrorNoDelay(rpcAndEx.rpc, rpcAndEx.ex);
                        }
                        return null;
                    }
                }
                NewAuthzTokenCB newTokenCB = new NewAuthzTokenCB(tableId);
                final class NewAuthzTokenErrB
                implements Callback<Void, Exception> {
                    private KuduRpc<?> parentRpc;
                    private final NewAuthzTokenCB cb;

                    public NewAuthzTokenErrB(@Nonnull NewAuthzTokenCB cb, KuduRpc<?> parentRpc) {
                        this.cb = cb;
                        this.parentRpc = parentRpc;
                    }

                    @Override
                    public Void call(@Nonnull Exception e) {
                        String tableId = this.cb.tableId;
                        if (e instanceof RecoverableException) {
                            AuthzTokenCache.this.sendRetrievalForRpc(this.parentRpc, this.cb, this);
                        } else {
                            for (RpcAndException rpcAndEx : AuthzTokenCache.this.clearPendingRetries(tableId)) {
                                rpcAndEx.rpc.errback(e);
                            }
                        }
                        return null;
                    }
                }
                NewAuthzTokenErrB newTokenErrB = new NewAuthzTokenErrB(newTokenCB, rpc);
                this.sendRetrievalForRpc(rpc, newTokenCB, newTokenErrB);
            } else {
                Preconditions.checkState(!pendingRetries.isEmpty(), "no pending retries for table " + tableId);
                pendingRetries.add(rpcAndEx);
            }
        }
    }

    private static class RpcAndException {
        final KuduRpc<?> rpc;
        final KuduException ex;

        RpcAndException(KuduRpc<?> rpc, KuduException ex) {
            this.rpc = rpc;
            this.ex = ex;
        }
    }
}

