/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.kudu.org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hive.kudu.com.stumbleupon.async.Callback;
import org.apache.hive.kudu.com.stumbleupon.async.Deferred;
import org.apache.hive.kudu.org.apache.kudu.client.AsyncKuduClient;
import org.apache.hive.kudu.org.apache.kudu.client.Batch;
import org.apache.hive.kudu.org.apache.kudu.client.BatchResponse;
import org.apache.hive.kudu.org.apache.kudu.client.ErrorCollector;
import org.apache.hive.kudu.org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.hive.kudu.org.apache.kudu.client.KuduException;
import org.apache.hive.kudu.org.apache.kudu.client.LocatedTablet;
import org.apache.hive.kudu.org.apache.kudu.client.NonCoveredRangeException;
import org.apache.hive.kudu.org.apache.kudu.client.NonRecoverableException;
import org.apache.hive.kudu.org.apache.kudu.client.Operation;
import org.apache.hive.kudu.org.apache.kudu.client.OperationResponse;
import org.apache.hive.kudu.org.apache.kudu.client.PleaseThrottleException;
import org.apache.hive.kudu.org.apache.kudu.client.RowError;
import org.apache.hive.kudu.org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.hive.kudu.org.apache.kudu.client.SessionConfiguration;
import org.apache.hive.kudu.org.apache.kudu.client.Status;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.MoreObjects;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.hive.kudu.org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.Timeout;
import org.apache.hive.kudu.org.apache.kudu.shaded.io.netty.util.TimerTask;
import org.apache.hive.kudu.org.apache.kudu.util.AsyncUtil;
import org.apache.hive.kudu.org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@NotThreadSafe
public class AsyncKuduSession
implements SessionConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(AsyncKuduSession.class);
    private final AsyncKuduClient client;
    private final Random randomizer = new Random();
    private final ErrorCollector errorCollector;
    private int flushIntervalMillis = 1000;
    private int mutationBufferMaxOps = 1000;
    private SessionConfiguration.FlushMode flushMode;
    private ExternalConsistencyMode consistencyMode;
    private long timeoutMillis;
    private final Object monitor = new Object();
    @GuardedBy(value="monitor")
    private Buffer activeBuffer;
    private final Buffer bufferA = new Buffer();
    private final Buffer bufferB = new Buffer();
    private final BlockingQueue<Buffer> inactiveBuffers = new ArrayBlockingQueue<Buffer>(2, false);
    private final AtomicReference<Deferred<Void>> flushNotification = new AtomicReference(new Deferred());
    private volatile boolean closed = false;
    private boolean ignoreAllDuplicateRows = false;
    private boolean ignoreAllNotFoundRows = false;

    AsyncKuduSession(AsyncKuduClient client) {
        this.client = client;
        this.flushMode = SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC;
        this.consistencyMode = ExternalConsistencyMode.CLIENT_PROPAGATED;
        this.timeoutMillis = client.getDefaultOperationTimeoutMs();
        this.inactiveBuffers.add(this.bufferA);
        this.inactiveBuffers.add(this.bufferB);
        this.errorCollector = new ErrorCollector(this.mutationBufferMaxOps);
    }

    @Override
    public SessionConfiguration.FlushMode getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(SessionConfiguration.FlushMode flushMode) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change flush mode when writes are buffered");
        }
        this.flushMode = flushMode;
    }

    @Override
    public void setExternalConsistencyMode(ExternalConsistencyMode consistencyMode) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change consistency mode when writes are buffered");
        }
        this.consistencyMode = consistencyMode;
    }

    @Override
    public void setMutationBufferSpace(int numOps) {
        if (this.hasPendingOperations()) {
            throw new IllegalArgumentException("Cannot change the buffer size when operations are buffered");
        }
        this.mutationBufferMaxOps = numOps;
    }

    @Override
    @Deprecated
    public void setMutationBufferLowWatermark(float mutationBufferLowWatermarkPercentage) {
        LOG.warn("setMutationBufferLowWatermark is deprecated");
    }

    @InterfaceAudience.LimitedPrivate(value={"Test"})
    void setRandomSeed(long seed) {
        this.randomizer.setSeed(seed);
    }

    @Override
    public void setFlushInterval(int flushIntervalMillis) {
        this.flushIntervalMillis = flushIntervalMillis;
    }

    @Override
    public void setTimeoutMillis(long timeout) {
        this.timeoutMillis = timeout;
    }

    @Override
    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isIgnoreAllDuplicateRows() {
        return this.ignoreAllDuplicateRows;
    }

    @Override
    public void setIgnoreAllDuplicateRows(boolean ignoreAllDuplicateRows) {
        this.ignoreAllDuplicateRows = ignoreAllDuplicateRows;
    }

    @Override
    public boolean isIgnoreAllNotFoundRows() {
        return this.ignoreAllNotFoundRows;
    }

    @Override
    public void setIgnoreAllNotFoundRows(boolean ignoreAllNotFoundRows) {
        this.ignoreAllNotFoundRows = ignoreAllNotFoundRows;
    }

    @Override
    public int countPendingErrors() {
        return this.errorCollector.countErrors();
    }

    @Override
    public RowErrorsAndOverflowStatus getPendingErrors() {
        return this.errorCollector.getErrors();
    }

    public Deferred<List<OperationResponse>> close() {
        if (!this.closed) {
            this.closed = true;
            this.client.removeSession(this);
        }
        return this.flush();
    }

    private void queueBuffer(Buffer buffer) {
        this.inactiveBuffers.add(buffer);
        buffer.callbackFlushNotification();
        Deferred localFlushNotification = this.flushNotification.getAndSet(new Deferred());
        localFlushNotification.callback(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<List<OperationResponse>> flush() {
        Buffer buffer;
        Deferred<Void> nonActiveBufferFlush;
        Object object = this.monitor;
        synchronized (object) {
            nonActiveBufferFlush = this.getNonActiveFlushNotificationUnlocked();
            buffer = this.retireActiveBufferUnlocked();
        }
        return AsyncUtil.addBothDeferring(nonActiveBufferFlush, unused -> this.doFlush(buffer));
    }

    private Deferred<List<OperationResponse>> doFlush(Buffer buffer) {
        if (buffer == null || buffer.getOperations().isEmpty()) {
            return Deferred.fromResult(ImmutableList.of());
        }
        LOG.debug("flushing buffer: {}", (Object)buffer);
        Deferred<List<BatchResponse>> batchResponses = new Deferred<List<BatchResponse>>();
        TabletLookupCB tabletLookupCB = new TabletLookupCB(buffer, batchResponses);
        for (BufferedOperation bufferedOperation : buffer.getOperations()) {
            AsyncUtil.addBoth(bufferedOperation.getTabletLookup(), tabletLookupCB);
        }
        return batchResponses.addCallback(ConvertBatchToListOfResponsesCB.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingOperations() {
        Object object = this.monitor;
        synchronized (object) {
            return this.activeBuffer == null ? this.inactiveBuffers.size() < 2 : this.activeBuffer.getOperations().size() > 0 || !this.inactiveBufferAvailable();
        }
    }

    private Deferred<OperationResponse> doAutoFlushSync(Operation operation) {
        if (this.timeoutMillis != 0L) {
            operation.resetTimeoutMillis(this.client.getTimer(), this.timeoutMillis);
        }
        operation.setExternalConsistencyMode(this.consistencyMode);
        operation.setIgnoreAllDuplicateRows(this.ignoreAllDuplicateRows);
        operation.setIgnoreAllNotFoundRows(this.ignoreAllNotFoundRows);
        return this.client.sendRpcToTablet(operation).addCallbackDeferring(resp -> {
            this.client.updateLastPropagatedTimestamp(resp.getWriteTimestampRaw());
            return Deferred.fromResult(resp);
        }).addErrback(new SingleOperationErrCallback(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<OperationResponse> apply(Operation operation) throws KuduException {
        Preconditions.checkNotNull(operation, "Cannot apply a null operation");
        Preconditions.checkArgument(operation.getTable().getAsyncClient() == this.client, "Applied operations must be created from a KuduTable instance opened from the same client that opened this KuduSession");
        if (this.closed) {
            LOG.warn("Applying an operation in a closed session; this is unsafe");
        }
        operation.getRow().freeze();
        if (this.flushMode == SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC) {
            return this.doAutoFlushSync(operation);
        }
        Deferred<LocatedTablet> tablet = this.client.getTabletLocation(operation.getTable(), operation.partitionKey(), AsyncKuduClient.LookupType.POINT, this.timeoutMillis);
        Buffer fullBuffer = null;
        try {
            Object object = this.monitor;
            synchronized (object) {
                Deferred<Void> notification = this.flushNotification.get();
                if (this.activeBuffer == null) {
                    if (this.inactiveBufferAvailable()) {
                        this.refreshActiveBufferUnlocked();
                    } else {
                        Status statusServiceUnavailable = Status.ServiceUnavailable("all buffers are currently flushing");
                        throw new PleaseThrottleException(statusServiceUnavailable, null, operation, notification);
                    }
                }
                int activeBufferSize = this.activeBuffer.getOperations().size();
                switch (this.flushMode) {
                    case AUTO_FLUSH_SYNC: {
                        assert (false);
                        break;
                    }
                    case MANUAL_FLUSH: {
                        if (activeBufferSize >= this.mutationBufferMaxOps) {
                            Status statusIllegalState = Status.IllegalState("MANUAL_FLUSH is enabled but the buffer is too big");
                            throw new NonRecoverableException(statusIllegalState);
                        }
                        this.activeBuffer.getOperations().add(new BufferedOperation(tablet, operation));
                        break;
                    }
                    case AUTO_FLUSH_BACKGROUND: {
                        if (activeBufferSize >= this.mutationBufferMaxOps) {
                            fullBuffer = this.retireActiveBufferUnlocked();
                            activeBufferSize = 0;
                            if (!this.inactiveBufferAvailable()) {
                                Status statusServiceUnavailable = Status.ServiceUnavailable("All buffers are currently flushing");
                                throw new PleaseThrottleException(statusServiceUnavailable, null, operation, notification);
                            }
                            this.refreshActiveBufferUnlocked();
                        }
                        this.activeBuffer.getOperations().add(new BufferedOperation(tablet, operation));
                        if (activeBufferSize == 0) {
                            AsyncKuduClient.newTimeout(this.client.getTimer(), this.activeBuffer.getFlusherTask(), this.flushIntervalMillis);
                        }
                        if (activeBufferSize + 1 < this.mutationBufferMaxOps || !this.inactiveBufferAvailable()) break;
                        fullBuffer = this.retireActiveBufferUnlocked();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected flushMode: " + (Object)((Object)this.flushMode));
                    }
                }
            }
            this.doFlush(fullBuffer);
        }
        catch (Throwable throwable) {
            this.doFlush(fullBuffer);
            throw throwable;
        }
        return operation.getDeferred();
    }

    private boolean inactiveBufferAvailable() {
        return this.inactiveBuffers.peek() != null;
    }

    @GuardedBy(value="monitor")
    private void refreshActiveBufferUnlocked() {
        Preconditions.checkState(this.activeBuffer == null);
        this.activeBuffer = (Buffer)this.inactiveBuffers.remove();
        this.activeBuffer.resetUnlocked();
    }

    @GuardedBy(value="monitor")
    private Buffer retireActiveBufferUnlocked() {
        Buffer buffer = this.activeBuffer;
        this.activeBuffer = null;
        return buffer;
    }

    @GuardedBy(value="monitor")
    private Deferred<Void> getNonActiveFlushNotificationUnlocked() {
        Deferred<Void> notificationA = this.bufferA.getFlushNotification();
        Deferred<Void> notificationB = this.bufferB.getFlushNotification();
        if (this.activeBuffer == null) {
            return AsyncUtil.addBothDeferring(notificationA, unused -> notificationB);
        }
        if (this.activeBuffer == this.bufferA) {
            return notificationB;
        }
        return notificationA;
    }

    private void addBatchCallbacks(final Batch request) {
        final class BatchCallback
        implements Callback<BatchResponse, BatchResponse> {
            BatchCallback() {
            }

            @Override
            public BatchResponse call(BatchResponse response) {
                LOG.trace("Got a Batch response for {} rows", (Object)request.operations.size());
                AsyncKuduSession.this.client.updateLastPropagatedTimestamp(response.getWriteTimestamp());
                for (OperationResponse operationResponse : response.getIndividualResponses()) {
                    if (AsyncKuduSession.this.flushMode == SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND && operationResponse.hasRowError()) {
                        AsyncKuduSession.this.errorCollector.addError(operationResponse.getRowError());
                    }
                    operationResponse.getOperation().callback(operationResponse);
                }
                return response;
            }

            public String toString() {
                return "apply batch response";
            }
        }
        final class BatchErrCallback
        implements Callback<Object, Exception> {
            BatchErrCallback() {
            }

            @Override
            public Object call(Exception e) {
                Status status = null;
                ArrayList<OperationResponse> responses = null;
                boolean handleKuduException = e instanceof KuduException;
                if (handleKuduException) {
                    status = ((KuduException)e).getStatus();
                    responses = new ArrayList<OperationResponse>(request.operations.size());
                }
                for (Operation operation : request.operations) {
                    if (handleKuduException) {
                        RowError rowError = new RowError(status, operation);
                        OperationResponse response = new OperationResponse(0L, null, 0L, operation, rowError);
                        AsyncKuduSession.this.errorCollector.addError(rowError);
                        responses.add(response);
                        operation.callback(response);
                        continue;
                    }
                    operation.errback(e);
                }
                return handleKuduException ? new BatchResponse(responses, request.operationIndexes) : e;
            }

            public String toString() {
                return "apply batch error response";
            }
        }
        request.getDeferred().addCallbacks(new BatchCallback(), new BatchErrCallback());
    }

    private static final class BufferedOperation {
        private Object tablet = null;
        private final Deferred<Void> tabletLookup;
        private final Operation operation;

        public BufferedOperation(Deferred<LocatedTablet> tablet, Operation operation) {
            this.tabletLookup = AsyncUtil.addBoth(tablet, new Callback<Void, Object>(){

                @Override
                public Void call(Object tablet) {
                    tablet = tablet;
                    return null;
                }
            });
            this.operation = Preconditions.checkNotNull(operation);
        }

        public boolean tabletLookupFailed() {
            return !(this.tablet instanceof LocatedTablet);
        }

        public LocatedTablet getTablet() {
            return (LocatedTablet)this.tablet;
        }

        public Exception getTabletLookupFailure() {
            return (Exception)this.tablet;
        }

        public Deferred<Void> getTabletLookup() {
            return this.tabletLookup;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("tablet", this.tablet).add("operation", this.operation).toString();
        }
    }

    private final class Buffer {
        private final List<BufferedOperation> operations = new ArrayList<BufferedOperation>();
        private FlusherTask flusherTask = null;
        private Deferred<Void> flushNotification = Deferred.fromResult(null);

        private Buffer() {
        }

        public List<BufferedOperation> getOperations() {
            return this.operations;
        }

        @GuardedBy(value="monitor")
        FlusherTask getFlusherTask() {
            if (this.flusherTask == null) {
                this.flusherTask = new FlusherTask();
            }
            return this.flusherTask;
        }

        Deferred<Void> getFlushNotification() {
            return this.flushNotification;
        }

        void callbackFlushNotification() {
            LOG.trace("buffer flush notification fired: {}", (Object)this);
            this.flushNotification.callback(null);
        }

        @GuardedBy(value="monitor")
        void resetUnlocked() {
            LOG.trace("buffer resetUnlocked: {}", (Object)this);
            this.operations.clear();
            this.flushNotification = new Deferred();
            this.flusherTask = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("operations", this.operations.size()).add("flusherTask", this.flusherTask).add("flushNotification", this.flushNotification).toString();
        }
    }

    private final class FlusherTask
    implements TimerTask {
        private FlusherTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(Timeout timeout) {
            Buffer buffer = null;
            Object object = AsyncKuduSession.this.monitor;
            synchronized (object) {
                if (AsyncKuduSession.this.activeBuffer == null) {
                    return;
                }
                if (AsyncKuduSession.this.activeBuffer.getFlusherTask() == this) {
                    buffer = AsyncKuduSession.this.retireActiveBufferUnlocked();
                }
            }
            AsyncKuduSession.this.doFlush(buffer);
        }
    }

    private static final class SingleOperationErrCallback
    implements Callback<Object, Exception> {
        private final Operation operation;

        private SingleOperationErrCallback(Operation operation) {
            this.operation = operation;
        }

        @Override
        public Object call(Exception e) throws Exception {
            if (e instanceof KuduException) {
                Status status = ((KuduException)e).getStatus();
                RowError rowError = new RowError(status, this.operation);
                return new OperationResponse(0L, null, 0L, this.operation, rowError);
            }
            return e;
        }
    }

    private static class ConvertBatchToListOfResponsesCB
    implements Callback<List<OperationResponse>, List<BatchResponse>> {
        private static final ConvertBatchToListOfResponsesCB INSTANCE = new ConvertBatchToListOfResponsesCB();

        private ConvertBatchToListOfResponsesCB() {
        }

        @Override
        public List<OperationResponse> call(List<BatchResponse> batchResponses) throws Exception {
            int size = 0;
            for (BatchResponse batchResponse : batchResponses) {
                size += batchResponse.getIndividualResponses().size();
            }
            OperationResponse[] responses = new OperationResponse[size];
            for (BatchResponse batchResponse : batchResponses) {
                List<OperationResponse> responseList = batchResponse.getIndividualResponses();
                List<Integer> indexList = batchResponse.getResponseIndexes();
                for (int i = 0; i < indexList.size(); ++i) {
                    int index = indexList.get(i);
                    assert (responses[index] == null);
                    responses[index] = responseList.get(i);
                }
            }
            return Arrays.asList(responses);
        }

        public String toString() {
            return "ConvertBatchToListOfResponsesCB";
        }

        public static ConvertBatchToListOfResponsesCB getInstance() {
            return INSTANCE;
        }
    }

    private final class TabletLookupCB
    implements Callback<Void, Object> {
        private final AtomicInteger lookupsOutstanding;
        private final Buffer buffer;
        private final Deferred<List<BatchResponse>> deferred;

        public TabletLookupCB(Buffer buffer, Deferred<List<BatchResponse>> deferred) {
            this.lookupsOutstanding = new AtomicInteger(buffer.getOperations().size());
            this.buffer = buffer;
            this.deferred = deferred;
        }

        @Override
        public Void call(Object unused) throws Exception {
            if (this.lookupsOutstanding.decrementAndGet() != 0) {
                return null;
            }
            HashMap<Slice, Batch> batches = new HashMap<Slice, Batch>();
            ArrayList<OperationResponse> opsFailedInLookup = new ArrayList<OperationResponse>();
            ArrayList<Integer> opsFailedIndexesList = new ArrayList<Integer>();
            int currentIndex = 0;
            for (BufferedOperation bufferedOp : this.buffer.getOperations()) {
                Operation operation = bufferedOp.getOperation();
                if (bufferedOp.tabletLookupFailed()) {
                    RowError error;
                    Exception failure = bufferedOp.getTabletLookupFailure();
                    if (failure instanceof NonCoveredRangeException) {
                        error = new RowError(Status.NotFound(failure.getMessage()), operation);
                    } else {
                        LOG.warn("unexpected tablet lookup failure for operation {}", (Object)operation, (Object)failure);
                        error = new RowError(Status.RuntimeError(failure.getMessage()), operation);
                    }
                    OperationResponse response = new OperationResponse(0L, null, 0L, operation, error);
                    if (AsyncKuduSession.this.flushMode == SessionConfiguration.FlushMode.AUTO_FLUSH_BACKGROUND) {
                        AsyncKuduSession.this.errorCollector.addError(error);
                    }
                    operation.callback(response);
                    opsFailedInLookup.add(response);
                    opsFailedIndexesList.add(currentIndex++);
                    continue;
                }
                LocatedTablet tablet = bufferedOp.getTablet();
                Slice tabletId = new Slice(tablet.getTabletId());
                Batch batch = (Batch)batches.get(tabletId);
                if (batch == null) {
                    batch = new Batch(operation.getTable(), tablet, AsyncKuduSession.this.ignoreAllDuplicateRows, AsyncKuduSession.this.ignoreAllNotFoundRows);
                    batches.put(tabletId, batch);
                }
                batch.add(operation, currentIndex++);
            }
            ArrayList batchResponses = new ArrayList(batches.size() + 1);
            if (!opsFailedInLookup.isEmpty()) {
                batchResponses.add(Deferred.fromResult(new BatchResponse(opsFailedInLookup, opsFailedIndexesList)));
            }
            for (Batch batch : batches.values()) {
                if (AsyncKuduSession.this.timeoutMillis != 0L) {
                    batch.resetTimeoutMillis(AsyncKuduSession.this.client.getTimer(), AsyncKuduSession.this.timeoutMillis);
                }
                AsyncKuduSession.this.addBatchCallbacks(batch);
                batchResponses.add(AsyncKuduSession.this.client.sendRpcToTablet(batch));
            }
            AsyncUtil.addBoth(Deferred.group(batchResponses), new Callback<Void, Object>(){

                @Override
                public Void call(Object responses) {
                    AsyncKuduSession.this.queueBuffer(TabletLookupCB.this.buffer);
                    TabletLookupCB.this.deferred.callback(responses);
                    return null;
                }
            });
            return null;
        }
    }
}

