/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap;

import java.io.IOException;
import java.util.UUID;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.LlapArrowBatchRecordReader;
import org.apache.hadoop.hive.llap.LlapArrowRowRecordReader;
import org.apache.hadoop.hive.llap.LlapBaseInputFormat;
import org.apache.hadoop.hive.llap.LlapInputSplit;
import org.apache.hadoop.hive.llap.Row;
import org.apache.hadoop.hive.ql.io.arrow.RootAllocatorFactory;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class LlapArrowRowInputFormat
implements InputFormat<NullWritable, Row> {
    private LlapBaseInputFormat baseInputFormat;

    public LlapArrowRowInputFormat(long arrowAllocatorLimit) {
        BufferAllocator allocator = RootAllocatorFactory.INSTANCE.getOrCreateRootAllocator(arrowAllocatorLimit).newChildAllocator(UUID.randomUUID().toString(), 0L, arrowAllocatorLimit);
        this.baseInputFormat = new LlapBaseInputFormat(true, allocator);
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        return this.baseInputFormat.getSplits(job, numSplits);
    }

    public RecordReader<NullWritable, Row> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        LlapInputSplit llapSplit = (LlapInputSplit)split;
        LlapArrowBatchRecordReader reader = (LlapArrowBatchRecordReader)this.baseInputFormat.getRecordReader((InputSplit)llapSplit, job, reporter);
        return new LlapArrowRowRecordReader((Configuration)job, reader.getSchema(), (RecordReader<NullWritable, ? extends Writable>)reader);
    }
}

