/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.metadata;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import org.apache.hive.iceberg.shaded.parquet.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.iceberg.shaded.parquet.com.fasterxml.jackson.databind.SerializationFeature;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;

public class ParquetMetadata {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final FileMetaData fileMetaData;
    private final List<BlockMetaData> blocks;

    public static String toJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, false);
    }

    public static String toPrettyJSON(ParquetMetadata parquetMetaData) {
        return ParquetMetadata.toJSON(parquetMetaData, true);
    }

    private static String toJSON(ParquetMetadata parquetMetaData, boolean isPrettyPrint) {
        StringWriter stringWriter = new StringWriter();
        try {
            if (isPrettyPrint) {
                Object objectToPrint = parquetMetaData.getFileMetaData() == null || parquetMetaData.getFileMetaData().getEncryptionType() == FileMetaData.EncryptionType.UNENCRYPTED ? parquetMetaData : parquetMetaData.getFileMetaData();
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(stringWriter, objectToPrint);
            } else {
                objectMapper.writeValue(stringWriter, (Object)parquetMetaData);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    public static ParquetMetadata fromJSON(String json) {
        try {
            return objectMapper.readValue((Reader)new StringReader(json), ParquetMetadata.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ParquetMetadata(FileMetaData fileMetaData, List<BlockMetaData> blocks) {
        this.fileMetaData = fileMetaData;
        this.blocks = blocks;
    }

    public List<BlockMetaData> getBlocks() {
        return this.blocks;
    }

    public FileMetaData getFileMetaData() {
        return this.fileMetaData;
    }

    public String toString() {
        return "ParquetMetaData{" + this.fileMetaData + ", blocks: " + this.blocks + "}";
    }

    static {
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

