/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.iceberg.SystemConfigs;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.MoreExecutors;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class ThreadPools {
    @Deprecated
    public static final String WORKER_THREAD_POOL_SIZE_PROP = SystemConfigs.WORKER_THREAD_POOL_SIZE.propertyKey();
    public static final int WORKER_THREAD_POOL_SIZE = SystemConfigs.WORKER_THREAD_POOL_SIZE.value();
    private static final ExecutorService WORKER_POOL = ThreadPools.newWorkerPool("iceberg-worker-pool");

    private ThreadPools() {
    }

    public static ExecutorService getWorkerPool() {
        return WORKER_POOL;
    }

    public static ExecutorService newWorkerPool(String namePrefix) {
        return ThreadPools.newWorkerPool(namePrefix, WORKER_THREAD_POOL_SIZE);
    }

    public static ExecutorService newWorkerPool(String namePrefix, int poolSize) {
        return MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)Executors.newFixedThreadPool(poolSize, ThreadPools.newDaemonThreadFactory(namePrefix)));
    }

    public static ScheduledExecutorService newScheduledPool(String namePrefix, int poolSize) {
        return new ScheduledThreadPoolExecutor(poolSize, ThreadPools.newDaemonThreadFactory(namePrefix));
    }

    private static ThreadFactory newDaemonThreadFactory(String namePrefix) {
        return new ThreadFactoryBuilder().setDaemon(true).setNameFormat(namePrefix + "-%d").build();
    }
}

