/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.time.temporal.ChronoUnit;
import org.apache.hive.iceberg.com.google.errorprone.annotations.Immutable;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.ProjectionUtil;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.transforms.TransformUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.SerializableFunction;

enum Timestamps implements Transform<Long, Integer>
{
    YEAR(ChronoUnit.YEARS, "year"),
    MONTH(ChronoUnit.MONTHS, "month"),
    DAY(ChronoUnit.DAYS, "day"),
    HOUR(ChronoUnit.HOURS, "hour");

    private final ChronoUnit granularity;
    private final String name;
    private final Apply apply;

    private Timestamps(ChronoUnit granularity, String name) {
        this.granularity = granularity;
        this.name = name;
        this.apply = new Apply(granularity);
    }

    @Override
    public Integer apply(Long timestampMicros) {
        return this.apply.apply(timestampMicros);
    }

    @Override
    public SerializableFunction<Long, Integer> bind(Type type) {
        Preconditions.checkArgument(this.canTransform(type), "Cannot bind to unsupported type: %s", (Object)type);
        return this.apply;
    }

    @Override
    public boolean canTransform(Type type) {
        return type.typeId() == Type.TypeID.TIMESTAMP;
    }

    @Override
    public Type getResultType(Type sourceType) {
        if (this.granularity == ChronoUnit.DAYS) {
            return Types.DateType.get();
        }
        return Types.IntegerType.get();
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Timestamps) {
            Timestamps otherTransform = (Timestamps)other;
            return this.granularity.getDuration().toHours() <= otherTransform.granularity.getDuration().toHours();
        }
        return false;
    }

    @Override
    public UnboundPredicate<Integer> project(String fieldName, BoundPredicate<Long> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateLong(fieldName, pred.asLiteralPredicate(), this.apply);
            return ProjectionUtil.fixInclusiveTimeProjection(projected);
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            return ProjectionUtil.fixInclusiveTimeProjection(projected);
        }
        return null;
    }

    @Override
    public UnboundPredicate<Integer> projectStrict(String fieldName, BoundPredicate<Long> pred) {
        if (pred.term() instanceof BoundTransform) {
            return ProjectionUtil.projectTransformPredicate(this, fieldName, pred);
        }
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), fieldName);
        }
        if (pred.isLiteralPredicate()) {
            UnboundPredicate<Integer> projected = ProjectionUtil.truncateLongStrict(fieldName, pred.asLiteralPredicate(), this.apply);
            return ProjectionUtil.fixStrictTimeProjection(projected);
        }
        if (pred.isSetPredicate() && pred.op() == Expression.Operation.NOT_IN) {
            UnboundPredicate<Integer> projected = ProjectionUtil.transformSet(fieldName, pred.asSetPredicate(), this.apply);
            return ProjectionUtil.fixStrictTimeProjection(projected);
        }
        return null;
    }

    @Override
    public String toHumanString(Type outputType, Integer value) {
        if (value == null) {
            return "null";
        }
        switch (this.granularity) {
            case YEARS: {
                return TransformUtil.humanYear(value);
            }
            case MONTHS: {
                return TransformUtil.humanMonth(value);
            }
            case DAYS: {
                return TransformUtil.humanDay(value);
            }
            case HOURS: {
                return TransformUtil.humanHour(value);
            }
        }
        throw new UnsupportedOperationException("Unsupported time unit: " + this.granularity);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String dedupName() {
        return "time";
    }

    @Immutable
    static class Apply
    implements SerializableFunction<Long, Integer> {
        private final ChronoUnit granularity;

        Apply(ChronoUnit granularity) {
            this.granularity = granularity;
        }

        @Override
        public Integer apply(Long timestampMicros) {
            if (timestampMicros == null) {
                return null;
            }
            switch (this.granularity) {
                case YEARS: {
                    return DateTimeUtil.microsToYears(timestampMicros);
                }
                case MONTHS: {
                    return DateTimeUtil.microsToMonths(timestampMicros);
                }
                case DAYS: {
                    return DateTimeUtil.microsToDays(timestampMicros);
                }
                case HOURS: {
                    return DateTimeUtil.microsToHours(timestampMicros);
                }
            }
            throw new UnsupportedOperationException("Unsupported time unit: " + this.granularity);
        }
    }
}

