/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.io.ObjectStreamException;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.transforms.SerializationProxies;
import org.apache.iceberg.transforms.Transform;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.SerializableFunction;

class Identity<T>
implements Transform<T, T> {
    private static final Identity<?> INSTANCE = new Identity();
    private final Type type;

    @Deprecated
    public static <I> Identity<I> get(Type type) {
        return new Identity(type);
    }

    public static <I> Identity<I> get() {
        return INSTANCE;
    }

    private Identity() {
        this(null);
    }

    private Identity(Type type) {
        this.type = type;
    }

    @Override
    public T apply(T value) {
        return value;
    }

    @Override
    public SerializableFunction<T, T> bind(Type type) {
        Preconditions.checkArgument(this.canTransform(type), "Cannot bind to unsupported type: %s", (Object)type);
        return Apply.get();
    }

    @Override
    public boolean canTransform(Type maybePrimitive) {
        return maybePrimitive.isPrimitiveType();
    }

    @Override
    @Deprecated
    public String toHumanString(T value) {
        if (this.type != null) {
            return this.toHumanString(this.type, value);
        }
        return Transform.super.toHumanString(value);
    }

    @Override
    public Type getResultType(Type sourceType) {
        return sourceType;
    }

    @Override
    public boolean preservesOrder() {
        return true;
    }

    @Override
    public boolean satisfiesOrderOf(Transform<?, ?> other) {
        return other.preservesOrder();
    }

    @Override
    public UnboundPredicate<T> project(String name, BoundPredicate<T> predicate) {
        return this.projectStrict(name, predicate);
    }

    @Override
    public UnboundPredicate<T> projectStrict(String name, BoundPredicate<T> predicate) {
        if (predicate.isUnaryPredicate()) {
            return Expressions.predicate(predicate.op(), name);
        }
        if (predicate.isLiteralPredicate()) {
            return Expressions.predicate(predicate.op(), name, predicate.asLiteralPredicate().literal().value());
        }
        if (predicate.isSetPredicate()) {
            return Expressions.predicate(predicate.op(), name, predicate.asSetPredicate().literalSet());
        }
        return null;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof Identity;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "identity";
    }

    Object writeReplace() throws ObjectStreamException {
        return SerializationProxies.IdentityTransformProxy.get();
    }

    private static class Apply<T>
    implements SerializableFunction<T, T> {
        private static final Apply<?> APPLY_INSTANCE = new Apply();

        private Apply() {
        }

        private static <T> Apply<T> get() {
            return APPLY_INSTANCE;
        }

        @Override
        public T apply(T t) {
            return t;
        }
    }
}

