/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.RESTResponse;

public class ListTablesResponse
implements RESTResponse {
    private List<TableIdentifier> identifiers;

    public ListTablesResponse() {
    }

    private ListTablesResponse(List<TableIdentifier> identifiers) {
        this.identifiers = identifiers;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.identifiers != null, "Invalid identifier list: null");
    }

    public List<TableIdentifier> identifiers() {
        return this.identifiers != null ? this.identifiers : ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("identifiers", this.identifiers).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableList.Builder<TableIdentifier> identifiers = ImmutableList.builder();

        private Builder() {
        }

        public Builder add(TableIdentifier toAdd) {
            Preconditions.checkNotNull(toAdd, "Invalid table identifier: null");
            this.identifiers.add((Object)toAdd);
            return this;
        }

        public Builder addAll(Collection<TableIdentifier> toAdd) {
            Preconditions.checkNotNull(toAdd, "Invalid table identifier list: null");
            Preconditions.checkArgument(!toAdd.contains(null), "Invalid table identifier: null");
            this.identifiers.addAll(toAdd);
            return this;
        }

        public ListTablesResponse build() {
            return new ListTablesResponse((List)((Object)this.identifiers.build()));
        }
    }
}

