/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class TypeToMessageType {
    public static final int DECIMAL_INT32_MAX_DIGITS = 9;
    public static final int DECIMAL_INT64_MAX_DIGITS = 18;
    private static final LogicalTypeAnnotation STRING = LogicalTypeAnnotation.stringType();
    private static final LogicalTypeAnnotation DATE = LogicalTypeAnnotation.dateType();
    private static final LogicalTypeAnnotation TIME_MICROS = LogicalTypeAnnotation.timeType(false, LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMP_MICROS = LogicalTypeAnnotation.timestampType(false, LogicalTypeAnnotation.TimeUnit.MICROS);
    private static final LogicalTypeAnnotation TIMESTAMPTZ_MICROS = LogicalTypeAnnotation.timestampType(true, LogicalTypeAnnotation.TimeUnit.MICROS);

    public MessageType convert(Schema schema, String name) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (Types.NestedField field : schema.columns()) {
            builder.addField(this.field(field));
        }
        return builder.named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public GroupType struct(Types.StructType struct, Type.Repetition repetition, int id, String name) {
        Types.GroupBuilder<GroupType> builder = Types.buildGroup(repetition);
        for (Types.NestedField field : struct.fields()) {
            builder.addField(this.field(field));
        }
        return (GroupType)((Types.GroupBuilder)builder.id(id)).named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public Type field(Types.NestedField field) {
        Type.Repetition repetition = field.isOptional() ? Type.Repetition.OPTIONAL : Type.Repetition.REQUIRED;
        int id = field.fieldId();
        String name = field.name();
        if (field.type().isPrimitiveType()) {
            return this.primitive(field.type().asPrimitiveType(), repetition, id, name);
        }
        Type.NestedType nested = field.type().asNestedType();
        if (nested.isStructType()) {
            return this.struct(nested.asStructType(), repetition, id, name);
        }
        if (nested.isMapType()) {
            return this.map(nested.asMapType(), repetition, id, name);
        }
        if (nested.isListType()) {
            return this.list(nested.asListType(), repetition, id, name);
        }
        throw new UnsupportedOperationException("Can't convert unknown type: " + nested);
    }

    public GroupType list(Types.ListType list, Type.Repetition repetition, int id, String name) {
        Types.NestedField elementField = list.fields().get(0);
        return (GroupType)((Types.ListBuilder)Types.list(repetition).element(this.field(elementField)).id(id)).named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public GroupType map(Types.MapType map, Type.Repetition repetition, int id, String name) {
        Types.NestedField keyField = map.fields().get(0);
        Types.NestedField valueField = map.fields().get(1);
        return (GroupType)((Types.MapBuilder)((Types.MapBuilder)((Types.MapBuilder)Types.map(repetition).key(this.field(keyField))).value(this.field(valueField))).id(id)).named(AvroSchemaUtil.makeCompatibleName(name));
    }

    public Type primitive(Type.PrimitiveType primitive, Type.Repetition repetition, int id, String originalName) {
        String name = AvroSchemaUtil.makeCompatibleName(originalName);
        switch (primitive.typeId()) {
            case BOOLEAN: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BOOLEAN, repetition).id(id)).named(name);
            }
            case INTEGER: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).id(id)).named(name);
            }
            case LONG: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).id(id)).named(name);
            }
            case FLOAT: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FLOAT, repetition).id(id)).named(name);
            }
            case DOUBLE: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.DOUBLE, repetition).id(id)).named(name);
            }
            case DATE: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(DATE)).id(id)).named(name);
            }
            case TIME: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIME_MICROS)).id(id)).named(name);
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)primitive).shouldAdjustToUTC()) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIMESTAMPTZ_MICROS)).id(id)).named(name);
                }
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TIMESTAMP_MICROS)).id(id)).named(name);
            }
            case STRING: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).as(STRING)).id(id)).named(name);
            }
            case BINARY: {
                return (Type)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.BINARY, repetition).id(id)).named(name);
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(fixed.length())).id(id)).named(name);
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                if (decimal.precision() <= 9) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT32, repetition).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
                }
                if (decimal.precision() <= 18) {
                    return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.INT64, repetition).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
                }
                int minLength = TypeUtil.decimalRequiredBytes(decimal.precision());
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(minLength)).as(TypeToMessageType.decimalAnnotation(decimal.precision(), decimal.scale()))).id(id)).named(name);
            }
            case UUID: {
                return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, repetition).length(16)).as(LogicalTypeAnnotation.uuidType())).id(id)).named(name);
            }
        }
        throw new UnsupportedOperationException("Unsupported type for Parquet: " + primitive);
    }

    private static LogicalTypeAnnotation decimalAnnotation(int precision, int scale) {
        return LogicalTypeAnnotation.decimalType(scale, precision);
    }
}

