/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.List;
import org.apache.hive.iceberg.org.apache.orc.TypeDescription;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class RemoveIds
extends OrcSchemaVisitor<TypeDescription> {
    RemoveIds() {
    }

    @Override
    public TypeDescription record(TypeDescription record, List<String> names, List<TypeDescription> fields) {
        Preconditions.checkArgument(names.size() == fields.size(), "All fields must have names.");
        TypeDescription struct = TypeDescription.createStruct();
        for (int i = 0; i < fields.size(); ++i) {
            struct.addField(names.get(i), fields.get(i));
        }
        return struct;
    }

    @Override
    public TypeDescription list(TypeDescription array, TypeDescription element) {
        return TypeDescription.createList(element);
    }

    @Override
    public TypeDescription map(TypeDescription map, TypeDescription key, TypeDescription value) {
        return TypeDescription.createMap(key, value);
    }

    @Override
    public TypeDescription primitive(TypeDescription primitive) {
        return RemoveIds.removeIcebergAttributes(primitive.clone());
    }

    private static TypeDescription removeIcebergAttributes(TypeDescription orcType) {
        orcType.removeAttribute("iceberg.id");
        return orcType;
    }
}

