/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.util.SerializationUtil;

public class IcebergSplit
extends InputSplit
implements org.apache.hadoop.mapred.InputSplit,
IcebergSplitContainer {
    public static final String[] ANYWHERE = new String[]{"*"};
    private CombinedScanTask task;
    private transient String[] locations;
    private transient Configuration conf;

    public IcebergSplit() {
    }

    IcebergSplit(Configuration conf, CombinedScanTask task) {
        this.task = task;
        this.conf = conf;
    }

    public CombinedScanTask task() {
        return this.task;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this;
    }

    public long getLength() {
        return this.task.files().stream().mapToLong(ContentScanTask::length).sum();
    }

    public String[] getLocations() {
        boolean localityPreferred;
        this.locations = this.locations == null && this.conf != null ? ((localityPreferred = this.conf.getBoolean("iceberg.mr.locality", false)) ? Util.blockLocations(this.task, this.conf) : ANYWHERE) : ANYWHERE;
        return this.locations;
    }

    public void write(DataOutput out) throws IOException {
        byte[] data = SerializationUtil.serializeToBytes(this.task);
        out.writeInt(data.length);
        out.write(data);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] data = new byte[in.readInt()];
        in.readFully(data);
        this.task = (CombinedScanTask)SerializationUtil.deserializeFromBytes(data);
    }
}

