/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.mapreduce;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;

public class IcebergInternalRecordWrapper
implements Record,
StructLike {
    private Function<Object, Object>[] transforms;
    private Types.StructType readSchema;
    private Types.StructType tableSchema;
    private Object[] values;
    private int size;
    private Map<String, Integer> fieldToPositionInReadSchema;
    private Map<String, Integer> fieldToPositionInTableSchema;

    public IcebergInternalRecordWrapper(Types.StructType tableSchema, Types.StructType readSchema) {
        this.readSchema = readSchema;
        this.tableSchema = tableSchema;
        this.size = readSchema.fields().size();
        this.values = new Object[this.size];
        this.fieldToPositionInReadSchema = this.buildFieldPositionMap(readSchema);
        this.fieldToPositionInTableSchema = this.buildFieldPositionMap(tableSchema);
        this.transforms = (Function[])readSchema.fields().stream().map(field -> IcebergInternalRecordWrapper.converter(field.type())).toArray(length -> (Function[])Array.newInstance(Function.class, length));
    }

    public IcebergInternalRecordWrapper wrap(StructLike record) {
        int idx = 0;
        for (Types.NestedField field : this.readSchema.fields()) {
            int position = this.fieldToPositionInTableSchema.get(field.name());
            this.values[idx] = record.get(position, Object.class);
            ++idx;
        }
        return this;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        if (this.transforms[pos] != null && this.values[pos] != null) {
            return javaClass.cast(this.transforms[pos].apply(this.values[pos]));
        }
        return javaClass.cast(this.values[pos]);
    }

    @Override
    public Object getField(String name) {
        Integer pos = this.fieldToPositionInReadSchema.get(name);
        if (pos != null) {
            return this.get(pos, Object.class);
        }
        return null;
    }

    @Override
    public Types.StructType struct() {
        return this.readSchema;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Object get(int pos) {
        return this.get(pos, Object.class);
    }

    @Override
    public IcebergInternalRecordWrapper copy() {
        return new IcebergInternalRecordWrapper(this);
    }

    @Override
    public IcebergInternalRecordWrapper copy(Map<String, Object> overwriteValues) {
        throw new UnsupportedOperationException("Copying an IcebergInternalRecordWrapper with overwrite values is not supported.");
    }

    @Override
    public <T> void set(int pos, T value) {
        throw new UnsupportedOperationException("Cannot update value in IcebergInternalRecordWrapper.");
    }

    @Override
    public void setField(String name, Object value) {
        throw new UnsupportedOperationException("Cannot update fields in IcebergInternalRecordWrapper.");
    }

    private IcebergInternalRecordWrapper(IcebergInternalRecordWrapper toCopy) {
        this.readSchema = toCopy.readSchema;
        this.size = toCopy.size;
        this.values = Arrays.copyOf(toCopy.values, toCopy.values.length);
        this.fieldToPositionInReadSchema = this.buildFieldPositionMap(this.readSchema);
        this.fieldToPositionInTableSchema = this.buildFieldPositionMap(toCopy.tableSchema);
        this.transforms = (Function[])this.readSchema.fields().stream().map(field -> IcebergInternalRecordWrapper.converter(field.type())).toArray(length -> (Function[])Array.newInstance(Function.class, length));
    }

    private Map<String, Integer> buildFieldPositionMap(Types.StructType schema) {
        HashMap<String, Integer> nameToPosition = Maps.newHashMap();
        List<Types.NestedField> fields = schema.fields();
        for (int i = 0; i < fields.size(); ++i) {
            nameToPosition.put(fields.get(i).name(), i);
        }
        return nameToPosition;
    }

    private static Function<Object, Object> converter(Type type) {
        switch (type.typeId()) {
            case TIMESTAMP: {
                return timestamp -> ((Types.TimestampType)type).shouldAdjustToUTC() ? DateTimeUtil.timestamptzFromMicros((Long)timestamp) : DateTimeUtil.timestampFromMicros((Long)timestamp);
            }
            case DATE: {
                return date -> DateTimeUtil.dateFromDays((Integer)date);
            }
            case STRUCT: {
                IcebergInternalRecordWrapper wrapper = new IcebergInternalRecordWrapper(type.asStructType(), type.asStructType());
                return struct -> wrapper.wrap((StructLike)struct);
            }
            case LIST: {
                if (!Type.TypeID.STRUCT.equals((Object)type.asListType().elementType().typeId())) break;
                Types.StructType listElementSchema = type.asListType().elementType().asStructType();
                Function<Type, IcebergInternalRecordWrapper> createWrapper = t -> new IcebergInternalRecordWrapper(listElementSchema, listElementSchema);
                return list -> ((List)list).stream().map(item -> ((IcebergInternalRecordWrapper)createWrapper.apply(type)).wrap((StructLike)item)).collect(Collectors.toList());
            }
        }
        return null;
    }
}

