/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.writer.HiveFileWriterFactory;
import org.apache.iceberg.mr.hive.writer.HiveIcebergCopyOnWriteRecordWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergDeleteWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergRecordWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.hive.writer.WriterRegistry;
import org.apache.iceberg.util.PropertyUtil;

public class WriterBuilder {
    private final Table table;
    private String tableName;
    private TaskAttemptID attemptID;
    private String queryId;
    private int poolSize;
    private Context.Operation operation;
    private boolean fanoutEnabled;
    private static AtomicInteger operationNum = new AtomicInteger(0);
    public static final String ICEBERG_DELETE_SKIPROWDATA = "iceberg.delete.skiprowdata";
    public static final String ICEBERG_DELETE_SKIPROWDATA_DEFAULT = "true";

    private WriterBuilder(Table table) {
        this.table = table;
    }

    public static WriterBuilder builderFor(Table table) {
        return new WriterBuilder(table);
    }

    public WriterBuilder tableName(String newTableName) {
        this.tableName = newTableName;
        return this;
    }

    public WriterBuilder attemptID(TaskAttemptID newAttemptID) {
        this.attemptID = newAttemptID;
        return this;
    }

    public WriterBuilder queryId(String newQueryId) {
        this.queryId = newQueryId;
        return this;
    }

    public WriterBuilder poolSize(int newPoolSize) {
        this.poolSize = newPoolSize;
        return this;
    }

    public WriterBuilder operation(Context.Operation newOperation) {
        this.operation = newOperation;
        return this;
    }

    public WriterBuilder isFanoutEnabled(boolean isFanoutEnabled) {
        this.fanoutEnabled = isFanoutEnabled;
        return this;
    }

    public HiveIcebergWriter build() {
        HiveIcebergWriterBase writer;
        Map<String, String> properties = this.table.properties();
        String dataFileFormatName = properties.getOrDefault("write.format.default", "parquet");
        FileFormat dataFileFormat = FileFormat.valueOf(dataFileFormatName.toUpperCase(Locale.ENGLISH));
        String deleteFileFormatName = properties.getOrDefault("write.delete.format.default", dataFileFormatName);
        FileFormat deleteFileFormat = FileFormat.valueOf(deleteFileFormatName.toUpperCase(Locale.ENGLISH));
        long targetFileSize = PropertyUtil.propertyAsLong(this.table.properties(), "write.target-file-size-bytes", 0x20000000L);
        boolean skipRowData = Boolean.parseBoolean(properties.getOrDefault(ICEBERG_DELETE_SKIPROWDATA, ICEBERG_DELETE_SKIPROWDATA_DEFAULT));
        Schema dataSchema = this.table.schema();
        FileIO io = this.table.io();
        Map<Integer, PartitionSpec> specs = this.table.specs();
        int currentSpecId = this.table.spec().specId();
        int partitionId = this.attemptID.getTaskID().getId();
        int taskId = this.attemptID.getId();
        String operationId = this.queryId + "-" + this.attemptID.getJobID() + "-" + operationNum.incrementAndGet();
        OutputFileFactory outputFileFactory = OutputFileFactory.builderFor(this.table, partitionId, taskId).format(dataFileFormat).operationId("data-" + operationId).build();
        OutputFileFactory deleteOutputFileFactory = OutputFileFactory.builderFor(this.table, partitionId, taskId).format(deleteFileFormat).operationId("delete-" + operationId).build();
        HiveFileWriterFactory writerFactory = new HiveFileWriterFactory(this.table, dataFileFormat, dataSchema, null, deleteFileFormat, null, null, null, skipRowData ? null : dataSchema);
        if (IcebergTableUtil.isCopyOnWriteMode(this.operation, properties::getOrDefault)) {
            writer = new HiveIcebergCopyOnWriteRecordWriter(dataSchema, specs, currentSpecId, writerFactory, outputFileFactory, io, targetFileSize);
        } else {
            switch (this.operation) {
                case DELETE: {
                    writer = new HiveIcebergDeleteWriter(dataSchema, specs, writerFactory, deleteOutputFileFactory, io, targetFileSize, skipRowData);
                    break;
                }
                case OTHER: {
                    writer = new HiveIcebergRecordWriter(dataSchema, specs, currentSpecId, writerFactory, outputFileFactory, io, targetFileSize, this.fanoutEnabled);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation when creating IcebergRecordWriter: " + this.operation.name());
                }
            }
        }
        WriterRegistry.registerWriter(this.attemptID, this.tableName, writer);
        return writer;
    }
}

