/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HiveIcebergWriterBase
implements HiveIcebergWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergWriterBase.class);
    protected final FileIO io;
    protected final InternalRecordWrapper wrapper;
    protected final Map<Integer, PartitionSpec> specs;
    protected final Map<Integer, PartitionKey> partitionKeys;
    protected final PartitioningWriter writer;

    HiveIcebergWriterBase(Schema schema, Map<Integer, PartitionSpec> specs, FileIO io, PartitioningWriter writer) {
        this.io = io;
        this.wrapper = new InternalRecordWrapper(schema.asStruct());
        this.specs = specs;
        this.partitionKeys = Maps.newHashMapWithExpectedSize(specs.size());
        this.writer = writer;
    }

    @Override
    public void close(boolean abort) throws IOException {
        this.writer.close();
        FilesForCommit result = this.files();
        if (abort) {
            Tasks.foreach(result.allFiles()).retry(3).suppressFailureWhenFinished().onFailure((file, exception) -> LOG.debug("Failed on to remove file {} on abort", file, (Object)exception)).run(file -> this.io.deleteFile(file.path().toString()));
        }
        LOG.info("HiveIcebergWriter is closed with abort={}. Created {} data files and {} delete files", new Object[]{abort, result.dataFiles().size(), result.deleteFiles().size()});
    }

    protected PartitionKey partition(Record row, int specId) {
        PartitionKey partitionKey = this.partitionKeys.computeIfAbsent(specId, id -> new PartitionKey(this.specs.get(id), this.specs.get(id).schema()));
        partitionKey.partition(this.wrapper.wrap(row));
        return partitionKey;
    }
}

