/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitioningWriter;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.mapred.Container;

class HiveIcebergRecordWriter
extends HiveIcebergWriterBase {
    private final int currentSpecId;

    HiveIcebergRecordWriter(Schema schema, Map<Integer, PartitionSpec> specs, int currentSpecId, FileWriterFactory<Record> fileWriterFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, boolean fanoutEnabled) {
        super(schema, specs, io, HiveIcebergRecordWriter.getIcebergDataWriter(fileWriterFactory, fileFactory, io, targetFileSize, fanoutEnabled));
        this.currentSpecId = currentSpecId;
    }

    @Override
    public void write(Writable row) throws IOException {
        Record record = (Record)((Container)row).get();
        this.writer.write(record, (PartitionSpec)this.specs.get(this.currentSpecId), this.partition(record, this.currentSpecId));
    }

    @Override
    public FilesForCommit files() {
        List<DataFile> dataFiles = ((DataWriteResult)this.writer.result()).dataFiles();
        return FilesForCommit.onlyData(dataFiles);
    }

    private static PartitioningWriter getIcebergDataWriter(FileWriterFactory<Record> fileWriterFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, boolean fanoutEnabled) {
        return fanoutEnabled ? new FanoutDataWriter<Record>(fileWriterFactory, fileFactory, io, targetFileSize) : new ClusteredDataWriter<Record>(fileWriterFactory, fileFactory, io, targetFileSize);
    }
}

