/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.util.CharSequenceSet;

class HiveIcebergDeleteWriter
extends HiveIcebergWriterBase {
    private final GenericRecord rowDataTemplate;
    private final boolean skipRowData;

    HiveIcebergDeleteWriter(Schema schema, Map<Integer, PartitionSpec> specs, FileWriterFactory<Record> writerFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, boolean skipRowData) {
        super(schema, specs, io, new ClusteredPositionDeleteWriter<Record>(writerFactory, fileFactory, io, targetFileSize));
        this.rowDataTemplate = GenericRecord.create(schema);
        this.skipRowData = skipRowData;
    }

    @Override
    public void write(Writable row) throws IOException {
        Record rec = (Record)((Container)row).get();
        PositionDelete<Record> positionDelete = IcebergAcidUtil.getPositionDelete(rec, this.rowDataTemplate);
        int specId = IcebergAcidUtil.parseSpecId(rec);
        Record rowData = positionDelete.row();
        if (this.skipRowData) {
            positionDelete.set(positionDelete.path(), positionDelete.pos(), null);
        }
        this.writer.write(positionDelete, (PartitionSpec)this.specs.get(specId), this.partition(rowData, specId));
    }

    @Override
    public FilesForCommit files() {
        List<DeleteFile> deleteFiles = ((DeleteWriteResult)this.writer.result()).deleteFiles();
        CharSequenceSet referencedDataFiles = ((DeleteWriteResult)this.writer.result()).referencedDataFiles();
        return FilesForCommit.onlyDelete(deleteFiles, referencedDataFiles);
    }
}

