/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.writer;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriterBase;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class HiveIcebergCopyOnWriteRecordWriter
extends HiveIcebergWriterBase {
    private final int currentSpecId;
    private final GenericRecord rowDataTemplate;
    private final List<DataFile> replacedDataFiles;

    HiveIcebergCopyOnWriteRecordWriter(Schema schema, Map<Integer, PartitionSpec> specs, int currentSpecId, FileWriterFactory<Record> fileWriterFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        super(schema, specs, io, new ClusteredDataWriter<Record>(fileWriterFactory, fileFactory, io, targetFileSize));
        this.currentSpecId = currentSpecId;
        this.rowDataTemplate = GenericRecord.create(schema);
        this.replacedDataFiles = Lists.newArrayList();
    }

    @Override
    public void write(Writable row) throws IOException {
        Record record = (Record)((Container)row).get();
        PositionDelete<Record> positionDelete = IcebergAcidUtil.getPositionDelete(record, this.rowDataTemplate);
        Record rowData = positionDelete.row();
        if (positionDelete.pos() < 0L) {
            int specId = IcebergAcidUtil.parseSpecId(record);
            DataFile dataFile = DataFiles.builder((PartitionSpec)this.specs.get(specId)).withPath(positionDelete.path().toString()).withPartition(this.partition(rowData, specId)).withFileSizeInBytes(0L).withRecordCount(0L).build();
            this.replacedDataFiles.add(dataFile);
        } else {
            this.writer.write(rowData, (PartitionSpec)this.specs.get(this.currentSpecId), this.partition(rowData, this.currentSpecId));
        }
    }

    @Override
    public FilesForCommit files() {
        List<DataFile> dataFiles = ((DataWriteResult)this.writer.result()).dataFiles();
        return FilesForCommit.onlyData(dataFiles, this.replacedDataFiles);
    }
}

