/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.DeleteFilter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mr.hive.vector.HiveBatchContext;
import org.apache.iceberg.mr.hive.vector.HiveRow;
import org.apache.iceberg.mr.hive.vector.HiveStructLike;

public class HiveDeleteFilter
extends DeleteFilter<HiveRow> {
    private final FileIO io;
    private final HiveStructLike asStructLike;

    public HiveDeleteFilter(FileIO io, FileScanTask task, Schema tableSchema, Schema requestedSchema) {
        super(((DataFile)task.file()).path().toString(), task.deletes(), tableSchema, requestedSchema);
        this.io = io;
        this.asStructLike = new HiveStructLike(this.requiredSchema().asStruct());
    }

    @Override
    protected StructLike asStructLike(HiveRow record) {
        return this.asStructLike.wrap(record);
    }

    @Override
    protected long pos(HiveRow record) {
        return (Long)record.get(MetadataColumns.ROW_POSITION.fieldId());
    }

    @Override
    protected void markRowDeleted(HiveRow row) {
        row.setDeleted(true);
    }

    @Override
    protected InputFile getInputFile(String location) {
        return this.io.newInputFile(location);
    }

    public CloseableIterable<HiveBatchContext> filterBatch(final CloseableIterable<HiveBatchContext> batches) {
        final SwappableHiveRowIterable deleteInputIterable = new SwappableHiveRowIterable();
        CloseableIterable<HiveRow> deleteOutputIterable = this.filter(deleteInputIterable);
        Iterator deleteOutputIterator = deleteOutputIterable.iterator();
        return new CloseableIterable<HiveBatchContext>((CloseableIterator)deleteOutputIterator){
            final /* synthetic */ CloseableIterator val$deleteOutputIterator;
            {
                this.val$deleteOutputIterator = closeableIterator;
            }

            @Override
            public CloseableIterator<HiveBatchContext> iterator() {
                Iterator srcIterator = batches.iterator();
                return new CloseableIterator<HiveBatchContext>((CloseableIterator)srcIterator){
                    final /* synthetic */ CloseableIterator val$srcIterator;
                    {
                        this.val$srcIterator = closeableIterator;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$srcIterator.hasNext();
                    }

                    @Override
                    public HiveBatchContext next() {
                        try {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            HiveBatchContext currentBatchContext = (HiveBatchContext)this.val$srcIterator.next();
                            deleteInputIterable.currentRowIterator = currentBatchContext.rowIterator();
                            VectorizedRowBatch batch = currentBatchContext.getBatch();
                            int oldSize = batch.size;
                            int newSize = 0;
                            while (val$deleteOutputIterator.hasNext()) {
                                HiveRow row = (HiveRow)val$deleteOutputIterator.next();
                                if (row.isDeleted()) continue;
                                batch.selected[newSize++] = row.physicalBatchIndex();
                            }
                            if (newSize < oldSize) {
                                batch.size = newSize;
                                batch.selectedInUse = true;
                            }
                            return currentBatchContext;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }

                    @Override
                    public void close() throws IOException {
                        this.val$srcIterator.close();
                    }
                };
            }

            @Override
            public void close() throws IOException {
                batches.close();
            }
        };
    }

    static class SwappableHiveRowIterable
    implements CloseableIterable<HiveRow> {
        private CloseableIterator<HiveRow> currentRowIterator;

        SwappableHiveRowIterable() {
        }

        @Override
        public CloseableIterator<HiveRow> iterator() {
            return new CloseableIterator<HiveRow>(){

                @Override
                public boolean hasNext() {
                    return currentRowIterator.hasNext();
                }

                @Override
                public HiveRow next() {
                    return (HiveRow)currentRowIterator.next();
                }

                @Override
                public void close() throws IOException {
                    currentRowIterator.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.currentRowIterator.close();
        }
    }
}

