/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.LongStream;
import org.apache.hadoop.hive.llap.LlapHiveUtils;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.RowPositionAwareVectorizedRecordReader;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.mr.hive.IcebergAcidUtil;
import org.apache.iceberg.mr.hive.vector.HiveBatchContext;
import org.apache.iceberg.util.StructProjection;

public final class HiveBatchIterator
implements CloseableIterator<HiveBatchContext> {
    private final RecordReader<NullWritable, VectorizedRowBatch> recordReader;
    private final NullWritable key;
    private final VectorizedRowBatch batch;
    private final VectorizedRowBatchCtx vrbCtx;
    private final int[] partitionColIndices;
    private final Object[] partitionValues;
    private boolean advanced = false;
    private long rowOffset = Long.MIN_VALUE;
    private Map<Integer, ?> idToConstant;

    HiveBatchIterator(RecordReader<NullWritable, VectorizedRowBatch> recordReader, JobConf job, int[] partitionColIndices, Object[] partitionValues, Map<Integer, ?> idToConstant) {
        this.recordReader = recordReader;
        this.key = (NullWritable)recordReader.createKey();
        this.batch = (VectorizedRowBatch)recordReader.createValue();
        this.vrbCtx = LlapHiveUtils.findMapWork((JobConf)job).getVectorizedRowBatchCtx();
        this.partitionColIndices = partitionColIndices;
        this.partitionValues = partitionValues;
        this.idToConstant = idToConstant;
    }

    @Override
    public void close() throws IOException {
        this.recordReader.close();
    }

    private void advance() {
        if (!this.advanced) {
            try {
                if (!this.recordReader.next((Object)this.key, (Object)this.batch)) {
                    this.batch.size = 0;
                }
                if (this.batch.size != 0 && this.recordReader instanceof RowPositionAwareVectorizedRecordReader) {
                    this.rowOffset = ((RowPositionAwareVectorizedRecordReader)this.recordReader).getRowNumber();
                }
                if (this.partitionColIndices != null) {
                    for (int i = 0; i < this.partitionColIndices.length; ++i) {
                        int colIdx = this.partitionColIndices[i];
                        if (this.batch.cols[colIdx] == null) continue;
                        this.vrbCtx.addPartitionColsToBatch(this.batch.cols[colIdx], this.partitionValues[i], this.partitionColIndices[i]);
                    }
                }
                block9: for (VirtualColumn vc : this.vrbCtx.getNeededVirtualColumns()) {
                    int idx = this.vrbCtx.findVirtualColumnNum(vc);
                    switch (vc) {
                        case PARTITION_SPEC_ID: {
                            Object value = this.idToConstant.get(MetadataColumns.SPEC_ID.fieldId());
                            this.vrbCtx.addPartitionColsToBatch(this.batch.cols[idx], value, idx);
                            continue block9;
                        }
                        case PARTITION_HASH: {
                            Object value = IcebergAcidUtil.computeHash((StructProjection)this.idToConstant.get(0x7FFFFFFA));
                            this.vrbCtx.addPartitionColsToBatch(this.batch.cols[idx], value, idx);
                            continue block9;
                        }
                        case FILE_PATH: {
                            Object value = this.idToConstant.get(MetadataColumns.FILE_PATH.fieldId());
                            BytesColumnVector bcv = (BytesColumnVector)this.batch.cols[idx];
                            if (value == null) {
                                bcv.noNulls = false;
                                bcv.isNull[0] = true;
                                bcv.isRepeating = true;
                                continue block9;
                            }
                            bcv.fill(((String)value).getBytes());
                            continue block9;
                        }
                        case ROW_POSITION: {
                            Object value = LongStream.range(this.rowOffset, this.rowOffset + (long)this.batch.size).toArray();
                            LongColumnVector lcv = (LongColumnVector)this.batch.cols[idx];
                            lcv.noNulls = true;
                            Arrays.fill(lcv.isNull, false);
                            lcv.isRepeating = false;
                            System.arraycopy(value, 0, lcv.vector, 0, this.batch.size);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.advanced = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.batch.size > 0;
    }

    @Override
    public HiveBatchContext next() {
        this.advance();
        this.advanced = false;
        return new HiveBatchContext(this.batch, this.vrbCtx, this.rowOffset);
    }
}

