/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;

public class IcebergTimestampObjectInspectorHive3
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector,
WriteObjectInspector {
    private static final IcebergTimestampObjectInspectorHive3 INSTANCE = new IcebergTimestampObjectInspectorHive3();

    public static IcebergTimestampObjectInspectorHive3 get() {
        return INSTANCE;
    }

    private IcebergTimestampObjectInspectorHive3() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    @Override
    public LocalDateTime convert(Object o) {
        if (o == null) {
            return null;
        }
        Timestamp timestamp = (Timestamp)o;
        return LocalDateTime.ofEpochSecond(timestamp.toEpochSecond(), timestamp.getNanos(), ZoneOffset.UTC);
    }

    public Timestamp getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        LocalDateTime time = (LocalDateTime)o;
        return Timestamp.ofEpochMilli((long)time.toInstant(ZoneOffset.UTC).toEpochMilli(), (int)time.getNano());
    }

    public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritableV2(ts);
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            Timestamp ts = (Timestamp)o;
            Timestamp copy = new Timestamp(ts);
            copy.setNanos(ts.getNanos());
            return copy;
        }
        if (o instanceof LocalDateTime) {
            return LocalDateTime.of(((LocalDateTime)o).toLocalDate(), ((LocalDateTime)o).toLocalTime());
        }
        return o;
    }
}

