/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.QueryCompactor;
import org.apache.hive.iceberg.org.apache.orc.storage.common.TableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergMajorQueryCompactor
extends QueryCompactor {
    private static final Logger LOG = LoggerFactory.getLogger((String)IcebergMajorQueryCompactor.class.getName());

    public boolean run(CompactorContext context) throws IOException, HiveException, InterruptedException {
        String compactTableName = TableName.getDbTable(context.getTable().getDbName(), context.getTable().getTableName());
        Map tblProperties = context.getTable().getParameters();
        LOG.debug("Initiating compaction for the {} table", (Object)compactTableName);
        String compactionQuery = String.format("insert overwrite table %s select * from %<s", compactTableName);
        SessionState sessionState = this.setupQueryCompactionSession(context.getConf(), context.getCompactionInfo(), tblProperties);
        HiveConf.setVar((Configuration)context.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.REWRITE_POLICY, (String)Context.RewritePolicy.ALL_PARTITIONS.name());
        try {
            DriverUtils.runOnDriver((HiveConf)context.getConf(), (SessionState)sessionState, (String)compactionQuery);
            LOG.info("Completed compaction for table {}", (Object)compactTableName);
        }
        catch (HiveException e) {
            LOG.error("Error doing query based {} compaction", (Object)Context.RewritePolicy.ALL_PARTITIONS.name(), (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            sessionState.setCompaction(false);
        }
        return true;
    }
}

