/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.compaction;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.metastore.txn.entities.CompactionInfo;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorContext;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorPipeline;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorUtil;
import org.apache.hadoop.hive.ql.txn.compactor.service.CompactionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCompactionService
extends CompactionService {
    private static final String CLASS_NAME = IcebergCompactionService.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLASS_NAME);

    public Boolean compact(Table table, CompactionInfo ci) throws Exception {
        if (!ci.isMajorCompaction()) {
            ci.errorMessage = "Presently Iceberg tables support only Major compaction";
            LOG.error(ci.errorMessage + " Compaction info: {}", (Object)ci);
            try {
                this.msc.markRefused(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
            }
            catch (Throwable tr) {
                LOG.error("Caught an exception while trying to mark compaction {} as failed: {}", (Object)ci, (Object)tr);
            }
            return false;
        }
        CompactorUtil.checkInterrupt((String)CLASS_NAME);
        if (ci.runAs == null) {
            ci.runAs = TxnUtils.findUserToRunAs((String)table.getSd().getLocation(), (Table)table, (Configuration)this.conf);
        }
        try {
            CompactorPipeline compactorPipeline = this.compactorFactory.getCompactorPipeline(table, this.conf, ci, this.msc);
            this.computeStats = this.collectGenericStats;
            LOG.info("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + ", id:" + ci.id + " with compute stats set to " + this.computeStats);
            CompactorContext compactorContext = new CompactorContext(this.conf, table, ci);
            compactorPipeline.execute(compactorContext);
            LOG.info("Completed " + ci.type.toString() + " compaction for " + ci.getFullPartitionName() + ", marking as compacted.");
            this.msc.markCleaned(CompactionInfo.compactionInfoToStruct((CompactionInfo)ci));
        }
        catch (Throwable e) {
            this.computeStats = false;
            throw e;
        }
        return true;
    }

    public void cleanupResultDirs(CompactionInfo ci) {
    }
}

