/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTagExec {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTagExec.class);

    private IcebergTagExec() {
    }

    public static void createTag(Table table, AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createTagSpec) {
        String tagName = createTagSpec.getRefName();
        Long snapshotId = null;
        snapshotId = createTagSpec.getSnapshotId() != null ? createTagSpec.getSnapshotId() : (createTagSpec.getAsOfTime() != null ? Long.valueOf(SnapshotUtil.snapshotIdAsOfTime(table, createTagSpec.getAsOfTime())) : Long.valueOf(table.currentSnapshot().snapshotId()));
        LOG.info("Creating tag {} on iceberg table {} with snapshotId {}", new Object[]{tagName, table.name(), snapshotId});
        ManageSnapshots manageSnapshots = table.manageSnapshots();
        manageSnapshots.createTag(tagName, snapshotId);
        if (createTagSpec.getMaxRefAgeMs() != null) {
            manageSnapshots.setMaxRefAgeMs(tagName, createTagSpec.getMaxRefAgeMs());
        }
        manageSnapshots.commit();
    }

    public static void dropTag(Table table, AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropTagSpec) {
        String tagName = dropTagSpec.getRefName();
        boolean ifExists = dropTagSpec.getIfExists();
        SnapshotRef snapshotRef = table.refs().get(tagName);
        if (snapshotRef != null || !ifExists) {
            LOG.info("Dropping tag {} on iceberg table {}", (Object)tagName, (Object)table.name());
            table.manageSnapshots().removeTag(tagName).commit();
        }
    }
}

