/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.util.Optional;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.util.SnapshotUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergBranchExec {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergBranchExec.class);

    private IcebergBranchExec() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void createBranch(Table table, AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createBranchSpec) {
        String branchName = createBranchSpec.getRefName();
        Long snapshotId = null;
        if (createBranchSpec.getSnapshotId() != null) {
            snapshotId = createBranchSpec.getSnapshotId();
        } else if (createBranchSpec.getAsOfTime() != null) {
            snapshotId = SnapshotUtil.snapshotIdAsOfTime(table, createBranchSpec.getAsOfTime());
        } else if (createBranchSpec.getAsOfTag() != null) {
            String tagName = createBranchSpec.getAsOfTag();
            SnapshotRef snapshotRef = table.refs().get(tagName);
            if (snapshotRef == null || !snapshotRef.isTag()) throw new IllegalArgumentException(String.format("Tag %s does not exist", tagName));
            snapshotId = snapshotRef.snapshotId();
        } else {
            snapshotId = Optional.ofNullable(table.currentSnapshot()).map(snapshot -> snapshot.snapshotId()).orElse(null);
        }
        ManageSnapshots manageSnapshots = table.manageSnapshots();
        if (snapshotId != null) {
            LOG.info("Creating a branch {} on an iceberg table {} with snapshotId {}", new Object[]{branchName, table.name(), snapshotId});
            manageSnapshots.createBranch(branchName, snapshotId);
        } else {
            LOG.info("Creating a branch {} on an empty iceberg table {}", (Object)branchName, (Object)table.name());
            manageSnapshots.createBranch(branchName);
        }
        if (createBranchSpec.getMaxRefAgeMs() != null) {
            manageSnapshots.setMaxRefAgeMs(branchName, createBranchSpec.getMaxRefAgeMs());
        }
        if (createBranchSpec.getMinSnapshotsToKeep() != null) {
            manageSnapshots.setMinSnapshotsToKeep(branchName, createBranchSpec.getMinSnapshotsToKeep());
        }
        if (createBranchSpec.getMaxSnapshotAgeMs() != null) {
            manageSnapshots.setMaxSnapshotAgeMs(branchName, createBranchSpec.getMaxSnapshotAgeMs());
        }
        manageSnapshots.commit();
    }

    public static void dropBranch(Table table, AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropBranchSpec) {
        String branchName = dropBranchSpec.getRefName();
        boolean ifExists = dropBranchSpec.getIfExists();
        SnapshotRef snapshotRef = table.refs().get(branchName);
        if (snapshotRef != null || !ifExists) {
            LOG.info("Dropping branch {} on iceberg table {}", (Object)branchName, (Object)table.name());
            table.manageSnapshots().removeBranch(branchName).commit();
        }
    }
}

