/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.data.TableMigrationUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HiveTableUtil.class);
    static final String TABLE_EXTENSION = ".table";

    private HiveTableUtil() {
    }

    public static void importFiles(String sourceLocation, String format, PartitionSpecProxy partitionSpecProxy, List<FieldSchema> partitionKeys, Properties icebergTableProperties, Configuration conf) throws MetaException {
        RemoteIterator<LocatedFileStatus> filesIterator = null;
        if (partitionSpecProxy.size() == 0) {
            filesIterator = HiveTableUtil.getFilesIterator(new Path(sourceLocation), conf);
        }
        Table icebergTable = Catalogs.createTable(conf, icebergTableProperties);
        AppendFiles append = icebergTable.newAppend();
        PartitionSpec spec = icebergTable.spec();
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(icebergTable.properties());
        String nameMappingString = icebergTable.properties().get("schema.name-mapping.default");
        NameMapping nameMapping = nameMappingString != null ? NameMappingParser.fromJson(nameMappingString) : null;
        try {
            if (partitionSpecProxy.size() == 0) {
                List<DataFile> dataFiles = HiveTableUtil.getDataFiles(filesIterator, Collections.emptyMap(), format, spec, metricsConfig, nameMapping, conf);
                dataFiles.forEach(append::appendFile);
            } else {
                PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpecProxy.getPartitionIterator();
                ArrayList<Callable<Void>> tasks = Lists.newArrayList();
                while (partitionIterator.hasNext()) {
                    Partition partition = (Partition)partitionIterator.next();
                    Callable<Void> task = () -> {
                        Path partitionPath = new Path(partition.getSd().getLocation());
                        String partitionName = Warehouse.makePartName((List)partitionKeys, (List)partition.getValues());
                        LinkedHashMap partitionSpec = Warehouse.makeSpecFromName((String)partitionName);
                        RemoteIterator<LocatedFileStatus> iterator = HiveTableUtil.getFilesIterator(partitionPath, conf);
                        List<DataFile> dataFiles = HiveTableUtil.getDataFiles(iterator, partitionSpec, format.toLowerCase(), spec, metricsConfig, nameMapping, conf);
                        AppendFiles appendFiles = append;
                        synchronized (appendFiles) {
                            dataFiles.forEach(append::appendFile);
                        }
                        return null;
                    };
                    tasks.add(task);
                }
                int numThreads = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ICEBERG_METADATA_GENERATOR_THREADS);
                ExecutorService executor = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setNameFormat("iceberg-metadata-generator-%d").setDaemon(true).build());
                executor.invokeAll(tasks);
                executor.shutdown();
            }
            append.commit();
        }
        catch (IOException | InterruptedException e) {
            throw new MetaException("Cannot import hive data into iceberg table.\n" + e.getMessage());
        }
    }

    private static List<DataFile> getDataFiles(RemoteIterator<LocatedFileStatus> fileStatusIterator, Map<String, String> partitionKeys, String format, PartitionSpec spec, MetricsConfig metricsConfig, NameMapping nameMapping, Configuration conf) throws IOException {
        ArrayList<DataFile> dataFiles = Lists.newArrayList();
        while (fileStatusIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusIterator.next();
            String fileName = fileStatus.getPath().getName();
            if (fileName.startsWith(".") || fileName.startsWith("_") || fileName.endsWith("metadata.json")) continue;
            partitionKeys.replaceAll((key, value) -> FileUtils.escapePathName((String)value));
            int[] stringFields = IntStream.range(0, spec.javaClasses().length).filter(i -> spec.javaClasses()[i].isAssignableFrom(String.class)).toArray();
            dataFiles.addAll(Lists.transform(TableMigrationUtil.listPartition(partitionKeys, fileStatus.getPath().toString(), format, spec, conf, metricsConfig, nameMapping), dataFile -> {
                StructLike structLike = dataFile.partition();
                for (int pos : stringFields) {
                    structLike.set(pos, FileUtils.unescapePathName((String)structLike.get(pos, String.class)));
                }
                return dataFile;
            }));
        }
        return dataFiles;
    }

    public static void appendFiles(URI fromURI, String format, Table icebergTbl, boolean isOverwrite, Map<String, String> partitionSpec, Configuration conf) throws SemanticException {
        try {
            Transaction transaction = icebergTbl.newTransaction();
            if (isOverwrite) {
                DeleteFiles delete = transaction.newDelete();
                if (partitionSpec != null) {
                    for (Map.Entry<String, String> part : partitionSpec.entrySet()) {
                        Type partKeyType = icebergTbl.schema().findType(part.getKey());
                        Object partKeyVal = Conversions.fromPartitionString(partKeyType, part.getValue());
                        delete.deleteFromRowFilter(Expressions.equal(part.getKey(), partKeyVal));
                    }
                } else {
                    delete.deleteFromRowFilter(Expressions.alwaysTrue());
                }
                delete.commit();
            }
            MetricsConfig metricsConfig = MetricsConfig.fromProperties(icebergTbl.properties());
            PartitionSpec spec = icebergTbl.spec();
            String nameMappingStr = icebergTbl.properties().get("schema.name-mapping.default");
            NameMapping nameMapping = null;
            if (nameMappingStr != null) {
                nameMapping = NameMappingParser.fromJson(nameMappingStr);
            }
            AppendFiles append = transaction.newAppend();
            Map<String, String> actualPartitionSpec = Optional.ofNullable(partitionSpec).orElse(Collections.emptyMap());
            String actualFormat = Optional.ofNullable(format).orElse("PARQUET").toLowerCase();
            RemoteIterator<LocatedFileStatus> iterator = HiveTableUtil.getFilesIterator(new Path(fromURI), conf);
            List<DataFile> dataFiles = HiveTableUtil.getDataFiles(iterator, actualPartitionSpec, actualFormat, spec, metricsConfig, nameMapping, conf);
            dataFiles.forEach(append::appendFile);
            append.commit();
            transaction.commitTransaction();
        }
        catch (Exception e) {
            throw new SemanticException("Can not append data files", (Throwable)e);
        }
    }

    public static RemoteIterator<LocatedFileStatus> getFilesIterator(Path path, Configuration conf) throws MetaException {
        try {
            FileSystem fileSystem = FileSystem.get((URI)path.toUri(), (Configuration)conf);
            return fileSystem.listFiles(path, true);
        }
        catch (IOException e) {
            throw new MetaException("Exception happened during the collection of file statuses.\n" + e.getMessage());
        }
    }

    static String generateTableObjectLocation(String tableLocation, Configuration conf) {
        return tableLocation + "/temp/" + conf.get(HiveConf.ConfVars.HIVE_QUERY_ID.varname) + TABLE_EXTENSION;
    }

    static void createFileForTableObject(Table table, Configuration conf) {
        String filePath = HiveTableUtil.generateTableObjectLocation(table.location(), conf);
        Table serializableTable = SerializableTable.copyOf(table);
        HiveIcebergStorageHandler.checkAndSkipIoConfigSerialization(conf, serializableTable);
        String serialized = SerializationUtil.serializeToBase64(serializableTable);
        OutputFile serializedTableFile = table.io().newOutputFile(filePath);
        try (ObjectOutputStream oos = new ObjectOutputStream(serializedTableFile.createOrOverwrite());){
            oos.writeObject(serialized);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        LOG.debug("Iceberg table metadata file is created {}", (Object)serializedTableFile);
    }

    static void cleanupTableObjectFile(String location, Configuration configuration) {
        String tableObjectLocation = HiveTableUtil.generateTableObjectLocation(location, configuration);
        try {
            Path toDelete = new Path(tableObjectLocation);
            FileSystem fs = Util.getFs(toDelete, configuration);
            fs.delete(toDelete, true);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    static Table readTableObjectFromFile(Configuration config) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isCtas(Properties properties) {
        return Boolean.parseBoolean(properties.getProperty("created_with_ctas"));
    }

    static Properties getSerializationProps() {
        Properties props = new Properties();
        props.put("serialization.format", "9");
        props.put("serialization.null.format", "NULL");
        return props;
    }

    static String getParseData(String parseData, String specId, ObjectMapper mapper, Integer currentSpecId) throws JsonProcessingException {
        Map map = (Map)mapper.readValue(parseData, Map.class);
        String partString = map.entrySet().stream().filter(entry -> entry.getValue() != null).map(Object::toString).collect(Collectors.joining("/"));
        String currentSpecMarker = currentSpecId.toString().equals(specId) ? "current-" : "";
        return String.format("%sspec-id=%s/%s", currentSpecMarker, specId, partString);
    }

    static JobConf getPartJobConf(Configuration confs, org.apache.hadoop.hive.ql.metadata.Table tbl) {
        JobConf job = new JobConf(confs);
        job.set("hive.io.file.readcolumn.names", "partition,spec_id,record_count,file_count,position_delete_record_count,position_delete_file_count,equality_delete_record_count,equality_delete_file_count,last_updated_at,total_data_file_size_in_bytes,last_updated_snapshot_id");
        job.set("iceberg.mr.table.location", tbl.getPath().toString());
        job.set("iceberg.mr.table.identifier", tbl.getFullyQualifiedName() + ".partitions");
        HiveConf.setVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_FETCH_OUTPUT_SERDE, (String)"org.apache.hadoop.hive.serde2.DelimitedJSONSerDe");
        HiveConf.setBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED, (boolean)false);
        return job;
    }
}

