/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.SnapshotContext;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.table.AbstractAlterTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.AlterTableType;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.create.like.CreateTableLikeDesc;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableSetPropertiesDesc;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.StorageFormatDescriptor;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.parse.AlterTableExecuteSpec;
import org.apache.hadoop.hive.ql.parse.AlterTableSnapshotRefSpec;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.TransformSpec;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.ql.stats.Partish;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.DefaultFetchFormatter;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.JobContextImpl;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.FindFiles;
import org.apache.iceberg.GenericBlobMetadata;
import org.apache.iceberg.GenericStatisticsFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.NullOrder;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionsTable;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SerializableTable;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortDirection;
import org.apache.iceberg.SortField;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionUtil;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hive.HiveSchemaUtil;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.HiveIcebergInputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergMetaHook;
import org.apache.iceberg.mr.hive.HiveIcebergOutputCommitter;
import org.apache.iceberg.mr.hive.HiveIcebergOutputFormat;
import org.apache.iceberg.mr.hive.HiveIcebergSerDe;
import org.apache.iceberg.mr.hive.HiveTableUtil;
import org.apache.iceberg.mr.hive.IcebergBranchExec;
import org.apache.iceberg.mr.hive.IcebergMetadataTables;
import org.apache.iceberg.mr.hive.IcebergTableUtil;
import org.apache.iceberg.mr.hive.IcebergTagExec;
import org.apache.iceberg.mr.hive.IcebergTransformSortFunctionUtil;
import org.apache.iceberg.mr.hive.actions.HiveIcebergDeleteOrphanFiles;
import org.apache.iceberg.puffin.Blob;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.Puffin;
import org.apache.iceberg.puffin.PuffinCompressionCodec;
import org.apache.iceberg.puffin.PuffinReader;
import org.apache.iceberg.puffin.PuffinWriter;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.base.Throwables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.SerializationUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.StructProjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergStorageHandler
implements HiveStoragePredicateHandler,
HiveStorageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergStorageHandler.class);
    private static final String ICEBERG_URI_PREFIX = "iceberg://";
    private static final Splitter TABLE_NAME_SPLITTER = Splitter.on("..");
    private static final String TABLE_NAME_SEPARATOR = "..";
    private static final int SPEC_IDX = 1;
    private static final int PART_IDX = 0;
    public static final String COPY_ON_WRITE = "copy-on-write";
    public static final String MERGE_ON_READ = "merge-on-read";
    public static final String STATS = "/stats/snap-";
    public static final String TABLE_DEFAULT_LOCATION = "TABLE_DEFAULT_LOCATION";
    private static final List<VirtualColumn> ACID_VIRTUAL_COLS = ImmutableList.of(VirtualColumn.PARTITION_SPEC_ID, VirtualColumn.PARTITION_HASH, VirtualColumn.FILE_PATH, VirtualColumn.ROW_POSITION);
    private static final List<FieldSchema> ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA = ACID_VIRTUAL_COLS.stream().map(v -> new FieldSchema(v.getName(), v.getTypeInfo().getTypeName(), "")).collect(Collectors.toList());
    private Configuration conf;

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveIcebergInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveIcebergOutputFormat.class;
    }

    public Class<? extends AbstractSerDe> getSerDeClass() {
        return HiveIcebergSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return new HiveIcebergMetaHook(this.conf);
    }

    public HiveAuthorizationProvider getAuthorizationProvider() {
        return null;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
        this.fallbackToNonVectorizedModeBasedOnProperties(tableDesc.getProperties());
        boolean allowDataFilesWithinTableLocationOnly = this.conf.getBoolean(HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.varname, HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.defaultBoolVal);
        map.put(HiveConf.ConfVars.HIVE_ICEBERG_ALLOW_DATAFILES_IN_TABLE_LOCATION_ONLY.varname, String.valueOf(allowDataFilesWithinTableLocationOnly));
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> map) {
        HiveIcebergStorageHandler.overlayTableProperties(this.conf, tableDesc, map);
        this.fallbackToNonVectorizedModeBasedOnProperties(tableDesc.getProperties());
        map.put("mapred.output.committer.class", HiveIcebergNoJobCommitter.class.getName());
        String opType = this.getOperationType();
        map.put("iceberg.mr.operation.type." + tableDesc.getTableName(), opType);
        tableDesc.getProperties().put("iceberg.mr.operation.type." + tableDesc.getTableName(), opType);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> map) {
    }

    public void configureInputJobCredentials(TableDesc tableDesc, Map<String, String> secrets) {
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        this.setCommonJobConf(jobConf);
        if (tableDesc != null && tableDesc.getProperties() != null && tableDesc.getProperties().get("iceberg.mr.operation.type." + tableDesc.getTableName()) != null) {
            String tableName = tableDesc.getTableName();
            String opKey = "iceberg.mr.operation.type." + tableName;
            jobConf.set(opKey, tableDesc.getProperties().getProperty(opKey));
            Preconditions.checkArgument(!tableName.contains(TABLE_NAME_SEPARATOR), "Can not handle table " + tableName + ". Its name contains '" + TABLE_NAME_SEPARATOR + "'");
            String tables = jobConf.get("iceberg.mr.output.tables");
            tables = tables == null ? tableName : tables + TABLE_NAME_SEPARATOR + tableName;
            jobConf.set("iceberg.mr.output.tables", tables);
            String catalogName = tableDesc.getProperties().getProperty("iceberg.catalog");
            if (catalogName != null) {
                jobConf.set("iceberg.mr.table.catalog." + tableName, catalogName);
            }
        }
        try {
            if (!jobConf.getBoolean(HiveConf.ConfVars.HIVE_IN_TEST_IDE.varname, false)) {
                Utilities.addDependencyJars((Configuration)jobConf, (Class[])new Class[]{HiveIcebergStorageHandler.class});
            }
        }
        catch (IOException e) {
            Throwables.propagate(e);
        }
    }

    public boolean directInsert() {
        return true;
    }

    public boolean alwaysUnpartitioned() {
        return true;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc exprNodeDesc) {
        HiveStoragePredicateHandler.DecomposedPredicate predicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        predicate.residualPredicate = (ExprNodeGenericFuncDesc)exprNodeDesc;
        ExprNodeDesc pushedPredicate = exprNodeDesc.clone();
        List subExprNodes = pushedPredicate.getChildren();
        if (subExprNodes.removeIf(nodeDesc -> nodeDesc.getCols() != null && nodeDesc.getCols().contains(VirtualColumn.FILE_PATH.getName()))) {
            if (subExprNodes.size() == 1) {
                pushedPredicate = (ExprNodeDesc)subExprNodes.get(0);
            } else if (subExprNodes.isEmpty()) {
                pushedPredicate = null;
            }
        }
        predicate.pushedPredicate = (ExprNodeGenericFuncDesc)pushedPredicate;
        Expression filterExpr = HiveIcebergInputFormat.getFilterExpr(this.conf, predicate.pushedPredicate);
        if (filterExpr != null) {
            SessionStateUtil.addResource((Configuration)this.conf, (String)"iceberg.query.filters", (Object)filterExpr);
        }
        return predicate;
    }

    public boolean canProvideBasicStatistics() {
        return true;
    }

    public StorageFormatDescriptor getStorageFormatDescriptor(org.apache.hadoop.hive.metastore.api.Table table) throws SemanticException {
        if (table.getParameters() != null) {
            String format = table.getParameters().getOrDefault("write.format.default", "PARQUET");
            return StorageFormat.getDescriptor((String)format, (String)"write.format.default");
        }
        return null;
    }

    public boolean supportsAppendData(org.apache.hadoop.hive.metastore.api.Table table, boolean withPartClause) throws SemanticException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, table);
        if (icebergTbl.spec().isUnpartitioned()) {
            return true;
        }
        if (this.hasUndergonePartitionEvolution(icebergTbl)) {
            if (withPartClause) {
                throw new SemanticException("Can not Load into an iceberg table, which has undergone partition evolution using the PARTITION clause");
            }
            return false;
        }
        return withPartClause;
    }

    public void appendFiles(org.apache.hadoop.hive.metastore.api.Table table, URI fromURI, boolean isOverwrite, Map<String, String> partitionSpec) throws SemanticException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, table);
        String format = (String)table.getParameters().get("write.format.default");
        HiveTableUtil.appendFiles(fromURI, format, icebergTbl, isOverwrite, partitionSpec, this.conf);
    }

    public Map<String, String> getBasicStatistics(Partish partish) {
        org.apache.hadoop.hive.ql.metadata.Table hmsTable = partish.getTable();
        Table table = this.getTable(hmsTable);
        HashMap<String, String> stats = Maps.newHashMap();
        if (this.getStatsSource().equals("ICEBERG")) {
            if (table.currentSnapshot() != null) {
                Map<String, String> summary = table.currentSnapshot().summary();
                if (summary != null) {
                    if (summary.containsKey("total-data-files")) {
                        stats.put("numFiles", summary.get("total-data-files"));
                    }
                    if (summary.containsKey("total-records")) {
                        long totalRecords = Long.parseLong(summary.get("total-records"));
                        if (summary.containsKey("total-equality-deletes") && summary.containsKey("total-position-deletes")) {
                            long totalEqDeletes = Long.parseLong(summary.get("total-equality-deletes"));
                            long totalPosDeletes = Long.parseLong(summary.get("total-position-deletes"));
                            long actualRecords = totalRecords - (totalEqDeletes > 0L ? 0L : totalPosDeletes);
                            totalRecords = actualRecords > 0L ? actualRecords : totalRecords;
                        }
                        stats.put("numRows", String.valueOf(totalRecords));
                    }
                    if (summary.containsKey("total-files-size")) {
                        stats.put("totalSize", summary.get("total-files-size"));
                    }
                }
            } else {
                stats.put("numFiles", "0");
                stats.put("numRows", "0");
                stats.put("totalSize", "0");
            }
        }
        return stats;
    }

    private Table getTable(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Optional queryState = SessionStateUtil.getQueryState((Configuration)this.conf);
        Table table = !queryState.isPresent() || ((QueryState)queryState.get()).getNumModifiedRows() > 0L ? IcebergTableUtil.getTable(this.conf, hmsTable.getTTable(), true) : IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return table;
    }

    public boolean canSetColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return table.currentSnapshot() != null && this.getStatsSource().equals("ICEBERG");
    }

    public boolean setColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable, List<ColumnStatistics> colStats) {
        Table tbl = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return this.writeColStats(colStats.get(0), tbl);
    }

    private boolean writeColStats(ColumnStatistics tableColStats, Table tbl) {
        try {
            GenericStatisticsFile statisticsFile;
            if (!this.shouldRewriteColStats(tbl)) {
                this.checkAndMergeColStats(tableColStats, tbl);
            }
            byte[] serializeColStats = SerializationUtils.serialize((Serializable)tableColStats);
            String statsPath = tbl.location() + STATS + UUID.randomUUID();
            try (PuffinWriter puffinWriter = Puffin.write(tbl.io().newOutputFile(statsPath)).createdBy("hive").build();){
                long snapshotId = tbl.currentSnapshot().snapshotId();
                long snapshotSequenceNumber = tbl.currentSnapshot().sequenceNumber();
                puffinWriter.add(new Blob(ColumnStatisticsObj.class.getSimpleName(), ImmutableList.of(Integer.valueOf(1)), snapshotId, snapshotSequenceNumber, ByteBuffer.wrap(serializeColStats), PuffinCompressionCodec.NONE, ImmutableMap.of()));
                puffinWriter.finish();
                statisticsFile = new GenericStatisticsFile(snapshotId, statsPath, puffinWriter.fileSize(), puffinWriter.footerSize(), puffinWriter.writtenBlobsMetadata().stream().map(GenericBlobMetadata::from).collect(ImmutableList.toImmutableList()));
            }
            catch (IOException e) {
                LOG.warn("Unable to write stats to puffin file {}", (Object)e.getMessage());
                return false;
            }
            tbl.updateStatistics().setStatistics(statisticsFile.snapshotId(), statisticsFile).commit();
            return true;
        }
        catch (Exception e) {
            LOG.warn("Unable to invalidate or merge stats: {}", (Object)e.getMessage());
            return false;
        }
    }

    public boolean canProvideColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return this.canSetColStatistics(hmsTable) && this.canProvideColStats(table, table.currentSnapshot().snapshotId());
    }

    private boolean canProvideColStats(Table table, long snapshotId) {
        return IcebergTableUtil.getColStatsPath(table, snapshotId).isPresent();
    }

    public List<ColumnStatisticsObj> getColStatistics(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        return IcebergTableUtil.getColStatsPath(table).map(statsPath -> this.readColStats(table, (Path)statsPath)).orElse(new ColumnStatistics()).getStatsObj();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ColumnStatistics readColStats(Table table, Path statsPath) {
        try (PuffinReader reader = Puffin.read(table.io().newInputFile(statsPath.toString())).build();){
            List<BlobMetadata> blobMetadata = reader.fileMetadata().blobs();
            Iterator it = Iterables.transform(reader.readAll(blobMetadata), Pair::second).iterator();
            if (!it.hasNext()) return new ColumnStatistics();
            byte[] byteBuffer = ByteBuffers.toByteArray((ByteBuffer)it.next());
            LOG.info("Using col stats from : {}", (Object)statsPath);
            ColumnStatistics columnStatistics = (ColumnStatistics)SerializationUtils.deserialize((byte[])byteBuffer);
            return columnStatistics;
        }
        catch (Exception e) {
            LOG.warn(" Unable to read col stats: ", (Throwable)e);
        }
        return new ColumnStatistics();
    }

    public boolean canComputeQueryUsingStats(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Map<String, String> summary;
        Table table;
        if (this.getStatsSource().equals("ICEBERG") && hmsTable.getMetaTable() == null && (table = this.getTable(hmsTable)).currentSnapshot() != null && (summary = table.currentSnapshot().summary()) != null && summary.containsKey("total-equality-deletes") && summary.containsKey("total-position-deletes")) {
            long totalPosDeletes;
            long totalEqDeletes = Long.parseLong(summary.get("total-equality-deletes"));
            return totalEqDeletes + (totalPosDeletes = Long.parseLong(summary.get("total-position-deletes"))) == 0L;
        }
        return false;
    }

    private String getStatsSource() {
        return HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ICEBERG_STATS_SOURCE, (String)"ICEBERG").toUpperCase();
    }

    private boolean shouldRewriteColStats(Table tbl) {
        return SessionStateUtil.getQueryState((Configuration)this.conf).map(QueryState::getHiveOperation).filter(opType -> HiveOperation.ANALYZE_TABLE == opType).isPresent() || IcebergTableUtil.getColStatsPath(tbl).isPresent();
    }

    private void checkAndMergeColStats(ColumnStatistics statsObjNew, Table tbl) throws InvalidObjectException {
        ColumnStatistics statsObjOld;
        Long previousSnapshotId = tbl.currentSnapshot().parentId();
        if (previousSnapshotId != null && this.canProvideColStats(tbl, previousSnapshotId) && (statsObjOld = (ColumnStatistics)IcebergTableUtil.getColStatsPath(tbl, previousSnapshotId).map(statsPath -> this.readColStats(tbl, (Path)statsPath)).orElse(null)) != null && statsObjOld.getStatsObjSize() != 0 && !statsObjNew.getStatsObj().isEmpty()) {
            MetaStoreServerUtils.mergeColStats((ColumnStatistics)statsObjNew, (ColumnStatistics)statsObjOld);
        }
    }

    public LockType getLockType(WriteEntity writeEntity) {
        return LockType.SHARED_READ;
    }

    public boolean supportsPartitionTransform() {
        return true;
    }

    public List<TransformSpec> getPartitionTransformSpec(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        return table.spec().fields().stream().map(f -> this.getTransformSpec(table, f.transform().toString().toUpperCase(), f.sourceId())).collect(Collectors.toList());
    }

    private List<TransformSpec> getSortTransformSpec(Table table) {
        return table.sortOrder().fields().stream().map(s -> this.getTransformSpec(table, s.transform().toString().toUpperCase(), s.sourceId())).collect(Collectors.toList());
    }

    private TransformSpec getTransformSpec(Table table, String transformName, int sourceId) {
        TransformSpec spec = new TransformSpec();
        spec.setColumnName(table.schema().findColumnName(sourceId));
        if (transformName.contains("[")) {
            spec.setTransformType(TransformSpec.TransformType.valueOf((String)transformName.substring(0, transformName.indexOf("["))));
            spec.setTransformParam(Optional.of(Integer.valueOf(transformName.substring(transformName.indexOf("[") + 1, transformName.indexOf("]")))));
        } else {
            spec.setTransformType(TransformSpec.TransformType.valueOf((String)transformName));
            spec.setTransformParam(Optional.empty());
        }
        return spec;
    }

    public DynamicPartitionCtx createDPContext(HiveConf hiveConf, org.apache.hadoop.hive.ql.metadata.Table hmsTable, Context.Operation writeOperation) throws SemanticException {
        SortOrder sortOrder;
        if (writeOperation == Context.Operation.DELETE && !this.shouldOverwrite(hmsTable, writeOperation)) {
            return null;
        }
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        DynamicPartitionCtx dpCtx = new DynamicPartitionCtx(Maps.newLinkedHashMap(), hiveConf.getVar(HiveConf.ConfVars.DEFAULT_PARTITION_NAME), hiveConf.getIntVar(HiveConf.ConfVars.DYNAMIC_PARTITION_MAX_PARTS_PER_NODE));
        LinkedList<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExprs = Lists.newLinkedList();
        dpCtx.setCustomSortExpressions(customSortExprs);
        if (table.spec().isPartitioned()) {
            this.addCustomSortExpr(table, hmsTable, writeOperation, customSortExprs, this.getPartitionTransformSpec(hmsTable));
        }
        if ((sortOrder = table.sortOrder()).isSorted()) {
            LinkedList<Integer> customSortPositions = Lists.newLinkedList();
            LinkedList<Integer> customSortOrder = Lists.newLinkedList();
            dpCtx.setCustomSortOrder(customSortOrder);
            LinkedList<Integer> customSortNullOrder = Lists.newLinkedList();
            dpCtx.setCustomSortNullOrder(customSortNullOrder);
            block0: for (SortField sortField : sortOrder.fields()) {
                int pos = 0;
                for (Types.NestedField field : table.schema().columns()) {
                    if (sortField.sourceId() == field.fieldId()) {
                        customSortPositions.add(pos);
                        customSortOrder.add(sortField.direction() == SortDirection.ASC ? 1 : 0);
                        customSortNullOrder.add(sortField.nullOrder() == NullOrder.NULLS_FIRST ? 0 : 1);
                        continue block0;
                    }
                    ++pos;
                }
            }
            this.addCustomSortExpr(table, hmsTable, writeOperation, customSortExprs, this.getSortTransformSpec(table));
        }
        dpCtx.setHasCustomSortExprs(!customSortExprs.isEmpty());
        return dpCtx;
    }

    private void addCustomSortExpr(Table table, org.apache.hadoop.hive.ql.metadata.Table hmsTable, Context.Operation writeOperation, List<Function<List<ExprNodeDesc>, ExprNodeDesc>> customSortExprs, List<TransformSpec> transformSpecs) {
        HashMap<String, Integer> fieldOrderMap = Maps.newHashMap();
        List<Types.NestedField> fields = table.schema().columns();
        for (int i = 0; i < fields.size(); ++i) {
            fieldOrderMap.put(fields.get(i).name(), i);
        }
        int offset = (this.shouldOverwrite(hmsTable, writeOperation) ? ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA : this.acidSelectColumns(hmsTable, writeOperation)).size();
        customSortExprs.addAll(transformSpecs.stream().map(spec -> IcebergTransformSortFunctionUtil.getCustomSortExprs(spec, (Integer)fieldOrderMap.get(spec.getColumnName()) + offset)).collect(Collectors.toList()));
    }

    public String getFileFormatPropertyKey() {
        return "write.format.default";
    }

    public boolean commitInMoveTask() {
        return true;
    }

    public void storageHandlerCommit(Properties commitProperties, Context.Operation operation) throws HiveException {
        List<JobContext> jobContextList;
        String tableName = commitProperties.getProperty("name");
        String location = commitProperties.getProperty("location");
        String snapshotRef = commitProperties.getProperty("snapshot_ref");
        HiveConf configuration = SessionState.getSessionConf();
        if (location != null) {
            HiveTableUtil.cleanupTableObjectFile(location, (Configuration)configuration);
        }
        if ((jobContextList = this.generateJobContext((Configuration)configuration, tableName, snapshotRef)).isEmpty()) {
            return;
        }
        HiveIcebergOutputCommitter committer = this.getOutputCommitter();
        try {
            committer.commitJobs(jobContextList, operation);
        }
        catch (Throwable e) {
            String ids = jobContextList.stream().map(jobContext -> jobContext.getJobID().toString()).collect(Collectors.joining(", "));
            LOG.error("Error while trying to commit job: {}, starting rollback changes for table: {}", new Object[]{ids, tableName, e});
            try {
                committer.abortJobs(jobContextList);
            }
            catch (IOException ioe) {
                LOG.error("Error while trying to abort failed job. There might be uncleaned data files.", (Throwable)ioe);
            }
            throw new HiveException("Error committing job: " + ids + " for table: " + tableName, e);
        }
    }

    public HiveIcebergOutputCommitter getOutputCommitter() {
        return new HiveIcebergOutputCommitter();
    }

    public boolean isAllowedAlterOperation(AlterTableType opType) {
        return HiveIcebergMetaHook.SUPPORTED_ALTER_OPS.contains(opType);
    }

    public boolean supportsTruncateOnNonNativeTables() {
        return true;
    }

    public boolean isTimeTravelAllowed() {
        return true;
    }

    public boolean isTableMetaRefSupported() {
        return true;
    }

    public void executeOperation(org.apache.hadoop.hive.ql.metadata.Table hmsTable, AlterTableExecuteSpec executeSpec) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table icebergTable = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        switch (executeSpec.getOperationType()) {
            case ROLLBACK: {
                LOG.info("Executing rollback operation on iceberg table. If you would like to revert rollback you could try altering the metadata location to the current metadata location by executing the following query:ALTER TABLE {}.{} SET TBLPROPERTIES('metadata_location'='{}'). This operation is supported for Hive Catalog tables.", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), ((BaseTable)icebergTable).operations().current().metadataFileLocation()});
                AlterTableExecuteSpec.RollbackSpec rollbackSpec = (AlterTableExecuteSpec.RollbackSpec)executeSpec.getOperationParams();
                IcebergTableUtil.rollback(icebergTable, rollbackSpec.getRollbackType(), rollbackSpec.getParam());
                break;
            }
            case EXPIRE_SNAPSHOT: {
                LOG.info("Executing expire snapshots operation on iceberg table {}.{}", (Object)hmsTable.getDbName(), (Object)hmsTable.getTableName());
                AlterTableExecuteSpec.ExpireSnapshotsSpec expireSnapshotsSpec = (AlterTableExecuteSpec.ExpireSnapshotsSpec)executeSpec.getOperationParams();
                int numThreads = this.conf.getInt(HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.varname, HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.defaultIntVal);
                this.expireSnapshot(icebergTable, expireSnapshotsSpec, numThreads);
                break;
            }
            case SET_CURRENT_SNAPSHOT: {
                AlterTableExecuteSpec.SetCurrentSnapshotSpec setSnapshotVersionSpec = (AlterTableExecuteSpec.SetCurrentSnapshotSpec)executeSpec.getOperationParams();
                LOG.debug("Executing set current snapshot operation on iceberg table {}.{} to version {}", new Object[]{hmsTable.getDbName(), hmsTable.getTableName(), setSnapshotVersionSpec.getSnapshotIdOrRefName()});
                IcebergTableUtil.setCurrentSnapshot(icebergTable, setSnapshotVersionSpec.getSnapshotIdOrRefName());
                break;
            }
            case FAST_FORWARD: {
                AlterTableExecuteSpec.FastForwardSpec fastForwardSpec = (AlterTableExecuteSpec.FastForwardSpec)executeSpec.getOperationParams();
                IcebergTableUtil.fastForwardBranch(icebergTable, fastForwardSpec.getSourceBranch(), fastForwardSpec.getTargetBranch());
                break;
            }
            case CHERRY_PICK: {
                AlterTableExecuteSpec.CherryPickSpec cherryPickSpec = (AlterTableExecuteSpec.CherryPickSpec)executeSpec.getOperationParams();
                IcebergTableUtil.cherryPick(icebergTable, cherryPickSpec.getSnapshotId());
                break;
            }
            case DELETE_METADATA: {
                AlterTableExecuteSpec.DeleteMetadataSpec deleteMetadataSpec = (AlterTableExecuteSpec.DeleteMetadataSpec)executeSpec.getOperationParams();
                IcebergTableUtil.performMetadataDelete(icebergTable, deleteMetadataSpec.getBranchName(), deleteMetadataSpec.getSarg());
                break;
            }
            case DELETE_ORPHAN_FILES: {
                int numDeleteThreads = this.conf.getInt(HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.varname, HiveConf.ConfVars.HIVE_ICEBERG_EXPIRE_SNAPSHOT_NUMTHREADS.defaultIntVal);
                AlterTableExecuteSpec.DeleteOrphanFilesDesc deleteOrphanFilesSpec = (AlterTableExecuteSpec.DeleteOrphanFilesDesc)executeSpec.getOperationParams();
                this.deleteOrphanFiles(icebergTable, deleteOrphanFilesSpec.getTimestampMillis(), numDeleteThreads);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Operation type %s is not supported", executeSpec.getOperationType().name()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOrphanFiles(Table icebergTable, long timestampMillis, int numThreads) {
        ExecutorService deleteExecutorService = null;
        try {
            if (numThreads > 0) {
                LOG.info("Executing delete orphan files on iceberg table {} with {} threads", (Object)icebergTable.name(), (Object)numThreads);
                deleteExecutorService = this.getDeleteExecutorService(icebergTable.name(), numThreads);
            }
            HiveIcebergDeleteOrphanFiles deleteOrphanFiles = new HiveIcebergDeleteOrphanFiles(this.conf, icebergTable);
            deleteOrphanFiles.olderThan(timestampMillis);
            if (deleteExecutorService != null) {
                deleteOrphanFiles.executeDeleteWith(deleteExecutorService);
            }
            DeleteOrphanFiles.Result result = deleteOrphanFiles.execute();
            LOG.debug("Cleaned files {} for {}", result.orphanFileLocations(), (Object)icebergTable);
        }
        finally {
            if (deleteExecutorService != null) {
                deleteExecutorService.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSnapshot(Table icebergTable, AlterTableExecuteSpec.ExpireSnapshotsSpec expireSnapshotsSpec, int numThreads) {
        ExecutorService deleteExecutorService = null;
        try {
            if (numThreads > 0) {
                LOG.info("Executing expire snapshots on iceberg table {} with {} threads", (Object)icebergTable.name(), (Object)numThreads);
                deleteExecutorService = this.getDeleteExecutorService(icebergTable.name(), numThreads);
            }
            if (expireSnapshotsSpec == null) {
                this.expireSnapshotWithDefaultParams(icebergTable, deleteExecutorService);
            } else if (expireSnapshotsSpec.isExpireByTimestampRange()) {
                this.expireSnapshotByTimestampRange(icebergTable, expireSnapshotsSpec.getFromTimestampMillis(), expireSnapshotsSpec.getTimestampMillis(), deleteExecutorService);
            } else if (expireSnapshotsSpec.isExpireByIds()) {
                this.expireSnapshotByIds(icebergTable, expireSnapshotsSpec.getIdsToExpire(), deleteExecutorService);
            } else if (expireSnapshotsSpec.isExpireByRetainLast()) {
                this.expireSnapshotRetainLast(icebergTable, expireSnapshotsSpec.getNumRetainLast(), deleteExecutorService);
            } else {
                this.expireSnapshotOlderThanTimestamp(icebergTable, expireSnapshotsSpec.getTimestampMillis(), deleteExecutorService);
            }
        }
        finally {
            if (deleteExecutorService != null) {
                deleteExecutorService.shutdown();
            }
        }
    }

    private void expireSnapshotWithDefaultParams(Table icebergTable, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotRetainLast(Table icebergTable, int numRetainLast, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        expireSnapshots.retainLast(numRetainLast);
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotByTimestampRange(Table icebergTable, Long fromTimestamp, Long toTimestamp, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
        for (Snapshot snapshot : icebergTable.snapshots()) {
            if (snapshot.timestampMillis() < fromTimestamp || snapshot.timestampMillis() > toTimestamp) continue;
            expireSnapshots.expireSnapshotId(snapshot.snapshotId());
            LOG.debug("Expiring snapshot on {} with id: {} and timestamp: {}", new Object[]{icebergTable.name(), snapshot.snapshotId(), snapshot.timestampMillis()});
        }
        LOG.info("Expiring snapshot on {} within time range {} -> {}", new Object[]{icebergTable.name(), fromTimestamp, toTimestamp});
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotOlderThanTimestamp(Table icebergTable, Long timestamp, ExecutorService deleteExecutorService) {
        ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots().expireOlderThan(timestamp);
        if (deleteExecutorService != null) {
            expireSnapshots.executeDeleteWith(deleteExecutorService);
        }
        expireSnapshots.commit();
    }

    private void expireSnapshotByIds(Table icebergTable, String[] idsToExpire, ExecutorService deleteExecutorService) {
        if (idsToExpire.length != 0) {
            ExpireSnapshots expireSnapshots = icebergTable.expireSnapshots();
            for (String id : idsToExpire) {
                expireSnapshots.expireSnapshotId(Long.parseLong(id));
            }
            LOG.info("Expiring snapshot on {} for snapshot Ids: {}", (Object)icebergTable.name(), (Object)Arrays.toString(idsToExpire));
            if (deleteExecutorService != null) {
                expireSnapshots = expireSnapshots.executeDeleteWith(deleteExecutorService);
            }
            expireSnapshots.commit();
        }
    }

    private ExecutorService getDeleteExecutorService(String completeName, int numThreads) {
        AtomicInteger deleteThreadsIndex = new AtomicInteger(0);
        return Executors.newFixedThreadPool(numThreads, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("remove-snapshot-" + completeName + "-" + deleteThreadsIndex.getAndIncrement());
            return thread;
        });
    }

    public void alterTableSnapshotRefOperation(org.apache.hadoop.hive.ql.metadata.Table hmsTable, AlterTableSnapshotRefSpec alterTableSnapshotRefSpec) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table icebergTable = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        switch (alterTableSnapshotRefSpec.getOperationType()) {
            case CREATE_BRANCH: {
                AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createBranchSpec = (AlterTableSnapshotRefSpec.CreateSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergBranchExec.createBranch(icebergTable, createBranchSpec);
                break;
            }
            case CREATE_TAG: {
                Optional.ofNullable(icebergTable.currentSnapshot()).orElseThrow(() -> new UnsupportedOperationException(String.format("Cannot alter %s on iceberg table %s.%s which has no snapshot", alterTableSnapshotRefSpec.getOperationType().getName(), hmsTable.getDbName(), hmsTable.getTableName())));
                AlterTableSnapshotRefSpec.CreateSnapshotRefSpec createTagSpec = (AlterTableSnapshotRefSpec.CreateSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergTagExec.createTag(icebergTable, createTagSpec);
                break;
            }
            case DROP_BRANCH: {
                AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropBranchSpec = (AlterTableSnapshotRefSpec.DropSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergBranchExec.dropBranch(icebergTable, dropBranchSpec);
                break;
            }
            case DROP_TAG: {
                AlterTableSnapshotRefSpec.DropSnapshotRefSpec dropTagSpec = (AlterTableSnapshotRefSpec.DropSnapshotRefSpec)alterTableSnapshotRefSpec.getOperationParams();
                IcebergTagExec.dropTag(icebergTable, dropTagSpec);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Operation type %s is not supported", alterTableSnapshotRefSpec.getOperationType().getName()));
            }
        }
    }

    public boolean isValidMetadataTable(String metaTableName) {
        return metaTableName != null && IcebergMetadataTables.isValidMetaTable(metaTableName);
    }

    public org.apache.hadoop.hive.ql.metadata.Table checkAndSetTableMetaRef(org.apache.hadoop.hive.ql.metadata.Table hmsTable, String tableMetaRef) throws SemanticException {
        String refName = HiveUtils.getTableSnapshotRef((String)tableMetaRef);
        if (refName != null) {
            Table tbl = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
            if (tbl.snapshot(refName) != null) {
                hmsTable.setSnapshotRef(tableMetaRef);
                return hmsTable;
            }
            throw new SemanticException(String.format("Cannot use snapshotRef (does not exist): %s", refName));
        }
        if (IcebergMetadataTables.isValidMetaTable(tableMetaRef)) {
            hmsTable.setMetaTable(tableMetaRef);
            return hmsTable;
        }
        throw new SemanticException(ErrorMsg.INVALID_METADATA_TABLE_NAME, new String[]{tableMetaRef});
    }

    public URI getURIForAuth(org.apache.hadoop.hive.metastore.api.Table hmsTable) throws URISyntaxException {
        String dbName = hmsTable.getDbName();
        String tableName = hmsTable.getTableName();
        StringBuilder authURI = new StringBuilder(ICEBERG_URI_PREFIX).append(HiveIcebergStorageHandler.encodeString(dbName)).append("/").append(HiveIcebergStorageHandler.encodeString(tableName)).append("?snapshot=");
        Optional metadataLocation = SessionStateUtil.getProperty((Configuration)this.conf, (String)"metadata_location");
        if (metadataLocation.isPresent()) {
            authURI.append(this.getPathForAuth((String)metadataLocation.get()));
        } else {
            Optional locationProperty = SessionStateUtil.getProperty((Configuration)this.conf, (String)"location");
            if (locationProperty.isPresent()) {
                authURI.append(this.getPathForAuth((String)locationProperty.get())).append(HiveIcebergStorageHandler.encodeString("/metadata/dummy.metadata.json"));
            } else {
                Table table = IcebergTableUtil.getTable(this.conf, hmsTable);
                authURI.append(this.getPathForAuth(((BaseTable)table).operations().current().metadataFileLocation(), hmsTable.getSd().getLocation()));
            }
        }
        LOG.debug("Iceberg storage handler authorization URI {}", (Object)authURI);
        return new URI(authURI.toString());
    }

    @VisibleForTesting
    static String encodeString(String rawString) {
        if (rawString == null) {
            return null;
        }
        return HiveConf.EncoderDecoderFactory.URL_ENCODER_DECODER.encode(rawString);
    }

    String getPathForAuth(String locationProperty) {
        return this.getPathForAuth(locationProperty, SessionStateUtil.getProperty((Configuration)this.conf, (String)"defaultLocation").orElse(null));
    }

    String getPathForAuth(String locationProperty, String defaultTableLocation) {
        boolean maskDefaultLocation = this.conf.getBoolean(HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.varname, HiveConf.ConfVars.HIVE_ICEBERG_MASK_DEFAULT_LOCATION.defaultBoolVal);
        String location = URI.create(locationProperty).getPath();
        if (!maskDefaultLocation || defaultTableLocation == null || !this.arePathsInSameFs(locationProperty, defaultTableLocation)) {
            return HiveIcebergStorageHandler.encodeString(location);
        }
        try {
            Path locationPath = new Path(location);
            Path defaultLocationPath = locationPath.toUri().getScheme() != null ? FileUtils.makeQualified((Path)new Path(defaultTableLocation), (Configuration)this.conf) : Path.getPathWithoutSchemeAndAuthority((Path)new Path(defaultTableLocation));
            return HiveIcebergStorageHandler.encodeString(location.replaceFirst(defaultLocationPath.toString(), TABLE_DEFAULT_LOCATION));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean arePathsInSameFs(String locationProperty, String defaultTableLocation) {
        try {
            return FileUtils.equalsFileSystem((FileSystem)new Path(locationProperty).getFileSystem(this.conf), (FileSystem)new Path(defaultTableLocation).getFileSystem(this.conf));
        }
        catch (IOException e) {
            LOG.debug("Unable to get FileSystem for path {} and {}", (Object)locationProperty, (Object)defaultTableLocation);
            return false;
        }
    }

    public void validateSinkDesc(FileSinkDesc sinkDesc) throws SemanticException {
        super.validateSinkDesc(sinkDesc);
        if (sinkDesc.getInsertOverwrite()) {
            Table table = IcebergTableUtil.getTable(this.conf, sinkDesc.getTableInfo().getProperties());
            if (table.currentSnapshot() != null && Long.parseLong(table.currentSnapshot().summary().get("total-records")) == 0L) {
                return;
            }
            if (Context.RewritePolicy.fromString((String)this.conf.get(HiveConf.ConfVars.REWRITE_POLICY.varname, Context.RewritePolicy.DEFAULT.name())) == Context.RewritePolicy.ALL_PARTITIONS) {
                return;
            }
            if (IcebergTableUtil.isBucketed(table)) {
                throw new SemanticException("Cannot perform insert overwrite query on bucket partitioned Iceberg table.");
            }
            if (this.hasUndergonePartitionEvolution(table)) {
                throw new SemanticException("Cannot perform insert overwrite query on Iceberg table where partition evolution happened. In order to successfully carry out any insert overwrite operation on this table, the data has to be rewritten conforming to the latest spec. ");
            }
        }
    }

    public HiveStorageHandler.AcidSupportType supportsAcidOperations() {
        return HiveStorageHandler.AcidSupportType.WITHOUT_TRANSACTIONS;
    }

    public List<VirtualColumn> acidVirtualColumns() {
        return ACID_VIRTUAL_COLS;
    }

    public List<FieldSchema> acidSelectColumns(org.apache.hadoop.hive.ql.metadata.Table table, Context.Operation operation) {
        switch (operation) {
            case DELETE: {
                return ListUtils.union(ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA, (List)table.getCols());
            }
            case UPDATE: {
                return this.shouldOverwrite(table, operation) ? ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA : ListUtils.union(ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA, (List)table.getCols());
            }
            case MERGE: {
                return ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA;
            }
        }
        return ImmutableList.of();
    }

    public FieldSchema getRowId() {
        VirtualColumn rowId = VirtualColumn.ROW_POSITION;
        return new FieldSchema(rowId.getName(), rowId.getTypeInfo().getTypeName(), "");
    }

    public List<FieldSchema> acidSortColumns(org.apache.hadoop.hive.ql.metadata.Table table, Context.Operation operation) {
        switch (operation) {
            case DELETE: {
                return ACID_VIRTUAL_COLS_AS_FIELD_SCHEMA;
            }
        }
        return ImmutableList.of();
    }

    public boolean supportsSortColumns() {
        return true;
    }

    public List<FieldSchema> sortColumns(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        if (table.sortOrder().isUnsorted()) {
            return Collections.emptyList();
        }
        Schema schema = table.schema();
        List<FieldSchema> hiveSchema = HiveSchemaUtil.convert(schema);
        Map<String, String> colNameToColType = hiveSchema.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getType));
        return table.sortOrder().fields().stream().map(s -> new FieldSchema(schema.findColumnName(s.sourceId()), (String)colNameToColType.get(schema.findColumnName(s.sourceId())), String.format("Transform: %s, Sort direction: %s, Null sort order: %s", s.transform().toString(), s.direction().name(), s.nullOrder().name()))).collect(Collectors.toList());
    }

    private void setCommonJobConf(JobConf jobConf) {
        jobConf.set("tez.mrreader.config.update.properties", "hive.io.file.readcolumn.names,hive.io.file.readcolumn.ids");
    }

    public StorageFormat.StorageHandlerTypes getType() {
        return StorageFormat.StorageHandlerTypes.ICEBERG;
    }

    public boolean addDynamicSplitPruningEdge(org.apache.hadoop.hive.ql.metadata.Table table, ExprNodeDesc syntheticFilterPredicate) {
        try {
            ExprNodeDesc clone;
            String filterColumn;
            Collection<String> partitionColumns = ((HiveIcebergSerDe)table.getDeserializer()).partitionColumns();
            if (partitionColumns.size() > 0 && partitionColumns.contains(filterColumn = this.collectColumnAndReplaceDummyValues(clone = syntheticFilterPredicate.clone(), null))) {
                SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)((ExprNodeGenericFuncDesc)clone));
                HiveIcebergFilterFactory.generateFilterExpression(sarg);
                LOG.debug("Found Iceberg partition column to prune with predicate {}", (Object)syntheticFilterPredicate);
                return true;
            }
        }
        catch (UnsupportedOperationException uoe) {
            LOG.debug("Unsupported predicate {}", (Object)syntheticFilterPredicate, (Object)uoe);
        }
        LOG.debug("Not found Iceberg partition columns to prune with predicate {}", (Object)syntheticFilterPredicate);
        return false;
    }

    public static Table table(Configuration config, String name) {
        Table table = (Table)SerializationUtil.deserializeFromBase64(config.get("iceberg.mr.serialized.table." + name));
        if (table == null && config.getBoolean("created_with_ctas", false) && StringUtils.isNotBlank((CharSequence)config.get("iceberg.mr.table.location"))) {
            table = HiveTableUtil.readTableObjectFromFile(config);
        }
        HiveIcebergStorageHandler.checkAndSetIoConfig(config, table);
        return table;
    }

    public static void checkAndSetIoConfig(Configuration config, Table table) {
        if (table != null && config.getBoolean("iceberg.mr.config.serialization.disabled", true) && table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).setConf(config);
        }
    }

    public static void checkAndSkipIoConfigSerialization(Configuration config, Table table) {
        if (table != null && config.getBoolean("iceberg.mr.config.serialization.disabled", true) && table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).serializeConfWith(conf -> new NonSerializingConfig(config)::get);
        }
    }

    public static Set<String> outputTables(Configuration config) {
        return Sets.newHashSet(TABLE_NAME_SPLITTER.split(config.get("iceberg.mr.output.tables")));
    }

    public static String catalogName(Configuration config, String name) {
        return config.get("iceberg.mr.table.catalog." + name);
    }

    public static Schema schema(Configuration config) {
        return SchemaParser.fromJson(config.get("iceberg.mr.table.schema"));
    }

    @VisibleForTesting
    static void overlayTableProperties(Configuration configuration, TableDesc tableDesc, Map<String, String> map) {
        PartitionSpec spec;
        Schema schema;
        String location;
        Properties props = tableDesc.getProperties();
        Maps.fromProperties(props).entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(entry -> {
            String cfr_ignored_0 = (String)map.put((String)entry.getKey(), (String)entry.getValue());
        });
        try {
            Table table = IcebergTableUtil.getTable(configuration, props);
            location = table.location();
            schema = table.schema();
            spec = table.spec();
            Table serializableTable = SerializableTable.copyOf(table);
            HiveIcebergStorageHandler.checkAndSkipIoConfigSerialization(configuration, serializableTable);
            map.put("iceberg.mr.serialized.table." + tableDesc.getTableName(), SerializationUtil.serializeToBase64(serializableTable));
        }
        catch (NoSuchTableException ex) {
            if (!HiveTableUtil.isCtas(props)) {
                throw ex;
            }
            if (!Catalogs.hiveCatalog(configuration, props)) {
                throw new UnsupportedOperationException("CTAS target table must be a HiveCatalog table. For other catalog types, the target Iceberg table would be created successfully but the table will not be registered in HMS. This means that even though the CTAS query succeeds, the new table wouldn't be immediately queryable from Hive, since HMS does not know about it.");
            }
            location = map.get("location");
            map.put("iceberg.mr.serialized.table." + tableDesc.getTableName(), SerializationUtil.serializeToBase64(null));
            try {
                AbstractSerDe serDe = tableDesc.getDeserializer(configuration);
                HiveIcebergSerDe icebergSerDe = (HiveIcebergSerDe)serDe;
                schema = icebergSerDe.getTableSchema();
                spec = IcebergTableUtil.spec(configuration, icebergSerDe.getTableSchema());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        map.put("iceberg.mr.table.identifier", props.getProperty("name"));
        if (StringUtils.isNotBlank((CharSequence)location)) {
            map.put("iceberg.mr.table.location", location);
        }
        String schemaJson = SchemaParser.toJson(schema);
        map.put("iceberg.mr.table.schema", schemaJson);
        props.put("iceberg.mr.table.schema", schemaJson);
        if (spec == null) {
            spec = PartitionSpec.unpartitioned();
        }
        props.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(spec));
        map.remove("columns.comments");
    }

    private String collectColumnAndReplaceDummyValues(ExprNodeDesc node, String foundColumn) {
        String column = foundColumn;
        List children = node.getChildren();
        if (children != null && !children.isEmpty()) {
            ListIterator<ExprNodeConstantDesc> iterator = children.listIterator();
            while (iterator.hasNext()) {
                ExprNodeDesc child = (ExprNodeDesc)iterator.next();
                if (child instanceof ExprNodeDynamicListDesc) {
                    Object dummy;
                    switch (((PrimitiveTypeInfo)child.getTypeInfo()).getPrimitiveCategory()) {
                        case INT: 
                        case SHORT: {
                            dummy = 1;
                            break;
                        }
                        case LONG: {
                            dummy = 1L;
                            break;
                        }
                        case TIMESTAMP: 
                        case TIMESTAMPLOCALTZ: {
                            dummy = new Timestamp();
                            break;
                        }
                        case CHAR: 
                        case VARCHAR: 
                        case STRING: {
                            dummy = "1";
                            break;
                        }
                        case DOUBLE: 
                        case FLOAT: 
                        case DECIMAL: {
                            dummy = 1.1;
                            break;
                        }
                        case DATE: {
                            dummy = new Date();
                            break;
                        }
                        case BOOLEAN: {
                            dummy = true;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Not supported primitive type in partition pruning: " + child.getTypeInfo());
                        }
                    }
                    iterator.set(new ExprNodeConstantDesc(child.getTypeInfo(), dummy));
                    continue;
                }
                String newColumn = child instanceof ExprNodeColumnDesc ? ((ExprNodeColumnDesc)child).getColumn() : this.collectColumnAndReplaceDummyValues(child, column);
                if (column != null && newColumn != null && !newColumn.equals(column)) {
                    throw new UnsupportedOperationException("Partition pruning does not support filtering for more columns");
                }
                if (column != null) continue;
                column = newColumn;
            }
        }
        return column;
    }

    private void fallbackToNonVectorizedModeBasedOnProperties(Properties tableProps) {
        Schema tableSchema = SchemaParser.fromJson(tableProps.getProperty("iceberg.mr.table.schema"));
        if (FileFormat.AVRO.name().equalsIgnoreCase(tableProps.getProperty("write.format.default")) || this.isValidMetadataTable(tableProps.getProperty("metaTable")) || HiveIcebergStorageHandler.hasOrcTimeInSchema(tableProps, tableSchema) || !HiveIcebergStorageHandler.hasParquetNestedTypeWithinListOrMap(tableProps, tableSchema)) {
            this.conf.setBoolean(HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, false);
        }
    }

    private static boolean hasOrcTimeInSchema(Properties tableProps, Schema tableSchema) {
        if (!FileFormat.ORC.name().equalsIgnoreCase(tableProps.getProperty("write.format.default"))) {
            return false;
        }
        return tableSchema.columns().stream().anyMatch(f -> Types.TimeType.get().typeId() == f.type().typeId());
    }

    private static boolean hasParquetNestedTypeWithinListOrMap(Properties tableProps, Schema tableSchema) {
        if (!FileFormat.PARQUET.name().equalsIgnoreCase(tableProps.getProperty("write.format.default"))) {
            return true;
        }
        for (Types.NestedField field : tableSchema.columns()) {
            if (!field.type().isListType() && !field.type().isMapType()) continue;
            for (Types.NestedField nestedField : field.type().asNestedType().fields()) {
                if (nestedField.type().isPrimitiveType()) continue;
                return false;
            }
        }
        return true;
    }

    private List<JobContext> generateJobContext(Configuration configuration, String tableName, String branchName) {
        JobConf jobConf = new JobConf(configuration);
        Optional commitInfoMap = SessionStateUtil.getCommitInfo((Configuration)jobConf, (String)tableName);
        if (commitInfoMap.isPresent()) {
            LinkedList<JobContext> jobContextList = Lists.newLinkedList();
            for (SessionStateUtil.CommitInfo commitInfo : ((Map)commitInfoMap.get()).values()) {
                JobID jobID = JobID.forName((String)commitInfo.getJobIdStr());
                commitInfo.getProps().forEach((arg_0, arg_1) -> ((JobConf)jobConf).set(arg_0, arg_1));
                jobConf.set("iceberg.mr.output.tables", tableName);
                if (branchName != null) {
                    jobConf.set("iceberg.mr.output.table.snapshot.ref", branchName);
                }
                jobContextList.add((JobContext)new JobContextImpl(jobConf, (org.apache.hadoop.mapreduce.JobID)jobID, null));
            }
            return jobContextList;
        }
        LOG.debug("Unable to find commit information in query state for table: {}", (Object)tableName);
        return Collections.emptyList();
    }

    private String getOperationType() {
        return SessionStateUtil.getProperty((Configuration)this.conf, (String)Context.Operation.class.getSimpleName()).orElse(Context.Operation.OTHER.name());
    }

    public boolean areSnapshotsSupported() {
        return true;
    }

    public SnapshotContext getCurrentSnapshotContext(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        Snapshot current = table.currentSnapshot();
        if (current == null) {
            return null;
        }
        return new SnapshotContext(current.snapshotId());
    }

    public void prepareAlterTableEnvironmentContext(AbstractAlterTableDesc alterTableDesc, EnvironmentContext environmentContext) {
        if (alterTableDesc instanceof AlterTableSetPropertiesDesc && alterTableDesc.getProps().containsKey("metadata_location")) {
            environmentContext.putToProperties("MANUAL_ICEBERG_METADATA_LOCATION_CHANGE", "true");
        }
    }

    public void setTableParametersForCTLT(org.apache.hadoop.hive.ql.metadata.Table tbl, CreateTableLikeDesc desc, Map<String, String> origParams) {
        if (IcebergTableUtil.isV2Table(origParams)) {
            tbl.getParameters().put("format-version", "2");
            tbl.getParameters().put("write.delete.mode", MERGE_ON_READ);
            tbl.getParameters().put("write.update.mode", MERGE_ON_READ);
            tbl.getParameters().put("write.merge.mode", MERGE_ON_READ);
        }
        if (!desc.isExternal()) {
            tbl.getParameters().put("TRANSLATED_TO_EXTERNAL", "TRUE");
            desc.setIsExternal(true);
        }
        if (MetaStoreUtils.isIcebergTable(origParams)) {
            tbl.getParameters().put("iceberg.mr.table.schema", origParams.get("iceberg.mr.table.schema"));
            tbl.getParameters().put("iceberg.mr.table.partition.spec", origParams.get("iceberg.mr.table.partition.spec"));
        } else {
            List spec = PartitionTransform.getPartitionTransformSpec((List)tbl.getPartitionKeys());
            SessionStateUtil.addResourceOrThrow((Configuration)this.conf, (String)"partition_transform_spec", (Object)spec);
            tbl.getSd().getCols().addAll(tbl.getPartitionKeys());
            tbl.getTTable().setPartitionKeysIsSet(false);
        }
    }

    public void setTableLocationForCTAS(CreateTableDesc desc, String location) {
        desc.setLocation(location);
    }

    public Map<String, String> getNativeProperties(org.apache.hadoop.hive.ql.metadata.Table table) {
        Table origTable = IcebergTableUtil.getTable(this.conf, table.getTTable());
        HashMap<String, String> props = Maps.newHashMap();
        props.put("iceberg.mr.table.schema", SchemaParser.toJson(origTable.schema()));
        props.put("iceberg.mr.table.partition.spec", PartitionSpecParser.toJson(origTable.spec()));
        return props;
    }

    public boolean shouldOverwrite(org.apache.hadoop.hive.ql.metadata.Table mTable, Context.Operation operation) {
        return IcebergTableUtil.isCopyOnWriteMode(operation, mTable.getParameters()::getOrDefault);
    }

    public void addResourcesForCreateTable(Map<String, String> tblProps, HiveConf hiveConf) {
        String metadataLocation = tblProps.get("metadata_location");
        if (StringUtils.isNotEmpty((CharSequence)metadataLocation)) {
            SessionStateUtil.addResourceOrThrow((Configuration)hiveConf, (String)"metadata_location", (Object)metadataLocation);
        }
    }

    public Boolean hasAppendsOnly(org.apache.hadoop.hive.ql.metadata.Table hmsTable, SnapshotContext since) {
        TableDesc tableDesc = Utilities.getTableDesc((org.apache.hadoop.hive.ql.metadata.Table)hmsTable);
        Table table = IcebergTableUtil.getTable(this.conf, tableDesc.getProperties());
        return this.hasAppendsOnly(table.snapshots(), since);
    }

    @VisibleForTesting
    Boolean hasAppendsOnly(Iterable<Snapshot> snapshots, SnapshotContext since) {
        boolean foundSince = since == null;
        for (Snapshot snapshot : snapshots) {
            if (!foundSince) {
                if (snapshot.snapshotId() != since.getSnapshotId()) continue;
                foundSince = true;
                continue;
            }
            if ("append".equals(snapshot.operation())) continue;
            return false;
        }
        if (foundSince) {
            return true;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> showPartitions(DDLOperationContext context, org.apache.hadoop.hive.ql.metadata.Table hmstbl) throws HiveException {
        HiveConf confs = context.getConf();
        JobConf job = HiveTableUtil.getPartJobConf((Configuration)confs, hmstbl);
        Class formatter = hmstbl.getInputFormatClass();
        try {
            InputFormat inputFormat = FetchOperator.getInputFormatFromCache((Class)formatter, (Configuration)job);
            InputSplit[] splits = inputFormat.getSplits(job, 1);
            try (RecordReader reader = inputFormat.getRecordReader(splits[0], job, Reporter.NULL);){
                List<String> list = this.getPartitions(context, (Configuration)job, (RecordReader<WritableComparable, Writable>)reader, hmstbl);
                return list;
            }
        }
        catch (Exception e) {
            throw new HiveException((Throwable)e, ErrorMsg.GENERIC_ERROR, new String[]{"show partitions for table " + hmstbl.getTableName() + ". " + ErrorMsg.TABLE_NOT_PARTITIONED + " or the table is empty "});
        }
    }

    private List<String> getPartitions(DDLOperationContext context, Configuration job, RecordReader<WritableComparable, Writable> reader, org.apache.hadoop.hive.ql.metadata.Table hmstbl) throws Exception {
        ArrayList<String> parts = Lists.newArrayList();
        Writable value = (Writable)reader.createValue();
        WritableComparable key = (WritableComparable)reader.createKey();
        try (DefaultFetchFormatter fetcher = new DefaultFetchFormatter();){
            fetcher.initialize(job, HiveTableUtil.getSerializationProps());
            org.apache.hadoop.hive.ql.metadata.Table metaDataPartTable = context.getDb().getTable(hmstbl.getDbName(), hmstbl.getTableName(), "partitions", true);
            Deserializer currSerDe = metaDataPartTable.getDeserializer();
            ObjectMapper mapper = new ObjectMapper();
            Table tbl = this.getTable(hmstbl);
            while (reader.next((Object)key, (Object)value)) {
                String[] row = fetcher.convert(currSerDe.deserialize(value), currSerDe.getObjectInspector()).toString().split("\t");
                parts.add(HiveTableUtil.getParseData(row[0], row[1], mapper, tbl.spec().specId()));
            }
        }
        Collections.sort(parts);
        return parts;
    }

    public void validatePartSpec(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec) throws SemanticException {
        Types.NestedField field;
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        if (hmsTable.getSnapshotRef() != null && this.hasUndergonePartitionEvolution(table)) {
            return;
        }
        if (table.spec().isUnpartitioned() && MapUtils.isNotEmpty(partitionSpec)) {
            throw new SemanticException("Writing data into a partition fails when the Iceberg table is unpartitioned.");
        }
        HashMap<String, Types.NestedField> mapOfPartColNamesWithTypes = Maps.newHashMap();
        for (PartitionField partitionField : table.spec().fields()) {
            field = table.schema().findField(partitionField.sourceId());
            mapOfPartColNamesWithTypes.put(field.name(), field);
        }
        for (Map.Entry entry : partitionSpec.entrySet()) {
            field = (Types.NestedField)mapOfPartColNamesWithTypes.get(entry.getKey());
            Objects.requireNonNull(field, String.format("%s is not a partition column", entry.getKey()));
            if (entry.getValue() == null) continue;
            Object partKeyVal = Conversions.fromPartitionString(field.type(), (String)entry.getValue());
            Objects.requireNonNull(partKeyVal, String.format("Partition spec value for column : %s is invalid", field.name()));
        }
    }

    public boolean canUseTruncate(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec) throws SemanticException {
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        if (MapUtils.isEmpty(partitionSpec) || !this.hasUndergonePartitionEvolution(table)) {
            return true;
        }
        if (hmsTable.getSnapshotRef() != null) {
            return false;
        }
        Expression finalExp = this.generateExpressionFromPartitionSpec(table, partitionSpec);
        FindFiles.Builder builder = new FindFiles.Builder(table).withRecordsMatching(finalExp);
        HashSet<DataFile> dataFiles = Sets.newHashSet(builder.collect());
        boolean result = true;
        for (DataFile dataFile : dataFiles) {
            PartitionData partitionData = (PartitionData)dataFile.partition();
            Expression residual = ResidualEvaluator.of(table.spec(), finalExp, false).residualFor(partitionData);
            if (residual.isEquivalentTo(Expressions.alwaysTrue())) continue;
            result = false;
            break;
        }
        boolean isV2Table = IcebergTableUtil.isV2Table(hmsTable.getParameters());
        if (!result && !isV2Table) {
            throw new SemanticException("Truncate conversion to delete is not possible since its not an Iceberg V2 table. Consider converting the table to Iceberg's V2 format specification.");
        }
        return result;
    }

    private boolean hasUndergonePartitionEvolution(Table table) {
        return table.currentSnapshot() != null && table.currentSnapshot().allManifests(table.io()).parallelStream().map(ManifestFile::partitionSpecId).anyMatch(id -> id < table.spec().specId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getPartitionNames(org.apache.hadoop.hive.ql.metadata.Table hmsTable, Map<String, String> partitionSpec) throws SemanticException {
        Table icebergTable = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        PartitionsTable partitionsTable = (PartitionsTable)MetadataTableUtils.createMetadataTableInstance(icebergTable, MetadataTableType.PARTITIONS);
        Expression expression = this.generateExpressionFromPartitionSpec(icebergTable, partitionSpec);
        HashSet partitionList = Sets.newHashSet();
        try (CloseableIterable<FileScanTask> fileScanTasks = partitionsTable.newScan().planFiles();){
            List<String> partPathList;
            fileScanTasks.forEach(task -> partitionList.addAll(Sets.newHashSet(CloseableIterable.transform(task.asDataTask().rows(), row -> {
                StructProjection data = row.get(0, StructProjection.class);
                PartitionSpec pSpec = icebergTable.spec();
                PartitionData partitionData = new PartitionData(pSpec.partitionType());
                for (int index = 0; index < pSpec.fields().size(); ++index) {
                    partitionData.set(index, data.get(index, Object.class));
                }
                return partitionData;
            }))));
            List<String> list = partPathList = partitionList.stream().filter(partitionData -> {
                ResidualEvaluator resEval = ResidualEvaluator.of(icebergTable.spec(), expression, false);
                return resEval.residualFor((StructLike)partitionData).isEquivalentTo(Expressions.alwaysTrue());
            }).map(partitionData -> icebergTable.spec().partitionToPath((StructLike)partitionData)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new SemanticException(String.format("Error while fetching the partitions due to: %s", e));
        }
    }

    private Expression generateExpressionFromPartitionSpec(Table table, Map<String, String> partitionSpec) throws SemanticException {
        Map partitionFieldMap = table.spec().fields().stream().collect(Collectors.toMap(PartitionField::name, Function.identity()));
        Expression finalExp = Expressions.alwaysTrue();
        for (Map.Entry<String, String> entry : partitionSpec.entrySet()) {
            String partColName = entry.getKey();
            if (partitionFieldMap.containsKey(partColName)) {
                PartitionField partitionField = (PartitionField)partitionFieldMap.get(partColName);
                Type resultType = partitionField.transform().getResultType(table.schema().findField(partitionField.sourceId()).type());
                Object value = Conversions.fromPartitionString(resultType, entry.getValue());
                TransformSpec.TransformType transformType = TransformSpec.fromString((String)partitionField.transform().toString());
                Iterable iterable = () -> Collections.singletonList(value).iterator();
                if (TransformSpec.TransformType.IDENTITY == transformType) {
                    UnboundPredicate boundPredicate = Expressions.in(partitionField.name(), iterable);
                    finalExp = Expressions.and(finalExp, boundPredicate);
                    continue;
                }
                throw new SemanticException(String.format("Partition transforms are not supported via truncate operation: %s", partColName));
            }
            throw new SemanticException(String.format("No partition column/transform by the name: %s", partColName));
        }
        return finalExp;
    }

    public ColumnInfo getColumnInfo(org.apache.hadoop.hive.ql.metadata.Table hmsTable, String colName) throws SemanticException {
        Table icebergTbl = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Deserializer deserializer = hmsTable.getDeserializer();
        Types.NestedField field = icebergTbl.schema().findField(colName);
        if (field != null) {
            try {
                ObjectInspector fieldObjInspector = null;
                StructObjectInspector structObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                for (StructField structField : structObjectInspector.getAllStructFieldRefs()) {
                    if (!field.name().equalsIgnoreCase(structField.getFieldName())) continue;
                    fieldObjInspector = structField.getFieldObjectInspector();
                    break;
                }
                if (fieldObjInspector != null) {
                    return new ColumnInfo(field.name(), fieldObjInspector, hmsTable.getTableName(), false);
                }
                throw new SemanticException(String.format("Unable to fetch column type of column %s since we are not able to infer its object inspector.", colName));
            }
            catch (SerDeException e) {
                throw new SemanticException(String.format("Unable to fetch column type of column %s due to: %s", new Object[]{colName, e}));
            }
        }
        throw new SemanticException(String.format("Unable to find a column with the name: %s", colName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canPerformMetadataDelete(org.apache.hadoop.hive.ql.metadata.Table hmsTable, String branchName, SearchArgument sarg) {
        Expression exp;
        try {
            exp = HiveIcebergFilterFactory.generateFilterExpression(sarg);
        }
        catch (UnsupportedOperationException e) {
            LOG.warn("Unable to create Iceberg filter, continuing without metadata delete: ", (Throwable)e);
            return false;
        }
        Table table = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        if (ExpressionUtil.selectsPartitions(exp, table, false)) {
            return true;
        }
        TableScan scan = (TableScan)((TableScan)((TableScan)((TableScan)table.newScan().filter(exp)).caseSensitive(false)).includeColumnStats()).ignoreResiduals();
        if (branchName != null) {
            scan.useRef(HiveUtils.getTableSnapshotRef((String)branchName));
        }
        try (CloseableIterable tasks = scan.planFiles();){
            HashMap evaluators = Maps.newHashMap();
            StrictMetricsEvaluator metricsEvaluator = new StrictMetricsEvaluator(SnapshotUtil.schemaFor(table, branchName), exp);
            boolean bl = Iterables.all(tasks, task -> {
                DataFile file = (DataFile)task.file();
                PartitionSpec spec = task.spec();
                Evaluator evaluator = evaluators.computeIfAbsent(spec.specId(), specId -> new Evaluator(spec.partitionType(), Projections.strict(spec).project(exp)));
                return evaluator.eval(file.partition()) || metricsEvaluator.eval(file);
            });
            return bl;
        }
        catch (IOException ioe) {
            LOG.warn("Failed to close task iterable", (Throwable)ioe);
            return false;
        }
    }

    public List<FieldSchema> getPartitionKeys(org.apache.hadoop.hive.ql.metadata.Table hmsTable) {
        Table icebergTable = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        Schema schema = icebergTable.schema();
        List<FieldSchema> hiveSchema = HiveSchemaUtil.convert(schema);
        Map<String, String> colNameToColType = hiveSchema.stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getType));
        return icebergTable.spec().fields().stream().map(partField -> new FieldSchema(schema.findColumnName(partField.sourceId()), (String)colNameToColType.get(schema.findColumnName(partField.sourceId())), String.format("Transform: %s", partField.transform().toString()))).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Partition> getPartitionsByExpr(org.apache.hadoop.hive.ql.metadata.Table hmsTable, ExprNodeDesc desc) throws SemanticException {
        Table icebergTable = IcebergTableUtil.getTable(this.conf, hmsTable.getTTable());
        PartitionSpec pSpec = icebergTable.spec();
        PartitionsTable partitionsTable = (PartitionsTable)MetadataTableUtils.createMetadataTableInstance(icebergTable, MetadataTableType.PARTITIONS);
        SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)this.conf, (ExprNodeGenericFuncDesc)((ExprNodeGenericFuncDesc)desc));
        Expression expression = HiveIcebergFilterFactory.generateFilterExpression(sarg);
        HashSet partitionList = Sets.newHashSet();
        ResidualEvaluator resEval = ResidualEvaluator.of(pSpec, expression, false);
        try (CloseableIterable<FileScanTask> fileScanTasks = partitionsTable.newScan().planFiles();){
            fileScanTasks.forEach(task -> partitionList.addAll(Sets.newHashSet(CloseableIterable.transform(task.asDataTask().rows(), row -> {
                StructProjection data = row.get(0, StructProjection.class);
                return IcebergTableUtil.toPartitionData(data, pSpec.partitionType());
            })).stream().filter(partitionData -> resEval.residualFor((StructLike)partitionData).isEquivalentTo(Expressions.alwaysTrue())).collect(Collectors.toSet())));
            List<Partition> list = partitionList.stream().map(partitionData -> new DummyPartition(hmsTable, pSpec.partitionToPath((StructLike)partitionData))).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new SemanticException(String.format("Error while fetching the partitions due to: %s", e));
        }
    }

    private static class NonSerializingConfig
    implements Serializable {
        private final transient Configuration conf;

        NonSerializingConfig(Configuration conf) {
            this.conf = conf;
        }

        public Configuration get() {
            if (this.conf == null) {
                throw new IllegalStateException("Configuration was not serialized on purpose but was not set manually either");
            }
            return this.conf;
        }
    }

    static class HiveIcebergNoJobCommitter
    extends HiveIcebergOutputCommitter {
        HiveIcebergNoJobCommitter() {
        }

        @Override
        public void commitJob(JobContext originalContext) {
        }
    }
}

