/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.tez.HashableInputSplit;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.relocated.com.google.common.primitives.Longs;
import org.apache.iceberg.util.SerializationUtil;

public class HiveIcebergSplit
extends FileSplit
implements IcebergSplitContainer,
HashableInputSplit {
    private IcebergSplit innerSplit;
    private String tableLocation;

    public HiveIcebergSplit() {
    }

    HiveIcebergSplit(IcebergSplit split, String tableLocation) {
        this.innerSplit = split;
        this.tableLocation = tableLocation;
    }

    @Override
    public IcebergSplit icebergSplit() {
        return this.innerSplit;
    }

    public long getLength() {
        return this.innerSplit.getLength();
    }

    public String[] getLocations() {
        return this.innerSplit.getLocations();
    }

    public Path getPath() {
        return new Path(this.tableLocation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytesForHash() {
        Collection<FileScanTask> fileScanTasks = this.innerSplit.task().files();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (FileScanTask task : fileScanTasks) {
                baos.write(((DataFile)task.file()).path().toString().getBytes());
                baos.write(Longs.toByteArray(task.start()));
            }
            Object object = baos.toByteArray();
            return object;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Couldn't produce hash input bytes for HiveIcebergSplit: " + this, ioe);
        }
    }

    public long getStart() {
        return 0L;
    }

    public void write(DataOutput out) throws IOException {
        byte[] bytes = SerializationUtil.serializeToBytes(this.tableLocation);
        out.writeInt(bytes.length);
        out.write(bytes);
        this.innerSplit.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        byte[] bytes = new byte[in.readInt()];
        in.readFully(bytes);
        this.tableLocation = (String)SerializationUtil.deserializeFromBytes(bytes);
        this.innerSplit = new IcebergSplit();
        this.innerSplit.readFields(in);
    }
}

