/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobContext;
import org.apache.hadoop.mapred.OutputCommitter;
import org.apache.hadoop.mapred.TaskAttemptContext;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.mr.Catalogs;
import org.apache.iceberg.mr.hive.FilesForCommit;
import org.apache.iceberg.mr.hive.HiveIcebergStorageHandler;
import org.apache.iceberg.mr.hive.TezUtil;
import org.apache.iceberg.mr.hive.writer.HiveIcebergWriter;
import org.apache.iceberg.mr.hive.writer.WriterRegistry;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.relocated.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.iceberg.util.Tasks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergOutputCommitter
extends OutputCommitter {
    private static final String FOR_COMMIT_EXTENSION = ".forCommit";
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergOutputCommitter.class);

    public void setupJob(JobContext jobContext) {
    }

    public void setupTask(TaskAttemptContext taskAttemptContext) {
    }

    public boolean needsTaskCommit(TaskAttemptContext context) {
        return TaskType.REDUCE.equals((Object)context.getTaskAttemptID().getTaskID().getTaskType()) || context.getJobConf().getNumReduceTasks() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTask(TaskAttemptContext originalContext) throws IOException {
        TaskAttemptContext context = TezUtil.enrichContextWithAttemptWrapper(originalContext);
        TaskAttemptID attemptID = context.getTaskAttemptID();
        JobConf jobConf = context.getJobConf();
        Set<String> outputs = HiveIcebergStorageHandler.outputTables((Configuration)context.getJobConf());
        Map writers = Optional.ofNullable(WriterRegistry.writers(attemptID)).orElseGet(() -> {
            LOG.info("CommitTask found no writers for output tables: {}, attemptID: {}", (Object)outputs, (Object)attemptID);
            return ImmutableMap.of();
        });
        ExecutorService tableExecutor = HiveIcebergOutputCommitter.tableExecutor((Configuration)jobConf, outputs.size());
        try {
            Tasks.foreach(outputs).retry(3).stopOnFailure().throwFailureWhenFinished().executeWith(tableExecutor).run(output -> {
                Table table = HiveIcebergStorageHandler.table((Configuration)context.getJobConf(), output);
                if (table != null) {
                    String fileForCommitLocation = HiveIcebergOutputCommitter.generateFileForCommitLocation(table.location(), (Configuration)jobConf, (JobID)attemptID.getJobID(), attemptID.getTaskID().getId());
                    if (writers.get(output) != null) {
                        ArrayList<DataFile> dataFiles = Lists.newArrayList();
                        ArrayList<DeleteFile> deleteFiles = Lists.newArrayList();
                        ArrayList<DataFile> replacedDataFiles = Lists.newArrayList();
                        HashSet<CharSequence> referencedDataFiles = Sets.newHashSet();
                        for (HiveIcebergWriter writer : (List)writers.get(output)) {
                            FilesForCommit files = writer.files();
                            dataFiles.addAll(files.dataFiles());
                            deleteFiles.addAll(files.deleteFiles());
                            replacedDataFiles.addAll(files.replacedDataFiles());
                            referencedDataFiles.addAll(files.referencedDataFiles());
                        }
                        HiveIcebergOutputCommitter.createFileForCommit(new FilesForCommit(dataFiles, deleteFiles, replacedDataFiles, referencedDataFiles), fileForCommitLocation, table.io());
                    } else {
                        LOG.info("CommitTask found no writer for specific table: {}, attemptID: {}", output, (Object)attemptID);
                        HiveIcebergOutputCommitter.createFileForCommit(FilesForCommit.empty(), fileForCommitLocation, table.io());
                    }
                } else {
                    LOG.info("CommitTask found no serialized table in config for table: {}.", output);
                }
            }, IOException.class);
        }
        finally {
            if (tableExecutor != null) {
                tableExecutor.shutdown();
            }
        }
        WriterRegistry.removeWriters(attemptID);
    }

    public void abortTask(TaskAttemptContext originalContext) throws IOException {
        TaskAttemptContext context = TezUtil.enrichContextWithAttemptWrapper(originalContext);
        Map<String, List<HiveIcebergWriter>> writerMap = WriterRegistry.removeWriters(context.getTaskAttemptID());
        if (writerMap != null) {
            for (List<HiveIcebergWriter> writerList : writerMap.values()) {
                for (HiveIcebergWriter writer : writerList) {
                    writer.close(true);
                }
            }
        }
    }

    public void commitJob(JobContext originalContext) throws IOException {
        this.commitJobs(Collections.singletonList(originalContext), Context.Operation.OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitJobs(List<JobContext> originalContextList, Context.Operation operation) throws IOException {
        List<JobContext> jobContextList = originalContextList.stream().map(TezUtil::enrichContextWithVertexId).collect(Collectors.toList());
        List<OutputTable> outputs = this.collectOutputs(jobContextList);
        long startTime = System.currentTimeMillis();
        String ids = jobContextList.stream().map(jobContext -> jobContext.getJobID().toString()).collect(Collectors.joining(","));
        LOG.info("Committing job(s) {} has started", (Object)ids);
        ConcurrentLinkedQueue<String> jobLocations = new ConcurrentLinkedQueue<String>();
        ExecutorService fileExecutor = HiveIcebergOutputCommitter.fileExecutor((Configuration)jobContextList.get(0).getJobConf());
        ExecutorService tableExecutor = HiveIcebergOutputCommitter.tableExecutor((Configuration)jobContextList.get(0).getJobConf(), outputs.size());
        try {
            Tasks.foreach(outputs).throwFailureWhenFinished().stopOnFailure().executeWith(tableExecutor).run(output -> {
                Table table = ((OutputTable)output).table;
                jobLocations.addAll(((OutputTable)output).jobContexts.stream().map(jobContext -> HiveIcebergOutputCommitter.generateJobLocation(table.location(), (Configuration)jobContext.getJobConf(), jobContext.getJobID())).collect(Collectors.toList()));
                this.commitTable(table.io(), fileExecutor, (OutputTable)output, operation);
            });
        }
        finally {
            fileExecutor.shutdown();
            if (tableExecutor != null) {
                tableExecutor.shutdown();
            }
        }
        LOG.info("Commit took {} ms for job(s) {}", (Object)(System.currentTimeMillis() - startTime), (Object)ids);
        for (JobContext jobContext2 : jobContextList) {
            this.cleanup(jobContext2, jobLocations);
        }
    }

    private List<OutputTable> collectOutputs(List<JobContext> jobContextList) {
        return jobContextList.stream().flatMap(jobContext -> HiveIcebergStorageHandler.outputTables((Configuration)jobContext.getJobConf()).stream().map(output -> new OutputTable(HiveIcebergStorageHandler.catalogName((Configuration)jobContext.getJobConf(), output), (String)output, SessionStateUtil.getResource((Configuration)jobContext.getJobConf(), (String)output).filter(o -> o instanceof Table).map(o -> (Table)o).orElseGet(() -> HiveIcebergStorageHandler.table((Configuration)jobContext.getJobConf(), output)))).filter(output -> Objects.nonNull(((OutputTable)output).table)).map(output -> new AbstractMap.SimpleImmutableEntry<OutputTable, JobContext>((OutputTable)output, (JobContext)jobContext))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))).entrySet().stream().map(kv -> {
            ((OutputTable)kv.getKey()).setJobContexts((List)kv.getValue());
            return (OutputTable)kv.getKey();
        }).collect(Collectors.toList());
    }

    public void abortJob(JobContext originalContext, int status) throws IOException {
        this.abortJobs(Collections.singletonList(originalContext));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortJobs(List<JobContext> originalContextList) throws IOException {
        List<JobContext> jobContextList = originalContextList.stream().map(TezUtil::enrichContextWithVertexId).collect(Collectors.toList());
        List<OutputTable> outputs = this.collectOutputs(jobContextList);
        String ids = jobContextList.stream().map(jobContext -> jobContext.getJobID().toString()).collect(Collectors.joining(","));
        LOG.info("Job(s) {} are aborted. Data file cleaning started", (Object)ids);
        ConcurrentLinkedQueue<String> jobLocations = new ConcurrentLinkedQueue<String>();
        ExecutorService fileExecutor = HiveIcebergOutputCommitter.fileExecutor((Configuration)jobContextList.get(0).getJobConf());
        ExecutorService tableExecutor = HiveIcebergOutputCommitter.tableExecutor((Configuration)jobContextList.get(0).getJobConf(), outputs.size());
        try {
            Tasks.foreach(outputs.stream().flatMap(kv -> ((OutputTable)kv).jobContexts.stream().map(jobContext -> new AbstractMap.SimpleImmutableEntry<Table, JobContext>(((OutputTable)kv).table, (JobContext)jobContext)))).suppressFailureWhenFinished().executeWith(tableExecutor).onFailure((output, exc) -> LOG.warn("Failed cleanup table {} on abort job", output, (Object)exc)).run(output -> {
                JobContext jobContext = (JobContext)output.getValue();
                JobConf jobConf = jobContext.getJobConf();
                LOG.info("Cleaning job for jobID: {}, table: {}", (Object)jobContext.getJobID(), output);
                Table table = (Table)output.getKey();
                String jobLocation = HiveIcebergOutputCommitter.generateJobLocation(table.location(), (Configuration)jobConf, jobContext.getJobID());
                jobLocations.add(jobLocation);
                int numTasks = this.listForCommits(jobConf, jobLocation).size();
                FilesForCommit results = HiveIcebergOutputCommitter.collectResults(numTasks, fileExecutor, table.location(), jobContext, table.io(), false);
                Tasks.foreach(results.allFiles()).retry(3).suppressFailureWhenFinished().executeWith(fileExecutor).onFailure((file, exc) -> LOG.warn("Failed to remove data file {} on abort job", (Object)file.path(), (Object)exc)).run(file -> table.io().deleteFile(file.path().toString()));
            }, IOException.class);
        }
        finally {
            fileExecutor.shutdown();
            if (tableExecutor != null) {
                tableExecutor.shutdown();
            }
        }
        LOG.info("Job(s) {} are aborted. Data file cleaning finished", (Object)ids);
        for (JobContext jobContext2 : jobContextList) {
            this.cleanup(jobContext2, jobLocations);
        }
    }

    private Set<FileStatus> listForCommits(JobConf jobConf, String jobLocation) throws IOException {
        Path path = new Path(jobLocation);
        LOG.debug("Listing job location to get forCommits for abort: {}", (Object)jobLocation);
        Object[] children = path.getFileSystem((Configuration)jobConf).listStatus(path);
        LOG.debug("Listing the job location: {} yielded these files: {}", (Object)jobLocation, (Object)Arrays.toString(children));
        return Arrays.stream(children).filter(child -> !child.isDirectory() && child.getPath().getName().endsWith(FOR_COMMIT_EXTENSION)).collect(Collectors.toSet());
    }

    private void commitTable(FileIO io, ExecutorService executor, OutputTable outputTable, Context.Operation operation) {
        String name = outputTable.tableName;
        Properties catalogProperties = new Properties();
        catalogProperties.put("name", name);
        catalogProperties.put("location", outputTable.table.location());
        if (outputTable.catalogName != null) {
            catalogProperties.put("iceberg.catalog", outputTable.catalogName);
        }
        ArrayList<DataFile> dataFiles = Lists.newArrayList();
        ArrayList<DeleteFile> deleteFiles = Lists.newArrayList();
        ArrayList<DataFile> replacedDataFiles = Lists.newArrayList();
        HashSet<CharSequence> referencedDataFiles = Sets.newHashSet();
        Table table = null;
        String branchName = null;
        Expression filterExpr = Expressions.alwaysTrue();
        for (JobContext jobContext : outputTable.jobContexts) {
            JobConf conf = jobContext.getJobConf();
            table = Optional.ofNullable(table).orElse(Catalogs.loadTable((Configuration)conf, catalogProperties));
            branchName = conf.get("iceberg.mr.output.table.snapshot.ref");
            Expression jobContextFilterExpr = SessionStateUtil.getResource((Configuration)conf, (String)"iceberg.query.filters").orElse(Expressions.alwaysTrue());
            if (!filterExpr.equals(jobContextFilterExpr)) {
                filterExpr = Expressions.and(filterExpr, jobContextFilterExpr);
            }
            LOG.debug("Filter Expression :{}", (Object)filterExpr);
            LOG.info("Committing job has started for table: {}, using location: {}", (Object)table, (Object)HiveIcebergOutputCommitter.generateJobLocation(outputTable.table.location(), (Configuration)conf, jobContext.getJobID()));
            int numTasks = SessionStateUtil.getCommitInfo((Configuration)conf, (String)name).map(info -> (SessionStateUtil.CommitInfo)info.get(jobContext.getJobID().toString())).map(SessionStateUtil.CommitInfo::getTaskNum).orElseGet(() -> {
                LOG.info("Number of tasks not available in session state for jobID: {}, table: {}. Falling back to jobConf numReduceTasks/numMapTasks", (Object)jobContext.getJobID(), (Object)name);
                return conf.getNumReduceTasks() > 0 ? conf.getNumReduceTasks() : conf.getNumMapTasks();
            });
            FilesForCommit writeResults = HiveIcebergOutputCommitter.collectResults(numTasks, executor, outputTable.table.location(), jobContext, io, true);
            dataFiles.addAll(writeResults.dataFiles());
            deleteFiles.addAll(writeResults.deleteFiles());
            replacedDataFiles.addAll(writeResults.replacedDataFiles());
            referencedDataFiles.addAll(writeResults.referencedDataFiles());
        }
        FilesForCommit filesForCommit = new FilesForCommit(dataFiles, deleteFiles, replacedDataFiles, referencedDataFiles);
        long startTime = System.currentTimeMillis();
        if (Context.Operation.IOW != operation) {
            if (filesForCommit.isEmpty()) {
                LOG.info("Not creating a new commit for table: {}, jobIDs: {}, since there were no new files to add", (Object)table, (Object)outputTable.jobContexts.stream().map(org.apache.hadoop.mapreduce.JobContext::getJobID).map(String::valueOf).collect(Collectors.joining(",")));
            } else {
                Long snapshotId = this.getSnapshotId(outputTable.table, branchName);
                this.commitWrite(table, branchName, snapshotId, startTime, filesForCommit, operation, filterExpr);
            }
        } else {
            Context.RewritePolicy rewritePolicy = Context.RewritePolicy.fromString((String)outputTable.jobContexts.stream().findAny().map(x -> x.getJobConf().get(HiveConf.ConfVars.REWRITE_POLICY.varname)).orElse(Context.RewritePolicy.DEFAULT.name()));
            this.commitOverwrite(table, branchName, startTime, filesForCommit, rewritePolicy);
        }
    }

    private Long getSnapshotId(Table table, String branchName) {
        Optional<Long> snapshotId = Optional.ofNullable(table.currentSnapshot()).map(Snapshot::snapshotId);
        if (StringUtils.isNotEmpty((CharSequence)branchName)) {
            String ref = HiveUtils.getTableSnapshotRef((String)branchName);
            snapshotId = Optional.ofNullable(table.refs().get(ref)).map(SnapshotRef::snapshotId);
        }
        return snapshotId.orElse(null);
    }

    private void commitWrite(Table table, String branchName, Long snapshotId, long startTime, FilesForCommit results, Context.Operation operation, Expression filterExpr) {
        if (!results.replacedDataFiles().isEmpty()) {
            OverwriteFiles write = table.newOverwrite();
            results.replacedDataFiles().forEach(write::deleteFile);
            results.dataFiles().forEach(write::addFile);
            if (StringUtils.isNotEmpty((CharSequence)branchName)) {
                write.toBranch(HiveUtils.getTableSnapshotRef((String)branchName));
            }
            if (snapshotId != null) {
                write.validateFromSnapshot(snapshotId);
            }
            write.conflictDetectionFilter(filterExpr);
            write.validateNoConflictingData();
            write.validateNoConflictingDeletes();
            write.commit();
            return;
        }
        if (results.deleteFiles().isEmpty() && Context.Operation.MERGE != operation) {
            AppendFiles write = table.newAppend();
            results.dataFiles().forEach(write::appendFile);
            if (StringUtils.isNotEmpty((CharSequence)branchName)) {
                write.toBranch(HiveUtils.getTableSnapshotRef((String)branchName));
            }
            write.commit();
        } else {
            RowDelta write = table.newRowDelta();
            results.dataFiles().forEach(write::addRows);
            results.deleteFiles().forEach(write::addDeletes);
            if (StringUtils.isNotEmpty((CharSequence)branchName)) {
                write.toBranch(HiveUtils.getTableSnapshotRef((String)branchName));
            }
            if (snapshotId != null) {
                write.validateFromSnapshot(snapshotId);
            }
            write.conflictDetectionFilter(filterExpr);
            if (!results.dataFiles().isEmpty()) {
                write.validateDeletedFiles();
                write.validateNoConflictingDeleteFiles();
            }
            write.validateDataFilesExist(results.referencedDataFiles());
            write.validateNoConflictingDataFiles();
            write.commit();
        }
        LOG.info("Write commit took {} ms for table: {} with {} data and {} delete file(s)", new Object[]{System.currentTimeMillis() - startTime, table, results.dataFiles().size(), results.deleteFiles().size()});
        LOG.debug("Added files {}", (Object)results);
    }

    private void commitOverwrite(Table table, String branchName, long startTime, FilesForCommit results, Context.RewritePolicy rewritePolicy) {
        Preconditions.checkArgument(results.deleteFiles().isEmpty(), "Can not handle deletes with overwrite");
        if (!results.dataFiles().isEmpty()) {
            Transaction transaction = table.newTransaction();
            if (rewritePolicy == Context.RewritePolicy.ALL_PARTITIONS) {
                DeleteFiles delete = transaction.newDelete();
                delete.deleteFromRowFilter(Expressions.alwaysTrue());
                delete.commit();
            }
            ReplacePartitions overwrite = transaction.newReplacePartitions();
            results.dataFiles().forEach(overwrite::addFile);
            if (StringUtils.isNotEmpty((CharSequence)branchName)) {
                overwrite.toBranch(HiveUtils.getTableSnapshotRef((String)branchName));
            }
            overwrite.commit();
            transaction.commitTransaction();
            LOG.info("Overwrite commit took {} ms for table: {} with {} file(s)", new Object[]{System.currentTimeMillis() - startTime, table, results.dataFiles().size()});
        } else if (table.spec().isUnpartitioned()) {
            DeleteFiles deleteFiles = table.newDelete();
            deleteFiles.deleteFromRowFilter(Expressions.alwaysTrue());
            if (StringUtils.isNotEmpty((CharSequence)branchName)) {
                deleteFiles.toBranch(HiveUtils.getTableSnapshotRef((String)branchName));
            }
            deleteFiles.commit();
            LOG.info("Cleared table contents as part of empty overwrite for unpartitioned table. Commit took {} ms for table: {}", (Object)(System.currentTimeMillis() - startTime), (Object)table);
        }
        LOG.debug("Overwrote partitions with files {}", (Object)results);
    }

    private void cleanup(JobContext jobContext, Collection<String> jobLocations) throws IOException {
        JobConf jobConf = jobContext.getJobConf();
        LOG.info("Cleaning for job {} started", (Object)jobContext.getJobID());
        Tasks.foreach(jobLocations).retry(3).suppressFailureWhenFinished().onFailure((jobLocation, exc) -> LOG.debug("Failed to remove directory {} on job cleanup", jobLocation, (Object)exc)).run(jobLocation -> {
            LOG.info("Cleaning location: {}", jobLocation);
            Path toDelete = new Path(jobLocation);
            FileSystem fs = Util.getFs(toDelete, (Configuration)jobConf);
            fs.delete(toDelete, true);
        }, IOException.class);
        LOG.info("Cleaning for job {} finished", (Object)jobContext.getJobID());
    }

    private static ExecutorService fileExecutor(Configuration conf) {
        int size = conf.getInt("iceberg.mr.commit.file.thread.pool.size", 10);
        return Executors.newFixedThreadPool(size, new ThreadFactoryBuilder().setDaemon(true).setPriority(5).setNameFormat("iceberg-commit-file-pool-%d").build());
    }

    private static ExecutorService tableExecutor(Configuration conf, int maxThreadNum) {
        int size = conf.getInt("iceberg.mr.commit.table.thread.pool.size", 10);
        if ((size = Math.min(maxThreadNum, size)) > 1) {
            return Executors.newFixedThreadPool(size, new ThreadFactoryBuilder().setDaemon(true).setPriority(5).setNameFormat("iceberg-commit-table-pool-%d").build());
        }
        return null;
    }

    private static FilesForCommit collectResults(int numTasks, ExecutorService executor, String location, JobContext jobContext, FileIO io, boolean throwOnFailure) {
        JobConf conf = jobContext.getJobConf();
        ConcurrentLinkedQueue<DataFile> dataFiles = new ConcurrentLinkedQueue<DataFile>();
        ConcurrentLinkedQueue<DeleteFile> deleteFiles = new ConcurrentLinkedQueue<DeleteFile>();
        ConcurrentLinkedQueue<DataFile> replacedDataFiles = new ConcurrentLinkedQueue<DataFile>();
        ConcurrentLinkedQueue<CharSequence> referencedDataFiles = new ConcurrentLinkedQueue<CharSequence>();
        Tasks.range(numTasks).throwFailureWhenFinished(throwOnFailure).executeWith(executor).retry(3).run(taskId -> {
            String taskFileName = HiveIcebergOutputCommitter.generateFileForCommitLocation(location, (Configuration)conf, jobContext.getJobID(), taskId);
            FilesForCommit files = HiveIcebergOutputCommitter.readFileForCommit(taskFileName, io);
            dataFiles.addAll(files.dataFiles());
            deleteFiles.addAll(files.deleteFiles());
            replacedDataFiles.addAll(files.replacedDataFiles());
            referencedDataFiles.addAll(files.referencedDataFiles());
        });
        return new FilesForCommit(dataFiles, deleteFiles, replacedDataFiles, referencedDataFiles);
    }

    @VisibleForTesting
    static String generateJobLocation(String location, Configuration conf, JobID jobId) {
        String queryId = conf.get(HiveConf.ConfVars.HIVE_QUERY_ID.varname);
        return location + "/temp/" + queryId + "-" + jobId;
    }

    private static String generateFileForCommitLocation(String location, Configuration conf, JobID jobId, int taskId) {
        return HiveIcebergOutputCommitter.generateJobLocation(location, conf, jobId) + "/task-" + taskId + FOR_COMMIT_EXTENSION;
    }

    private static void createFileForCommit(FilesForCommit writeResult, String location, FileIO io) throws IOException {
        OutputFile fileForCommit = io.newOutputFile(location);
        try (ObjectOutputStream oos = new ObjectOutputStream(fileForCommit.createOrOverwrite());){
            oos.writeObject(writeResult);
        }
        LOG.debug("Iceberg committed file is created {}", (Object)fileForCommit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FilesForCommit readFileForCommit(String fileForCommitLocation, FileIO io) {
        try (ObjectInputStream ois = new ObjectInputStream(io.newInputFile(fileForCommitLocation).newStream());){
            FilesForCommit filesForCommit = (FilesForCommit)ois.readObject();
            return filesForCommit;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new NotFoundException("Can not read or parse committed file: %s", fileForCommitLocation);
        }
    }

    private static class OutputTable {
        private final String catalogName;
        private final String tableName;
        private final Table table;
        private List<JobContext> jobContexts;

        private OutputTable(String catalogName, String tableName, Table table) {
            this.catalogName = catalogName;
            this.tableName = tableName;
            this.table = table;
        }

        public void setJobContexts(List<JobContext> jobContexts) {
            this.jobContexts = ImmutableList.copyOf(jobContexts);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutputTable output1 = (OutputTable)o;
            return Objects.equals(this.tableName, output1.tableName);
        }

        public int hashCode() {
            return Objects.hash(this.tableName);
        }
    }
}

