/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.io.DataCache;
import org.apache.hadoop.hive.common.io.FileMetadataCache;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedSupport;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.LlapCacheOnlyInputFormatInterface;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.mr.InputFormatConfig;
import org.apache.iceberg.mr.hive.HiveIcebergFilterFactory;
import org.apache.iceberg.mr.hive.HiveIcebergSplit;
import org.apache.iceberg.mr.mapred.AbstractMapredIcebergRecordReader;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.mr.mapred.MapredIcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergInputFormat;
import org.apache.iceberg.mr.mapreduce.IcebergSplit;
import org.apache.iceberg.mr.mapreduce.IcebergSplitContainer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.SerializationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveIcebergInputFormat
extends MapredIcebergInputFormat<Record>
implements CombineHiveInputFormat.AvoidSplitCombination,
VectorizedInputFormatInterface,
LlapCacheOnlyInputFormatInterface.VectorizedOnly {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergInputFormat.class);
    private static final String HIVE_VECTORIZED_RECORDREADER_CLASS = "org.apache.iceberg.mr.hive.vector.HiveIcebergVectorizedRecordReader";
    private static final DynConstructors.Ctor<AbstractMapredIcebergRecordReader> HIVE_VECTORIZED_RECORDREADER_CTOR = HiveVersion.min(HiveVersion.HIVE_3) ? DynConstructors.builder(AbstractMapredIcebergRecordReader.class).impl("org.apache.iceberg.mr.hive.vector.HiveIcebergVectorizedRecordReader", IcebergInputFormat.class, IcebergSplit.class, JobConf.class, Reporter.class).build() : null;
    public static final String ICEBERG_DISABLE_VECTORIZATION_PREFIX = "iceberg.disable.vectorization.";

    static Expression icebergDataFilterFromHiveConf(Configuration conf) {
        Expression icebergFilter = (Expression)SerializationUtil.deserializeFromBase64(conf.get("iceberg.mr.filter.expression"));
        if (icebergFilter != null) {
            return icebergFilter;
        }
        String hiveFilter = conf.get("hive.io.filter.expr.serialized");
        if (hiveFilter != null) {
            ExprNodeGenericFuncDesc exprNodeDesc = (ExprNodeGenericFuncDesc)SerializationUtilities.deserializeObject((String)hiveFilter, ExprNodeGenericFuncDesc.class);
            return HiveIcebergInputFormat.getFilterExpr(conf, exprNodeDesc);
        }
        return null;
    }

    static Expression getFilterExpr(Configuration conf, ExprNodeGenericFuncDesc exprNodeDesc) {
        if (exprNodeDesc != null) {
            SearchArgument sarg = ConvertAstToSearchArg.create((Configuration)conf, (ExprNodeGenericFuncDesc)exprNodeDesc);
            try {
                return HiveIcebergFilterFactory.generateFilterExpression(sarg);
            }
            catch (UnsupportedOperationException e) {
                LOG.warn("Unable to create Iceberg filter, continuing without filter (will be applied by Hive later): ", (Throwable)e);
            }
        }
        return null;
    }

    public static Expression residualForTask(FileScanTask task, Configuration conf) {
        Expression dataFilter = HiveIcebergInputFormat.icebergDataFilterFromHiveConf(conf);
        if (dataFilter == null) {
            return Expressions.alwaysTrue();
        }
        return ResidualEvaluator.of(task.spec(), dataFilter, conf.getBoolean("iceberg.mr.case.sensitive", true)).residualFor(((DataFile)task.file()).partition());
    }

    @Override
    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        Expression filter = HiveIcebergInputFormat.icebergDataFilterFromHiveConf((Configuration)job);
        if (filter != null) {
            job.set("iceberg.mr.filter.expression", SerializationUtil.serializeToBase64(filter));
        }
        job.set("iceberg.mr.selected.columns", job.get("hive.io.file.readcolumn.names", ""));
        job.setBoolean("iceberg.mr.fetch.virtual.columns", job.getBoolean("hive.io.file.fetch.virtual.columns", false));
        job.set("iceberg.mr.as.of.time", job.get("hive.io.as.of.timestamp", "-1"));
        job.set("iceberg.mr.snapshot.id", job.get("hive.io.as.of.version", "-1"));
        job.set("iceberg.mr.snapshot.id.interval.from", job.get("hive.io.version.from", "-1"));
        job.set("iceberg.mr.output.table.snapshot.ref", job.get("hive.io.snapshot.ref", ""));
        String location = job.get("iceberg.mr.table.location");
        return (InputSplit[])Arrays.stream(super.getSplits(job, numSplits)).map(split -> new HiveIcebergSplit((IcebergSplit)split, location)).toArray(InputSplit[]::new);
    }

    @Override
    public RecordReader<Void, Container<Record>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        job.set("iceberg.mr.selected.columns", job.get("hive.io.file.readcolumn.names", ""));
        job.setBoolean("iceberg.mr.fetch.virtual.columns", job.getBoolean("hive.io.file.fetch.virtual.columns", false));
        if (HiveConf.getBoolVar((Configuration)job, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED) && Utilities.getIsVectorized((Configuration)job)) {
            Preconditions.checkArgument(HiveVersion.min(HiveVersion.HIVE_3), "Vectorization only supported for Hive 3+");
            job.setEnum("iceberg.mr.in.memory.data.model", (Enum)InputFormatConfig.InMemoryDataModel.HIVE);
            job.setBoolean("skip.residual.filtering", true);
            IcebergSplit icebergSplit = ((IcebergSplitContainer)split).icebergSplit();
            return HIVE_VECTORIZED_RECORDREADER_CTOR.newInstance(new Object[]{new IcebergInputFormat(), icebergSplit, job, reporter});
        }
        return super.getRecordReader(split, job, reporter);
    }

    public boolean shouldSkipCombine(Path path, Configuration conf) {
        return true;
    }

    public VectorizedSupport.Support[] getSupportedFeatures() {
        throw new UnsupportedOperationException("This overload of getSupportedFeatures should never be called");
    }

    public VectorizedSupport.Support[] getSupportedFeatures(HiveConf hiveConf, TableDesc tableDesc) {
        boolean isORCOnly;
        boolean bl = isORCOnly = Boolean.parseBoolean(tableDesc.getProperties().getProperty("iceberg.decimal64.vectorization")) && Boolean.parseBoolean(tableDesc.getProperties().getProperty("iceberg.orc.files.only")) && FileFormat.ORC.name().equalsIgnoreCase(tableDesc.getProperties().getProperty("write.format.default"));
        if (!isORCOnly) {
            String vectorizationConfName = HiveIcebergInputFormat.getVectorizationConfName(tableDesc.getTableName());
            LOG.debug("Setting {} for table: {} to true", (Object)vectorizationConfName, (Object)tableDesc.getTableName());
            hiveConf.set(vectorizationConfName, "true");
            return new VectorizedSupport.Support[0];
        }
        return new VectorizedSupport.Support[]{VectorizedSupport.Support.DECIMAL_64};
    }

    public void injectCaches(FileMetadataCache metadataCache, DataCache dataCache, Configuration cacheConf) {
    }

    public static String getVectorizationConfName(String tableName) {
        String dbAndTableName = TableName.fromString((String)tableName, null, null).getNotEmptyDbTable();
        return ICEBERG_DISABLE_VECTORIZATION_PREFIX + dbAndTableName;
    }
}

