/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.hive.HiveSchemaConverter;
import org.apache.iceberg.hive.HiveVersion;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.Pair;

public final class HiveSchemaUtil {
    private HiveSchemaUtil() {
    }

    public static List<FieldSchema> convert(Schema schema) {
        return schema.columns().stream().map(col -> new FieldSchema(col.name(), HiveSchemaUtil.convertToTypeString(col.type()), col.doc())).collect(Collectors.toList());
    }

    public static Schema convert(List<FieldSchema> fieldSchemas) {
        return HiveSchemaUtil.convert(fieldSchemas, false);
    }

    public static Schema convert(List<FieldSchema> fieldSchemas, boolean autoConvert) {
        ArrayList<String> names = Lists.newArrayListWithExpectedSize(fieldSchemas.size());
        ArrayList<TypeInfo> typeInfos = Lists.newArrayListWithExpectedSize(fieldSchemas.size());
        ArrayList<String> comments = Lists.newArrayListWithExpectedSize(fieldSchemas.size());
        for (FieldSchema col : fieldSchemas) {
            names.add(col.getName().toLowerCase());
            typeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString((String)col.getType()));
            comments.add(col.getComment());
        }
        return HiveSchemaConverter.convert(names, typeInfos, comments, autoConvert);
    }

    public static PartitionSpec spec(Schema schema, List<FieldSchema> fieldSchemas) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor(schema);
        fieldSchemas.forEach(fieldSchema -> builder.identity(fieldSchema.getName().toLowerCase()));
        return builder.build();
    }

    public static Schema convert(List<String> names, List<TypeInfo> types, List<String> comments) {
        return HiveSchemaConverter.convert(names, types, comments, false);
    }

    public static Schema convert(List<String> names, List<TypeInfo> types, List<String> comments, boolean autoConvert) {
        return HiveSchemaConverter.convert(names, types, comments, autoConvert);
    }

    public static TypeInfo convert(Type type) {
        return TypeInfoUtils.getTypeInfoFromTypeString((String)HiveSchemaUtil.convertToTypeString(type));
    }

    public static Type convert(TypeInfo typeInfo) {
        return HiveSchemaConverter.convert(typeInfo, false);
    }

    public static SchemaDifference getSchemaDiff(Collection<FieldSchema> minuendCollection, Collection<FieldSchema> subtrahendCollection, boolean bothDirections) {
        SchemaDifference difference = new SchemaDifference();
        for (FieldSchema first : minuendCollection) {
            boolean found = false;
            for (FieldSchema second : subtrahendCollection) {
                if (!Objects.equals(first.getName(), second.getName())) continue;
                found = true;
                if (!Objects.equals(first.getType(), second.getType())) {
                    difference.addTypeChanged(first);
                }
                if (Objects.equals(first.getComment(), second.getComment())) continue;
                difference.addCommentChanged(first);
            }
            if (found) continue;
            difference.addMissingFromSecond(first);
        }
        if (bothDirections) {
            SchemaDifference otherWay = HiveSchemaUtil.getSchemaDiff(subtrahendCollection, minuendCollection, false);
            otherWay.getMissingFromSecond().forEach(difference::addMissingFromFirst);
        }
        return difference;
    }

    public static Pair<String, Optional<String>> getReorderedColumn(List<FieldSchema> updated, List<FieldSchema> old, Map<String, String> renameMapping) {
        HashMap<String, Integer> nameToNewIndex = Maps.newHashMap();
        for (int i = 0; i < updated.size(); ++i) {
            String updatedCol = renameMapping.getOrDefault(updated.get(i).getName(), updated.get(i).getName());
            nameToNewIndex.put(updatedCol, i);
        }
        String reorderedColName = null;
        int maxIndexDiff = 0;
        for (int oldIndex = 0; oldIndex < old.size(); ++oldIndex) {
            int indexDiff;
            String oldName = old.get(oldIndex).getName();
            Integer newIndex = (Integer)nameToNewIndex.get(oldName);
            if (newIndex == null || maxIndexDiff >= (indexDiff = Math.abs(newIndex - oldIndex))) continue;
            maxIndexDiff = indexDiff;
            reorderedColName = oldName;
        }
        if (maxIndexDiff == 0) {
            return null;
        }
        int newIndex = (Integer)nameToNewIndex.get(reorderedColName);
        if (newIndex > 0) {
            String previousColName = renameMapping.getOrDefault(updated.get(newIndex - 1).getName(), updated.get(newIndex - 1).getName());
            return Pair.of(reorderedColName, Optional.of(previousColName));
        }
        return Pair.of(reorderedColName, Optional.empty());
    }

    private static String convertToTypeString(Type type) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return "boolean";
            }
            case INTEGER: {
                return "int";
            }
            case LONG: {
                return "bigint";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case DATE: {
                return "date";
            }
            case TIME: 
            case STRING: 
            case UUID: {
                return "string";
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)type;
                if (HiveVersion.min(HiveVersion.HIVE_3) && timestampType.shouldAdjustToUTC()) {
                    return "timestamp with local time zone";
                }
                return "timestamp";
            }
            case FIXED: 
            case BINARY: {
                return "binary";
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)type;
                return String.format("decimal(%s,%s)", decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                Types.StructType structType = type.asStructType();
                String nameToType = structType.fields().stream().map(f -> String.format("%s:%s", f.name(), HiveSchemaUtil.convert(f.type()))).collect(Collectors.joining(","));
                return String.format("struct<%s>", nameToType);
            }
            case LIST: {
                Types.ListType listType = type.asListType();
                return String.format("array<%s>", HiveSchemaUtil.convert(listType.elementType()));
            }
            case MAP: {
                Types.MapType mapType = type.asMapType();
                return String.format("map<%s,%s>", HiveSchemaUtil.convert(mapType.keyType()), HiveSchemaUtil.convert(mapType.valueType()));
            }
        }
        throw new UnsupportedOperationException(type + " is not supported");
    }

    public static class SchemaDifference {
        private final List<FieldSchema> missingFromFirst = Lists.newArrayList();
        private final List<FieldSchema> missingFromSecond = Lists.newArrayList();
        private final List<FieldSchema> typeChanged = Lists.newArrayList();
        private final List<FieldSchema> commentChanged = Lists.newArrayList();

        public List<FieldSchema> getMissingFromFirst() {
            return this.missingFromFirst;
        }

        public List<FieldSchema> getMissingFromSecond() {
            return this.missingFromSecond;
        }

        public List<FieldSchema> getTypeChanged() {
            return this.typeChanged;
        }

        public List<FieldSchema> getCommentChanged() {
            return this.commentChanged;
        }

        public boolean isEmpty() {
            return this.missingFromFirst.isEmpty() && this.missingFromSecond.isEmpty() && this.typeChanged.isEmpty() && this.commentChanged.isEmpty();
        }

        void addMissingFromFirst(FieldSchema field) {
            this.missingFromFirst.add(field);
        }

        void addMissingFromSecond(FieldSchema field) {
            this.missingFromSecond.add(field);
        }

        void addTypeChanged(FieldSchema field) {
            this.typeChanged.add(field);
        }

        void addCommentChanged(FieldSchema field) {
            this.commentChanged.add(field);
        }
    }
}

