/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.ResolvingFileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    public static final String VERSION_HINT_FILENAME = "version-hint.text";
    private static final Set<String> LOCALITY_WHITELIST_FS = ImmutableSet.of("hdfs");
    private static final Logger LOG = LoggerFactory.getLogger(Util.class);

    private Util() {
    }

    public static FileSystem getFs(Path path, Configuration conf) {
        try {
            return path.getFileSystem(conf);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to get file system for path: %s", path);
        }
    }

    public static String[] blockLocations(CombinedScanTask task, Configuration conf) {
        HashSet<String> locationSets = Sets.newHashSet();
        for (FileScanTask f : task.files()) {
            Path path = new Path(((DataFile)f.file()).path().toString());
            try {
                FileSystem fs = path.getFileSystem(conf);
                for (BlockLocation b : fs.getFileBlockLocations(path, f.start(), f.length())) {
                    locationSets.addAll(Arrays.asList(b.getHosts()));
                }
            }
            catch (IOException ioe) {
                LOG.warn("Failed to get block locations for path {}", (Object)path, (Object)ioe);
            }
        }
        return locationSets.toArray(new String[0]);
    }

    public static String[] blockLocations(FileIO io, ScanTaskGroup<?> taskGroup) {
        HashSet locations = Sets.newHashSet();
        for (ScanTask task : taskGroup.tasks()) {
            if (!(task instanceof ContentScanTask)) continue;
            Collections.addAll(locations, Util.blockLocations(io, (ContentScanTask)task));
        }
        return locations.toArray(HadoopInputFile.NO_LOCATION_PREFERENCE);
    }

    public static boolean mayHaveBlockLocations(FileIO io, String location) {
        if (Util.usesHadoopFileIO(io, location)) {
            InputFile inputFile = io.newInputFile(location);
            if (inputFile instanceof HadoopInputFile) {
                String scheme = ((HadoopInputFile)inputFile).getFileSystem().getScheme();
                return LOCALITY_WHITELIST_FS.contains(scheme);
            }
            return false;
        }
        return false;
    }

    private static String[] blockLocations(FileIO io, ContentScanTask<?> task) {
        String location = task.file().path().toString();
        if (Util.usesHadoopFileIO(io, location)) {
            InputFile inputFile = io.newInputFile(location);
            if (inputFile instanceof HadoopInputFile) {
                return ((HadoopInputFile)inputFile).getBlockLocations(task.start(), task.length());
            }
            return HadoopInputFile.NO_LOCATION_PREFERENCE;
        }
        return HadoopInputFile.NO_LOCATION_PREFERENCE;
    }

    private static boolean usesHadoopFileIO(FileIO io, String location) {
        if (io instanceof HadoopFileIO) {
            return true;
        }
        if (io instanceof ResolvingFileIO) {
            ResolvingFileIO resolvingFileIO = (ResolvingFileIO)io;
            return HadoopFileIO.class.isAssignableFrom(resolvingFileIO.ioClass(location));
        }
        return false;
    }

    public static String uriToString(URI uri) {
        return new Path(uri).toString();
    }
}

