/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.expressions;

import java.io.Serializable;
import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public interface Expression
extends Serializable {
    public Operation op();

    default public Expression negate() {
        throw new UnsupportedOperationException(String.format("%s cannot be negated", this));
    }

    default public boolean isEquivalentTo(Expression other) {
        return false;
    }

    public static enum Operation {
        TRUE,
        FALSE,
        IS_NULL,
        NOT_NULL,
        IS_NAN,
        NOT_NAN,
        LT,
        LT_EQ,
        GT,
        GT_EQ,
        EQ,
        NOT_EQ,
        IN,
        NOT_IN,
        NOT,
        AND,
        OR,
        STARTS_WITH,
        NOT_STARTS_WITH,
        COUNT,
        COUNT_STAR,
        MAX,
        MIN;


        public static Operation fromString(String operationType) {
            Preconditions.checkArgument(null != operationType, "Invalid operation type: null");
            try {
                return Operation.valueOf(operationType.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid operation type: %s", operationType), e);
            }
        }

        public Operation negate() {
            switch (this) {
                case IS_NULL: {
                    return NOT_NULL;
                }
                case NOT_NULL: {
                    return IS_NULL;
                }
                case IS_NAN: {
                    return NOT_NAN;
                }
                case NOT_NAN: {
                    return IS_NAN;
                }
                case LT: {
                    return GT_EQ;
                }
                case LT_EQ: {
                    return GT;
                }
                case GT: {
                    return LT_EQ;
                }
                case GT_EQ: {
                    return LT;
                }
                case EQ: {
                    return NOT_EQ;
                }
                case NOT_EQ: {
                    return EQ;
                }
                case IN: {
                    return NOT_IN;
                }
                case NOT_IN: {
                    return IN;
                }
                case STARTS_WITH: {
                    return NOT_STARTS_WITH;
                }
                case NOT_STARTS_WITH: {
                    return STARTS_WITH;
                }
            }
            throw new IllegalArgumentException("No negation for operation: " + (Object)((Object)this));
        }

        public Operation flipLR() {
            switch (this) {
                case LT: {
                    return GT;
                }
                case LT_EQ: {
                    return GT_EQ;
                }
                case GT: {
                    return LT;
                }
                case GT_EQ: {
                    return LT_EQ;
                }
                case EQ: {
                    return EQ;
                }
                case NOT_EQ: {
                    return NOT_EQ;
                }
                case AND: {
                    return AND;
                }
                case OR: {
                    return OR;
                }
            }
            throw new IllegalArgumentException("No left-right flip for operation: " + (Object)((Object)this));
        }
    }
}

