/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.generic.GenericData;
import org.apache.hive.iceberg.org.apache.avro.generic.IndexedRecord;
import org.apache.hive.iceberg.org.apache.avro.io.Decoder;
import org.apache.hive.iceberg.org.apache.avro.io.ResolvingDecoder;
import org.apache.hive.iceberg.org.apache.avro.util.Utf8;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.avro.ValueReader;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.UUIDUtil;

public class ValueReaders {
    private ValueReaders() {
    }

    public static ValueReader<Object> nulls() {
        return NullReader.INSTANCE;
    }

    public static ValueReader<Boolean> booleans() {
        return BooleanReader.INSTANCE;
    }

    public static ValueReader<Integer> ints() {
        return IntegerReader.INSTANCE;
    }

    public static ValueReader<Long> longs() {
        return LongReader.INSTANCE;
    }

    public static ValueReader<Float> floats() {
        return FloatReader.INSTANCE;
    }

    public static ValueReader<Double> doubles() {
        return DoubleReader.INSTANCE;
    }

    public static ValueReader<String> strings() {
        return StringReader.INSTANCE;
    }

    public static ValueReader<Utf8> utf8s() {
        return Utf8Reader.INSTANCE;
    }

    public static ValueReader<String> enums(List<String> symbols) {
        return new EnumReader(symbols);
    }

    public static ValueReader<UUID> uuids() {
        return UUIDReader.INSTANCE;
    }

    public static ValueReader<byte[]> fixed(int length) {
        return new FixedReader(length);
    }

    public static ValueReader<GenericData.Fixed> fixed(Schema schema) {
        return new GenericFixedReader(schema);
    }

    public static ValueReader<byte[]> bytes() {
        return BytesReader.INSTANCE;
    }

    public static ValueReader<ByteBuffer> byteBuffers() {
        return ByteBufferReader.INSTANCE;
    }

    public static ValueReader<BigDecimal> decimal(ValueReader<byte[]> unscaledReader, int scale) {
        return new DecimalReader(unscaledReader, scale);
    }

    public static ValueReader<byte[]> decimalBytesReader(Schema schema) {
        switch (schema.getType()) {
            case FIXED: {
                return ValueReaders.fixed(schema.getFixedSize());
            }
            case BYTES: {
                return ValueReaders.bytes();
            }
        }
        throw new IllegalArgumentException("Invalid primitive type for decimal: " + (Object)((Object)schema.getType()));
    }

    public static ValueReader<Object> union(List<ValueReader<?>> readers) {
        return new UnionReader(readers);
    }

    public static <T> ValueReader<Collection<T>> array(ValueReader<T> elementReader) {
        return new ArrayReader(elementReader);
    }

    public static <K, V> ValueReader<Map<K, V>> arrayMap(ValueReader<K> keyReader, ValueReader<V> valueReader) {
        return new ArrayMapReader(keyReader, valueReader);
    }

    public static <K, V> ValueReader<Map<K, V>> map(ValueReader<K> keyReader, ValueReader<V> valueReader) {
        return new MapReader(keyReader, valueReader);
    }

    public static ValueReader<GenericData.Record> record(List<ValueReader<?>> readers, Schema recordSchema) {
        return new RecordReader(readers, recordSchema);
    }

    public static <R extends IndexedRecord> ValueReader<R> record(List<ValueReader<?>> readers, Class<R> recordClass, Schema recordSchema) {
        return new IndexedRecordReader<R>(readers, recordClass, recordSchema);
    }

    static class PositionReader
    implements ValueReader<Long> {
        private long currentPosition;

        PositionReader(long rowPosition) {
            this.currentPosition = rowPosition - 1L;
        }

        @Override
        public Long read(Decoder ignored, Object reuse) throws IOException {
            ++this.currentPosition;
            return this.currentPosition;
        }
    }

    static class IndexedRecordReader<R extends IndexedRecord>
    extends StructReader<R> {
        private final Class<R> recordClass;
        private final DynConstructors.Ctor<R> ctor;
        private final Schema schema;

        IndexedRecordReader(List<ValueReader<?>> readers, Class<R> recordClass, Schema schema) {
            super(readers, schema);
            this.recordClass = recordClass;
            this.ctor = DynConstructors.builder(IndexedRecord.class).hiddenImpl(recordClass, (Class<?>[])new Class[]{Schema.class}).hiddenImpl(recordClass, (Class<?>[])new Class[0]).build();
            this.schema = schema;
        }

        @Override
        protected R reuseOrCreate(Object reuse) {
            if (this.recordClass.isInstance(reuse)) {
                return (R)((IndexedRecord)this.recordClass.cast(reuse));
            }
            return (R)((IndexedRecord)this.ctor.newInstance(this.schema));
        }

        @Override
        protected Object get(R struct, int pos) {
            return struct.get(pos);
        }

        @Override
        protected void set(R struct, int pos, Object value) {
            struct.put(pos, value);
        }
    }

    private static class RecordReader
    extends StructReader<GenericData.Record> {
        private final Schema recordSchema;

        private RecordReader(List<ValueReader<?>> readers, Schema recordSchema) {
            super(readers, recordSchema);
            this.recordSchema = recordSchema;
        }

        @Override
        protected GenericData.Record reuseOrCreate(Object reuse) {
            if (reuse instanceof GenericData.Record) {
                return (GenericData.Record)reuse;
            }
            return new GenericData.Record(this.recordSchema);
        }

        @Override
        protected Object get(GenericData.Record struct, int pos) {
            return struct.get(pos);
        }

        @Override
        protected void set(GenericData.Record struct, int pos, Object value) {
            struct.put(pos, value);
        }
    }

    public static abstract class StructReader<S>
    implements ValueReader<S>,
    SupportsRowPosition {
        private final ValueReader<?>[] readers;
        private final int[] positions;
        private final Object[] constants;
        private int posField = -1;

        protected StructReader(List<ValueReader<?>> readers, Schema schema) {
            this.readers = readers.toArray(new ValueReader[0]);
            Integer isDeletedColumnPos = null;
            List<Schema.Field> fields = schema.getFields();
            for (int pos = 0; pos < fields.size(); ++pos) {
                Schema.Field field = fields.get(pos);
                if (AvroSchemaUtil.getFieldId(field) == MetadataColumns.ROW_POSITION.fieldId()) {
                    this.posField = pos;
                    continue;
                }
                if (AvroSchemaUtil.getFieldId(field) != MetadataColumns.IS_DELETED.fieldId()) continue;
                isDeletedColumnPos = pos;
            }
            if (isDeletedColumnPos == null) {
                this.positions = new int[0];
                this.constants = new Object[0];
            } else {
                this.positions = new int[]{isDeletedColumnPos};
                this.constants = new Object[]{false};
            }
        }

        protected StructReader(List<ValueReader<?>> readers, Types.StructType struct, Map<Integer, ?> idToConstant) {
            this.readers = readers.toArray(new ValueReader[0]);
            List<Types.NestedField> fields = struct.fields();
            ArrayList<Integer> positionList = Lists.newArrayListWithCapacity(fields.size());
            ArrayList<Object> constantList = Lists.newArrayListWithCapacity(fields.size());
            for (int pos = 0; pos < fields.size(); ++pos) {
                Types.NestedField field = fields.get(pos);
                if (idToConstant.containsKey(field.fieldId())) {
                    positionList.add(pos);
                    constantList.add(idToConstant.get(field.fieldId()));
                    continue;
                }
                if (field.fieldId() == MetadataColumns.ROW_POSITION.fieldId()) {
                    this.posField = pos;
                    continue;
                }
                if (field.fieldId() != MetadataColumns.IS_DELETED.fieldId()) continue;
                positionList.add(pos);
                constantList.add(false);
            }
            this.positions = positionList.stream().mapToInt(Integer::intValue).toArray();
            this.constants = constantList.toArray();
        }

        @Override
        public void setRowPositionSupplier(Supplier<Long> posSupplier) {
            if (this.posField >= 0) {
                long startingPos = posSupplier.get();
                this.readers[this.posField] = new PositionReader(startingPos);
                for (ValueReader<?> reader : this.readers) {
                    if (!(reader instanceof SupportsRowPosition)) continue;
                    ((SupportsRowPosition)((Object)reader)).setRowPositionSupplier(() -> startingPos);
                }
            } else {
                for (ValueReader<?> reader : this.readers) {
                    if (!(reader instanceof SupportsRowPosition)) continue;
                    ((SupportsRowPosition)((Object)reader)).setRowPositionSupplier(posSupplier);
                }
            }
        }

        protected abstract S reuseOrCreate(Object var1);

        protected abstract Object get(S var1, int var2);

        protected abstract void set(S var1, int var2, Object var3);

        public ValueReader<?> reader(int pos) {
            return this.readers[pos];
        }

        @Override
        public S read(Decoder decoder, Object reuse) throws IOException {
            S struct = this.reuseOrCreate(reuse);
            if (decoder instanceof ResolvingDecoder) {
                for (Schema.Field field : ((ResolvingDecoder)decoder).readFieldOrder()) {
                    Object reusedValue = this.get(struct, field.pos());
                    this.set(struct, field.pos(), this.readers[field.pos()].read(decoder, reusedValue));
                }
            } else {
                for (int i = 0; i < this.readers.length; ++i) {
                    Object reusedValue = this.get(struct, i);
                    this.set(struct, i, this.readers[i].read(decoder, reusedValue));
                }
            }
            for (int i = 0; i < this.positions.length; ++i) {
                this.set(struct, this.positions[i], this.constants[i]);
            }
            return struct;
        }
    }

    private static class MapReader<K, V>
    implements ValueReader<Map<K, V>> {
        private final ValueReader<K> keyReader;
        private final ValueReader<V> valueReader;
        private Map lastMap = null;

        private MapReader(ValueReader<K> keyReader, ValueReader<V> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        @Override
        public Map<K, V> read(Decoder decoder, Object reuse) throws IOException {
            Iterator kvIter;
            Map<K, V> resultMap;
            this.lastMap = reuse instanceof Map ? (Map)reuse : null;
            if (this.lastMap != null) {
                this.lastMap.clear();
                resultMap = this.lastMap;
            } else {
                resultMap = Maps.newLinkedHashMap();
            }
            long chunkLength = decoder.readMapStart();
            Iterator<Object> iterator = kvIter = this.lastMap != null ? this.lastMap.entrySet().iterator() : Collections.emptyIterator();
            while (chunkLength > 0L) {
                for (long i = 0L; i < chunkLength; ++i) {
                    V value;
                    K key;
                    if (kvIter.hasNext()) {
                        Map.Entry last = (Map.Entry)kvIter.next();
                        key = this.keyReader.read(decoder, last.getKey());
                        value = this.valueReader.read(decoder, last.getValue());
                    } else {
                        key = this.keyReader.read(decoder, null);
                        value = this.valueReader.read(decoder, null);
                    }
                    resultMap.put(key, value);
                }
                chunkLength = decoder.mapNext();
            }
            return resultMap;
        }
    }

    private static class ArrayMapReader<K, V>
    implements ValueReader<Map<K, V>> {
        private final ValueReader<K> keyReader;
        private final ValueReader<V> valueReader;
        private Map lastMap = null;

        private ArrayMapReader(ValueReader<K> keyReader, ValueReader<V> valueReader) {
            this.keyReader = keyReader;
            this.valueReader = valueReader;
        }

        @Override
        public Map<K, V> read(Decoder decoder, Object reuse) throws IOException {
            Iterator kvIter;
            Map<K, V> resultMap;
            this.lastMap = reuse instanceof Map ? (Map)reuse : null;
            if (this.lastMap != null) {
                this.lastMap.clear();
                resultMap = this.lastMap;
            } else {
                resultMap = Maps.newLinkedHashMap();
            }
            long chunkLength = decoder.readArrayStart();
            Iterator<Object> iterator = kvIter = this.lastMap != null ? this.lastMap.entrySet().iterator() : Collections.emptyIterator();
            while (chunkLength > 0L) {
                for (long i = 0L; i < chunkLength; ++i) {
                    V value;
                    K key;
                    if (kvIter.hasNext()) {
                        Map.Entry last = (Map.Entry)kvIter.next();
                        key = this.keyReader.read(decoder, last.getKey());
                        value = this.valueReader.read(decoder, last.getValue());
                    } else {
                        key = this.keyReader.read(decoder, null);
                        value = this.valueReader.read(decoder, null);
                    }
                    resultMap.put(key, value);
                }
                chunkLength = decoder.arrayNext();
            }
            return resultMap;
        }
    }

    private static class ArrayReader<T>
    implements ValueReader<Collection<T>> {
        private final ValueReader<T> elementReader;
        private Deque<?> lastList = null;

        private ArrayReader(ValueReader<T> elementReader) {
            this.elementReader = elementReader;
        }

        @Override
        public Collection<T> read(Decoder decoder, Object reused) throws IOException {
            Iterator elIter;
            LinkedList resultList;
            if (this.lastList != null) {
                this.lastList.clear();
                resultList = (LinkedList)this.lastList;
            } else {
                resultList = Lists.newLinkedList();
            }
            this.lastList = reused instanceof LinkedList ? (LinkedList)reused : null;
            long chunkLength = decoder.readArrayStart();
            Iterator<Object> iterator = elIter = this.lastList != null ? this.lastList.iterator() : Collections.emptyIterator();
            while (chunkLength > 0L) {
                for (long i = 0L; i < chunkLength; ++i) {
                    Object lastValue = elIter.hasNext() ? elIter.next() : null;
                    resultList.addLast(this.elementReader.read(decoder, lastValue));
                }
                chunkLength = decoder.arrayNext();
            }
            return resultList;
        }
    }

    private static class EnumReader
    implements ValueReader<String> {
        private final String[] symbols;

        private EnumReader(List<String> symbols) {
            this.symbols = new String[symbols.size()];
            for (int i = 0; i < this.symbols.length; ++i) {
                this.symbols[i] = symbols.get(i);
            }
        }

        @Override
        public String read(Decoder decoder, Object ignored) throws IOException {
            int index = decoder.readEnum();
            return this.symbols[index];
        }
    }

    private static class UnionReader
    implements ValueReader<Object> {
        private final ValueReader[] readers;

        private UnionReader(List<ValueReader<?>> readers) {
            this.readers = new ValueReader[readers.size()];
            for (int i = 0; i < this.readers.length; ++i) {
                this.readers[i] = readers.get(i);
            }
        }

        @Override
        public Object read(Decoder decoder, Object reuse) throws IOException {
            int index = decoder.readIndex();
            return this.readers[index].read(decoder, reuse);
        }
    }

    private static class DecimalReader
    implements ValueReader<BigDecimal> {
        private final ValueReader<byte[]> bytesReader;
        private final int scale;

        private DecimalReader(ValueReader<byte[]> bytesReader, int scale) {
            this.bytesReader = bytesReader;
            this.scale = scale;
        }

        @Override
        public BigDecimal read(Decoder decoder, Object ignored) throws IOException {
            byte[] bytes = this.bytesReader.read(decoder, null);
            return new BigDecimal(new BigInteger(bytes), this.scale);
        }
    }

    private static class ByteBufferReader
    implements ValueReader<ByteBuffer> {
        private static final ByteBufferReader INSTANCE = new ByteBufferReader();

        private ByteBufferReader() {
        }

        @Override
        public ByteBuffer read(Decoder decoder, Object reuse) throws IOException {
            if (reuse instanceof ByteBuffer) {
                return decoder.readBytes((ByteBuffer)reuse);
            }
            return decoder.readBytes(null);
        }
    }

    private static class BytesReader
    implements ValueReader<byte[]> {
        private static final BytesReader INSTANCE = new BytesReader();

        private BytesReader() {
        }

        @Override
        public byte[] read(Decoder decoder, Object reuse) throws IOException {
            return decoder.readBytes(null).array();
        }
    }

    private static class GenericFixedReader
    implements ValueReader<GenericData.Fixed> {
        private final Schema schema;
        private final int length;

        private GenericFixedReader(Schema schema) {
            this.schema = schema;
            this.length = schema.getFixedSize();
        }

        @Override
        public GenericData.Fixed read(Decoder decoder, Object reuse) throws IOException {
            GenericData.Fixed reusedFixed;
            if (reuse instanceof GenericData.Fixed && (reusedFixed = (GenericData.Fixed)reuse).bytes().length == this.length) {
                decoder.readFixed(reusedFixed.bytes(), 0, this.length);
                return reusedFixed;
            }
            byte[] bytes = new byte[this.length];
            decoder.readFixed(bytes, 0, this.length);
            return new GenericData.Fixed(this.schema, bytes);
        }
    }

    private static class FixedReader
    implements ValueReader<byte[]> {
        private final int length;

        private FixedReader(int length) {
            this.length = length;
        }

        @Override
        public byte[] read(Decoder decoder, Object reuse) throws IOException {
            byte[] reusedBytes;
            if (reuse instanceof byte[] && (reusedBytes = (byte[])reuse).length == this.length) {
                decoder.readFixed(reusedBytes, 0, this.length);
                return reusedBytes;
            }
            byte[] bytes = new byte[this.length];
            decoder.readFixed(bytes, 0, this.length);
            return bytes;
        }
    }

    private static class UUIDReader
    implements ValueReader<UUID> {
        private static final ThreadLocal<ByteBuffer> BUFFER = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(16);
            buffer.order(ByteOrder.BIG_ENDIAN);
            return buffer;
        });
        private static final UUIDReader INSTANCE = new UUIDReader();

        private UUIDReader() {
        }

        @Override
        public UUID read(Decoder decoder, Object ignored) throws IOException {
            ByteBuffer buffer = BUFFER.get();
            buffer.rewind();
            decoder.readFixed(buffer.array(), 0, 16);
            return UUIDUtil.convert(buffer);
        }
    }

    private static class Utf8Reader
    implements ValueReader<Utf8> {
        private static final Utf8Reader INSTANCE = new Utf8Reader();

        private Utf8Reader() {
        }

        @Override
        public Utf8 read(Decoder decoder, Object reuse) throws IOException {
            if (reuse instanceof Utf8) {
                return decoder.readString((Utf8)reuse);
            }
            return decoder.readString(null);
        }
    }

    private static class StringReader
    implements ValueReader<String> {
        private static final StringReader INSTANCE = new StringReader();
        private final ThreadLocal<Utf8> reusedTempUtf8 = ThreadLocal.withInitial(Utf8::new);

        private StringReader() {
        }

        @Override
        public String read(Decoder decoder, Object ignored) throws IOException {
            this.reusedTempUtf8.set(decoder.readString(this.reusedTempUtf8.get()));
            return this.reusedTempUtf8.get().toString();
        }
    }

    private static class DoubleReader
    implements ValueReader<Double> {
        private static final DoubleReader INSTANCE = new DoubleReader();

        private DoubleReader() {
        }

        @Override
        public Double read(Decoder decoder, Object ignored) throws IOException {
            return decoder.readDouble();
        }
    }

    private static class FloatReader
    implements ValueReader<Float> {
        private static final FloatReader INSTANCE = new FloatReader();

        private FloatReader() {
        }

        @Override
        public Float read(Decoder decoder, Object ignored) throws IOException {
            return Float.valueOf(decoder.readFloat());
        }
    }

    private static class LongReader
    implements ValueReader<Long> {
        private static final LongReader INSTANCE = new LongReader();

        private LongReader() {
        }

        @Override
        public Long read(Decoder decoder, Object ignored) throws IOException {
            return decoder.readLong();
        }
    }

    private static class IntegerReader
    implements ValueReader<Integer> {
        private static final IntegerReader INSTANCE = new IntegerReader();

        private IntegerReader() {
        }

        @Override
        public Integer read(Decoder decoder, Object ignored) throws IOException {
            return decoder.readInt();
        }
    }

    private static class BooleanReader
    implements ValueReader<Boolean> {
        private static final BooleanReader INSTANCE = new BooleanReader();

        private BooleanReader() {
        }

        @Override
        public Boolean read(Decoder decoder, Object ignored) throws IOException {
            return decoder.readBoolean();
        }
    }

    private static class NullReader
    implements ValueReader<Object> {
        private static final NullReader INSTANCE = new NullReader();

        private NullReader() {
        }

        @Override
        public Object read(Decoder decoder, Object ignored) throws IOException {
            decoder.readNull();
            return null;
        }
    }
}

