/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.hive.iceberg.org.apache.avro.JsonProperties;
import org.apache.hive.iceberg.org.apache.avro.LogicalTypes;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class TypeToSchema
extends TypeUtil.SchemaVisitor<org.apache.hive.iceberg.org.apache.avro.Schema> {
    private static final org.apache.hive.iceberg.org.apache.avro.Schema BOOLEAN_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.BOOLEAN);
    private static final org.apache.hive.iceberg.org.apache.avro.Schema INTEGER_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.INT);
    private static final org.apache.hive.iceberg.org.apache.avro.Schema LONG_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.LONG);
    private static final org.apache.hive.iceberg.org.apache.avro.Schema FLOAT_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.FLOAT);
    private static final org.apache.hive.iceberg.org.apache.avro.Schema DOUBLE_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.DOUBLE);
    private static final org.apache.hive.iceberg.org.apache.avro.Schema DATE_SCHEMA = LogicalTypes.date().addToSchema(org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.INT));
    private static final org.apache.hive.iceberg.org.apache.avro.Schema TIME_SCHEMA = LogicalTypes.timeMicros().addToSchema(org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.LONG));
    private static final org.apache.hive.iceberg.org.apache.avro.Schema TIMESTAMP_SCHEMA = LogicalTypes.timestampMicros().addToSchema(org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.LONG));
    private static final org.apache.hive.iceberg.org.apache.avro.Schema TIMESTAMPTZ_SCHEMA = LogicalTypes.timestampMicros().addToSchema(org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.LONG));
    private static final org.apache.hive.iceberg.org.apache.avro.Schema STRING_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.STRING);
    private static final org.apache.hive.iceberg.org.apache.avro.Schema UUID_SCHEMA = LogicalTypes.uuid().addToSchema(org.apache.hive.iceberg.org.apache.avro.Schema.createFixed("uuid_fixed", null, null, 16));
    private static final org.apache.hive.iceberg.org.apache.avro.Schema BINARY_SCHEMA = org.apache.hive.iceberg.org.apache.avro.Schema.create(Schema.Type.BYTES);
    private final Deque<Integer> fieldIds = Lists.newLinkedList();
    private final Map<Type, org.apache.hive.iceberg.org.apache.avro.Schema> results = Maps.newHashMap();
    private final Map<Types.StructType, String> names;

    TypeToSchema(Map<Types.StructType, String> names) {
        this.names = names;
    }

    Map<Type, org.apache.hive.iceberg.org.apache.avro.Schema> getConversionMap() {
        return this.results;
    }

    @Override
    public org.apache.hive.iceberg.org.apache.avro.Schema schema(Schema schema, org.apache.hive.iceberg.org.apache.avro.Schema structSchema) {
        return structSchema;
    }

    @Override
    public void beforeField(Types.NestedField field) {
        this.fieldIds.push(field.fieldId());
    }

    @Override
    public void afterField(Types.NestedField field) {
        this.fieldIds.pop();
    }

    @Override
    public org.apache.hive.iceberg.org.apache.avro.Schema struct(Types.StructType struct, List<org.apache.hive.iceberg.org.apache.avro.Schema> fieldSchemas) {
        org.apache.hive.iceberg.org.apache.avro.Schema recordSchema = this.results.get(struct);
        if (recordSchema != null) {
            return recordSchema;
        }
        String recordName = this.names.get(struct);
        if (recordName == null) {
            recordName = "r" + this.fieldIds.peek();
        }
        List<Types.NestedField> structFields = struct.fields();
        ArrayList<Schema.Field> fields = Lists.newArrayListWithExpectedSize(fieldSchemas.size());
        for (int i = 0; i < structFields.size(); ++i) {
            Types.NestedField structField = structFields.get(i);
            String origFieldName = structField.name();
            boolean isValidFieldName = AvroSchemaUtil.validAvroName(origFieldName);
            String fieldName = isValidFieldName ? origFieldName : AvroSchemaUtil.sanitize(origFieldName);
            Schema.Field field = new Schema.Field(fieldName, fieldSchemas.get(i), structField.doc(), structField.isOptional() ? JsonProperties.NULL_VALUE : null);
            if (!isValidFieldName) {
                field.addProp("iceberg-field-name", origFieldName);
            }
            field.addProp("field-id", structField.fieldId());
            fields.add(field);
        }
        recordSchema = org.apache.hive.iceberg.org.apache.avro.Schema.createRecord(recordName, null, null, false, fields);
        this.results.put(struct, recordSchema);
        return recordSchema;
    }

    @Override
    public org.apache.hive.iceberg.org.apache.avro.Schema field(Types.NestedField field, org.apache.hive.iceberg.org.apache.avro.Schema fieldSchema) {
        if (field.isOptional()) {
            return AvroSchemaUtil.toOption(fieldSchema);
        }
        return fieldSchema;
    }

    @Override
    public org.apache.hive.iceberg.org.apache.avro.Schema list(Types.ListType list, org.apache.hive.iceberg.org.apache.avro.Schema elementSchema) {
        org.apache.hive.iceberg.org.apache.avro.Schema listSchema = this.results.get(list);
        if (listSchema != null) {
            return listSchema;
        }
        listSchema = list.isElementOptional() ? org.apache.hive.iceberg.org.apache.avro.Schema.createArray(AvroSchemaUtil.toOption(elementSchema)) : org.apache.hive.iceberg.org.apache.avro.Schema.createArray(elementSchema);
        listSchema.addProp("element-id", list.elementId());
        this.results.put(list, listSchema);
        return listSchema;
    }

    @Override
    public org.apache.hive.iceberg.org.apache.avro.Schema map(Types.MapType map, org.apache.hive.iceberg.org.apache.avro.Schema keySchema, org.apache.hive.iceberg.org.apache.avro.Schema valueSchema) {
        org.apache.hive.iceberg.org.apache.avro.Schema mapSchema = this.results.get(map);
        if (mapSchema != null) {
            return mapSchema;
        }
        if (keySchema.getType() == Schema.Type.STRING) {
            mapSchema = org.apache.hive.iceberg.org.apache.avro.Schema.createMap(map.isValueOptional() ? AvroSchemaUtil.toOption(valueSchema) : valueSchema);
            mapSchema.addProp("key-id", map.keyId());
            mapSchema.addProp("value-id", map.valueId());
        } else {
            mapSchema = AvroSchemaUtil.createMap(map.keyId(), keySchema, map.valueId(), map.isValueOptional() ? AvroSchemaUtil.toOption(valueSchema) : valueSchema);
        }
        this.results.put(map, mapSchema);
        return mapSchema;
    }

    @Override
    public org.apache.hive.iceberg.org.apache.avro.Schema primitive(Type.PrimitiveType primitive) {
        org.apache.hive.iceberg.org.apache.avro.Schema primitiveSchema;
        switch (primitive.typeId()) {
            case BOOLEAN: {
                primitiveSchema = BOOLEAN_SCHEMA;
                break;
            }
            case INTEGER: {
                primitiveSchema = INTEGER_SCHEMA;
                break;
            }
            case LONG: {
                primitiveSchema = LONG_SCHEMA;
                break;
            }
            case FLOAT: {
                primitiveSchema = FLOAT_SCHEMA;
                break;
            }
            case DOUBLE: {
                primitiveSchema = DOUBLE_SCHEMA;
                break;
            }
            case DATE: {
                primitiveSchema = DATE_SCHEMA;
                break;
            }
            case TIME: {
                primitiveSchema = TIME_SCHEMA;
                break;
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)primitive).shouldAdjustToUTC()) {
                    primitiveSchema = TIMESTAMPTZ_SCHEMA;
                    break;
                }
                primitiveSchema = TIMESTAMP_SCHEMA;
                break;
            }
            case STRING: {
                primitiveSchema = STRING_SCHEMA;
                break;
            }
            case UUID: {
                primitiveSchema = UUID_SCHEMA;
                break;
            }
            case FIXED: {
                Types.FixedType fixed = (Types.FixedType)primitive;
                primitiveSchema = org.apache.hive.iceberg.org.apache.avro.Schema.createFixed("fixed_" + fixed.length(), null, null, fixed.length());
                break;
            }
            case BINARY: {
                primitiveSchema = BINARY_SCHEMA;
                break;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)primitive;
                primitiveSchema = LogicalTypes.decimal(decimal.precision(), decimal.scale()).addToSchema(org.apache.hive.iceberg.org.apache.avro.Schema.createFixed("decimal_" + decimal.precision() + "_" + decimal.scale(), null, null, TypeUtil.decimalRequiredBytes(decimal.precision())));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported type ID: " + (Object)((Object)primitive.typeId()));
            }
        }
        this.results.put(primitive, primitiveSchema);
        return primitiveSchema;
    }

    static {
        TIMESTAMP_SCHEMA.addProp("adjust-to-utc", false);
        TIMESTAMPTZ_SCHEMA.addProp("adjust-to-utc", true);
    }
}

