/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.hive.iceberg.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.iceberg.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;

public class SchemaParser {
    private static final String SCHEMA_ID = "schema-id";
    private static final String IDENTIFIER_FIELD_IDS = "identifier-field-ids";
    private static final String TYPE = "type";
    private static final String STRUCT = "struct";
    private static final String LIST = "list";
    private static final String MAP = "map";
    private static final String FIELDS = "fields";
    private static final String ELEMENT = "element";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String DOC = "doc";
    private static final String NAME = "name";
    private static final String ID = "id";
    private static final String ELEMENT_ID = "element-id";
    private static final String KEY_ID = "key-id";
    private static final String VALUE_ID = "value-id";
    private static final String REQUIRED = "required";
    private static final String ELEMENT_REQUIRED = "element-required";
    private static final String VALUE_REQUIRED = "value-required";
    private static final Cache<String, Schema> SCHEMA_CACHE = Caffeine.newBuilder().weakValues().build();

    private SchemaParser() {
    }

    private static void toJson(Types.StructType struct, JsonGenerator generator) throws IOException {
        SchemaParser.toJson(struct, null, null, generator);
    }

    private static void toJson(Types.StructType struct, Integer schemaId, Set<Integer> identifierFieldIds, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE, STRUCT);
        if (schemaId != null) {
            generator.writeNumberField(SCHEMA_ID, schemaId);
        }
        if (identifierFieldIds != null && !identifierFieldIds.isEmpty()) {
            JsonUtil.writeIntegerArray(IDENTIFIER_FIELD_IDS, identifierFieldIds, generator);
        }
        generator.writeArrayFieldStart(FIELDS);
        for (Types.NestedField field : struct.fields()) {
            generator.writeStartObject();
            generator.writeNumberField(ID, field.fieldId());
            generator.writeStringField(NAME, field.name());
            generator.writeBooleanField(REQUIRED, field.isRequired());
            generator.writeFieldName(TYPE);
            SchemaParser.toJson(field.type(), generator);
            if (field.doc() != null) {
                generator.writeStringField(DOC, field.doc());
            }
            generator.writeEndObject();
        }
        generator.writeEndArray();
        generator.writeEndObject();
    }

    static void toJson(Types.ListType list, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE, LIST);
        generator.writeNumberField(ELEMENT_ID, list.elementId());
        generator.writeFieldName(ELEMENT);
        SchemaParser.toJson(list.elementType(), generator);
        generator.writeBooleanField(ELEMENT_REQUIRED, !list.isElementOptional());
        generator.writeEndObject();
    }

    static void toJson(Types.MapType map, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE, MAP);
        generator.writeNumberField(KEY_ID, map.keyId());
        generator.writeFieldName(KEY);
        SchemaParser.toJson(map.keyType(), generator);
        generator.writeNumberField(VALUE_ID, map.valueId());
        generator.writeFieldName(VALUE);
        SchemaParser.toJson(map.valueType(), generator);
        generator.writeBooleanField(VALUE_REQUIRED, !map.isValueOptional());
        generator.writeEndObject();
    }

    static void toJson(Type.PrimitiveType primitive, JsonGenerator generator) throws IOException {
        generator.writeString(primitive.toString());
    }

    static void toJson(Type type, JsonGenerator generator) throws IOException {
        if (type.isPrimitiveType()) {
            SchemaParser.toJson(type.asPrimitiveType(), generator);
        } else {
            Type.NestedType nested = type.asNestedType();
            switch (type.typeId()) {
                case STRUCT: {
                    SchemaParser.toJson(nested.asStructType(), generator);
                    break;
                }
                case LIST: {
                    SchemaParser.toJson(nested.asListType(), generator);
                    break;
                }
                case MAP: {
                    SchemaParser.toJson(nested.asMapType(), generator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot write unknown type: " + type);
                }
            }
        }
    }

    public static void toJson(Schema schema, JsonGenerator generator) throws IOException {
        SchemaParser.toJson(schema.asStruct(), schema.schemaId(), schema.identifierFieldIds(), generator);
    }

    public static String toJson(Schema schema) {
        return SchemaParser.toJson(schema, false);
    }

    public static String toJson(Schema schema, boolean pretty) {
        return JsonUtil.generate(gen -> SchemaParser.toJson(schema.asStruct(), schema.schemaId(), schema.identifierFieldIds(), gen), pretty);
    }

    private static Type typeFromJson(JsonNode json) {
        JsonNode typeObj;
        if (json.isTextual()) {
            return Types.fromPrimitiveString(json.asText());
        }
        if (json.isObject() && (typeObj = json.get(TYPE)) != null) {
            String type = typeObj.asText();
            if (STRUCT.equals(type)) {
                return SchemaParser.structFromJson(json);
            }
            if (LIST.equals(type)) {
                return SchemaParser.listFromJson(json);
            }
            if (MAP.equals(type)) {
                return SchemaParser.mapFromJson(json);
            }
        }
        throw new IllegalArgumentException("Cannot parse type from json: " + json);
    }

    private static Types.StructType structFromJson(JsonNode json) {
        JsonNode fieldArray = JsonUtil.get(FIELDS, json);
        Preconditions.checkArgument(fieldArray.isArray(), "Cannot parse struct fields from non-array: %s", (Object)fieldArray);
        ArrayList<Types.NestedField> fields = Lists.newArrayListWithExpectedSize(fieldArray.size());
        Iterator<JsonNode> iterator = fieldArray.elements();
        while (iterator.hasNext()) {
            JsonNode field = iterator.next();
            Preconditions.checkArgument(field.isObject(), "Cannot parse struct field from non-object: %s", (Object)field);
            int id = JsonUtil.getInt(ID, field);
            String name = JsonUtil.getString(NAME, field);
            Type type = SchemaParser.typeFromJson(JsonUtil.get(TYPE, field));
            String doc = JsonUtil.getStringOrNull(DOC, field);
            boolean isRequired = JsonUtil.getBool(REQUIRED, field);
            if (isRequired) {
                fields.add(Types.NestedField.required(id, name, type, doc));
                continue;
            }
            fields.add(Types.NestedField.optional(id, name, type, doc));
        }
        return Types.StructType.of(fields);
    }

    private static Types.ListType listFromJson(JsonNode json) {
        int elementId = JsonUtil.getInt(ELEMENT_ID, json);
        Type elementType = SchemaParser.typeFromJson(JsonUtil.get(ELEMENT, json));
        boolean isRequired = JsonUtil.getBool(ELEMENT_REQUIRED, json);
        if (isRequired) {
            return Types.ListType.ofRequired(elementId, elementType);
        }
        return Types.ListType.ofOptional(elementId, elementType);
    }

    private static Types.MapType mapFromJson(JsonNode json) {
        int keyId = JsonUtil.getInt(KEY_ID, json);
        Type keyType = SchemaParser.typeFromJson(JsonUtil.get(KEY, json));
        int valueId = JsonUtil.getInt(VALUE_ID, json);
        Type valueType = SchemaParser.typeFromJson(JsonUtil.get(VALUE, json));
        boolean isRequired = JsonUtil.getBool(VALUE_REQUIRED, json);
        if (isRequired) {
            return Types.MapType.ofRequired(keyId, valueId, keyType, valueType);
        }
        return Types.MapType.ofOptional(keyId, valueId, keyType, valueType);
    }

    public static Schema fromJson(JsonNode json) {
        Type type = SchemaParser.typeFromJson(json);
        Preconditions.checkArgument(type.isNestedType() && type.asNestedType().isStructType(), "Cannot create schema, not a struct type: %s", (Object)type);
        Integer schemaId = JsonUtil.getIntOrNull(SCHEMA_ID, json);
        Set<Integer> identifierFieldIds = JsonUtil.getIntegerSetOrNull(IDENTIFIER_FIELD_IDS, json);
        if (schemaId == null) {
            return new Schema(type.asNestedType().asStructType().fields(), identifierFieldIds);
        }
        return new Schema((int)schemaId, type.asNestedType().asStructType().fields(), identifierFieldIds);
    }

    public static Schema fromJson(String json) {
        return SCHEMA_CACHE.get(json, jsonKey -> JsonUtil.parse(json, SchemaParser::fromJson));
    }
}

