/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.hive.iceberg.org.apache.avro.Schema;
import org.apache.hive.iceberg.org.apache.avro.generic.IndexedRecord;
import org.apache.hive.iceberg.org.apache.avro.specific.SpecificData;
import org.apache.hive.iceberg.org.apache.avro.util.Utf8;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.hash.Hasher;
import org.apache.iceberg.relocated.com.google.common.hash.Hashing;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class PartitionData
implements IndexedRecord,
StructLike,
SpecificData.SchemaConstructable,
Serializable {
    private final Types.StructType partitionType;
    private final int size;
    private final Object[] data;
    private final String stringSchema;
    private transient Schema schema;

    static Schema partitionDataSchema(Types.StructType partitionType) {
        return AvroSchemaUtil.convert(partitionType, PartitionData.class.getName());
    }

    PartitionData(Schema schema) {
        this.partitionType = AvroSchemaUtil.convert(schema).asNestedType().asStructType();
        this.size = this.partitionType.fields().size();
        this.data = new Object[this.size];
        this.stringSchema = schema.toString();
        this.schema = schema;
    }

    public PartitionData(Types.StructType partitionType) {
        for (Types.NestedField field : partitionType.fields()) {
            Preconditions.checkArgument(field.type().isPrimitiveType(), "Partitions cannot contain nested types: %s", (Object)field.type());
        }
        this.partitionType = partitionType;
        this.size = partitionType.fields().size();
        this.data = new Object[this.size];
        this.schema = PartitionData.partitionDataSchema(partitionType);
        this.stringSchema = this.schema.toString();
    }

    private PartitionData(PartitionData toCopy) {
        this.partitionType = toCopy.partitionType;
        this.size = toCopy.size;
        this.data = PartitionData.copyData(toCopy.partitionType, toCopy.data);
        this.stringSchema = toCopy.stringSchema;
        this.schema = toCopy.schema;
    }

    public Types.StructType getPartitionType() {
        return this.partitionType;
    }

    @Override
    public Schema getSchema() {
        if (this.schema == null) {
            this.schema = new Schema.Parser().parse(this.stringSchema);
        }
        return this.schema;
    }

    public Type getType(int pos) {
        return this.partitionType.fields().get(pos).type();
    }

    public void clear() {
        Arrays.fill(this.data, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        Object value = this.get(pos);
        if (value == null || javaClass.isInstance(value)) {
            return javaClass.cast(value);
        }
        throw new IllegalArgumentException(String.format("Wrong class, expected %s, but was %s, for object: %s", javaClass.getName(), value.getClass().getName(), value));
    }

    @Override
    public Object get(int pos) {
        if (pos >= this.data.length) {
            return null;
        }
        if (this.data[pos] instanceof byte[]) {
            return ByteBuffer.wrap((byte[])this.data[pos]);
        }
        return this.data[pos];
    }

    @Override
    public <T> void set(int pos, T value) {
        if (value instanceof Utf8) {
            this.data[pos] = value.toString();
        } else if (value instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)value;
            byte[] bytes = new byte[buffer.remaining()];
            buffer.duplicate().get(bytes);
            this.data[pos] = bytes;
        } else {
            this.data[pos] = value;
        }
    }

    @Override
    public void put(int i, Object v) {
        this.set(i, v);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PartitionData{");
        for (int i = 0; i < this.data.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.partitionType.fields().get(i).name()).append("=").append(this.data[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    public PartitionData copy() {
        return new PartitionData(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionData)) {
            return false;
        }
        PartitionData that = (PartitionData)o;
        return this.partitionType.equals(that.partitionType) && Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        Hasher hasher = Hashing.goodFastHash(32).newHasher();
        Stream.of(this.data).map(Objects::hashCode).forEach(hasher::putInt);
        this.partitionType.fields().stream().map(Objects::hashCode).forEach(hasher::putInt);
        return hasher.hash().hashCode();
    }

    public static Object[] copyData(Types.StructType type, Object[] data) {
        List<Types.NestedField> fields = type.fields();
        Object[] copy = new Object[data.length];
        block5: for (int i = 0; i < data.length; ++i) {
            if (data[i] == null) {
                copy[i] = null;
                continue;
            }
            Types.NestedField field = fields.get(i);
            switch (field.type().typeId()) {
                case STRUCT: 
                case LIST: 
                case MAP: {
                    throw new IllegalArgumentException("Unsupported type in partition data: " + type);
                }
                case BINARY: 
                case FIXED: {
                    byte[] buffer = (byte[])data[i];
                    copy[i] = Arrays.copyOf(buffer, buffer.length);
                    continue block5;
                }
                case STRING: {
                    copy[i] = data[i].toString();
                    continue block5;
                }
                default: {
                    copy[i] = data[i];
                }
            }
        }
        return copy;
    }
}

