/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.iceberg.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hive.iceberg.org.apache.orc.ColumnStatistics;
import org.apache.hive.iceberg.org.apache.orc.CompressionCodec;
import org.apache.hive.iceberg.org.apache.orc.CompressionKind;
import org.apache.hive.iceberg.org.apache.orc.DataMaskDescription;
import org.apache.hive.iceberg.org.apache.orc.EncryptionAlgorithm;
import org.apache.hive.iceberg.org.apache.orc.EncryptionKey;
import org.apache.hive.iceberg.org.apache.orc.EncryptionVariant;
import org.apache.hive.iceberg.org.apache.orc.FileFormatException;
import org.apache.hive.iceberg.org.apache.orc.FileMetadata;
import org.apache.hive.iceberg.org.apache.orc.OrcConf;
import org.apache.hive.iceberg.org.apache.orc.OrcFile;
import org.apache.hive.iceberg.org.apache.orc.OrcProto;
import org.apache.hive.iceberg.org.apache.orc.OrcUtils;
import org.apache.hive.iceberg.org.apache.orc.Reader;
import org.apache.hive.iceberg.org.apache.orc.RecordReader;
import org.apache.hive.iceberg.org.apache.orc.StripeInformation;
import org.apache.hive.iceberg.org.apache.orc.StripeStatistics;
import org.apache.hive.iceberg.org.apache.orc.TypeDescription;
import org.apache.hive.iceberg.org.apache.orc.impl.BufferChunk;
import org.apache.hive.iceberg.org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.hive.iceberg.org.apache.orc.impl.CryptoUtils;
import org.apache.hive.iceberg.org.apache.orc.impl.InStream;
import org.apache.hive.iceberg.org.apache.orc.impl.OrcCodecPool;
import org.apache.hive.iceberg.org.apache.orc.impl.OrcTail;
import org.apache.hive.iceberg.org.apache.orc.impl.RecordReaderImpl;
import org.apache.hive.iceberg.org.apache.orc.impl.StripeStatisticsImpl;
import org.apache.hive.iceberg.org.apache.orc.impl.reader.ReaderEncryption;
import org.apache.hive.iceberg.org.apache.orc.impl.reader.ReaderEncryptionVariant;
import org.apache.hive.iceberg.org.apache.orc.protobuf.CodedInputStream;
import org.apache.hive.iceberg.org.apache.orc.protobuf.InvalidProtocolBufferException;
import org.apache.hive.iceberg.org.apache.orc.protobuf.TextFormat;
import org.apache.hive.iceberg.org.apache.orc.storage.ql.util.JavaDataModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderImpl
implements Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderImpl.class);
    private static final int DIRECTORY_SIZE_GUESS = 16384;
    public static final int DEFAULT_COMPRESSION_BLOCK_SIZE = 262144;
    private final long maxLength;
    protected final Path path;
    protected final OrcFile.ReaderOptions options;
    protected final CompressionKind compressionKind;
    protected FSDataInputStream file;
    protected int bufferSize;
    protected List<OrcProto.StripeStatistics> stripeStatistics;
    private final int metadataSize;
    protected final List<OrcProto.Type> types;
    private final TypeDescription schema;
    private final List<OrcProto.UserMetadataItem> userMetadata;
    private final List<OrcProto.ColumnStatistics> fileStats;
    private final List<StripeInformation> stripes;
    protected final int rowIndexStride;
    private final long contentLength;
    private final long numberOfRows;
    private final ReaderEncryption encryption;
    private long deserializedSize = -1L;
    protected final Configuration conf;
    protected final boolean useUTCTimestamp;
    private final List<Integer> versionList;
    private final OrcFile.WriterVersion writerVersion;
    private final String softwareVersion;
    protected final OrcTail tail;

    @Override
    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public List<String> getMetadataKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            result.add(item.getName());
        }
        return result;
    }

    @Override
    public ByteBuffer getMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return item.getValue().asReadOnlyByteBuffer();
        }
        throw new IllegalArgumentException("Can't find user metadata " + key);
    }

    @Override
    public boolean hasMetadataValue(String key) {
        for (OrcProto.UserMetadataItem item : this.userMetadata) {
            if (!item.hasName() || !item.getName().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompressionKind getCompressionKind() {
        return this.compressionKind;
    }

    @Override
    public int getCompressionSize() {
        return this.bufferSize;
    }

    @Override
    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public List<OrcProto.Type> getTypes() {
        return OrcUtils.getOrcTypes(this.schema);
    }

    public static OrcFile.Version getFileVersion(List<Integer> versionList) {
        if (versionList == null || versionList.isEmpty()) {
            return OrcFile.Version.V_0_11;
        }
        for (OrcFile.Version version : OrcFile.Version.values()) {
            if (version.getMajor() != versionList.get(0).intValue() || version.getMinor() != versionList.get(1).intValue()) continue;
            return version;
        }
        return OrcFile.Version.FUTURE;
    }

    @Override
    public OrcFile.Version getFileVersion() {
        return ReaderImpl.getFileVersion(this.versionList);
    }

    @Override
    public OrcFile.WriterVersion getWriterVersion() {
        return this.writerVersion;
    }

    @Override
    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    @Override
    public OrcProto.FileTail getFileTail() {
        return this.tail.getFileTail();
    }

    @Override
    public EncryptionKey[] getColumnEncryptionKeys() {
        return this.encryption.getKeys();
    }

    @Override
    public DataMaskDescription[] getDataMasks() {
        return this.encryption.getMasks();
    }

    public ReaderEncryptionVariant[] getEncryptionVariants() {
        return this.encryption.getVariants();
    }

    @Override
    public List<StripeStatistics> getVariantStripeStatistics(EncryptionVariant variant) throws IOException {
        if (variant == null) {
            if (this.stripeStatistics == null) {
                try (CompressionCodec codec = OrcCodecPool.getCodec(this.compressionKind);){
                    InStream.StreamOptions options = new InStream.StreamOptions();
                    if (codec != null) {
                        options.withCodec(codec).withBufferSize(this.bufferSize);
                    }
                    this.stripeStatistics = ReaderImpl.deserializeStripeStats(this.tail.getTailBuffer(), this.tail.getMetadataOffset(), this.tail.getMetadataSize(), options);
                }
            }
            return this.convertFromProto(this.stripeStatistics);
        }
        try (CompressionCodec codec = OrcCodecPool.getCodec(this.compressionKind);){
            InStream.StreamOptions compression = new InStream.StreamOptions();
            if (codec != null) {
                compression.withCodec(codec).withBufferSize(this.bufferSize);
            }
            List<StripeStatistics> list = ((ReaderEncryptionVariant)variant).getStripeStatistics(null, compression, this);
            return list;
        }
    }

    public ReaderEncryption getEncryption() {
        return this.encryption;
    }

    @Override
    public int getRowIndexStride() {
        return this.rowIndexStride;
    }

    @Override
    public ColumnStatistics[] getStatistics() {
        ColumnStatistics[] result = this.deserializeStats(this.schema, this.fileStats);
        if (this.encryption.getKeys().length > 0) {
            try (CompressionCodec codec = OrcCodecPool.getCodec(this.compressionKind);){
                InStream.StreamOptions compression = InStream.options();
                if (codec != null) {
                    compression.withCodec(codec).withBufferSize(this.bufferSize);
                }
                for (int c = this.schema.getId(); c <= this.schema.getMaximumId(); ++c) {
                    ReaderEncryptionVariant variant = this.encryption.getVariant(c);
                    if (variant == null) continue;
                    try {
                        int base = variant.getRoot().getId();
                        ColumnStatistics[] overrides = this.decryptFileStats(variant, compression, this.tail.getFooter());
                        for (int sub = 0; sub < overrides.length; ++sub) {
                            result[base + sub] = overrides[sub];
                        }
                        continue;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Can't decrypt file stats for " + this.path + " with " + variant.getKeyDescription());
                    }
                }
            }
        }
        return result;
    }

    private ColumnStatistics[] decryptFileStats(ReaderEncryptionVariant encryption, InStream.StreamOptions compression, OrcProto.Footer footer) throws IOException {
        Key key = encryption.getFileFooterKey();
        if (key == null) {
            return null;
        }
        OrcProto.EncryptionVariant protoVariant = footer.getEncryption().getVariants(encryption.getVariantId());
        byte[] bytes = protoVariant.getFileStatistics().toByteArray();
        BufferChunk buffer = new BufferChunk(ByteBuffer.wrap(bytes), 0L);
        EncryptionAlgorithm algorithm = encryption.getKeyDescription().getAlgorithm();
        byte[] iv = new byte[algorithm.getIvLength()];
        CryptoUtils.modifyIvForStream(encryption.getRoot().getId(), OrcProto.Stream.Kind.FILE_STATISTICS, footer.getStripesCount() + 1).accept(iv);
        InStream.StreamOptions options = new InStream.StreamOptions(compression).withEncryption(algorithm, key, iv);
        InStream in = InStream.create("encrypted file stats", buffer, 0L, bytes.length, options);
        OrcProto.FileStatistics decrypted = OrcProto.FileStatistics.parseFrom(in);
        ColumnStatistics[] result = new ColumnStatistics[decrypted.getColumnCount()];
        TypeDescription root = encryption.getRoot();
        for (int i = 0; i < result.length; ++i) {
            result[i] = ColumnStatisticsImpl.deserialize(root.findSubtype(root.getId() + i), decrypted.getColumn(i), this.writerUsedProlepticGregorian(), this.getConvertToProlepticGregorian());
        }
        return result;
    }

    public ColumnStatistics[] deserializeStats(TypeDescription schema, List<OrcProto.ColumnStatistics> fileStats) {
        ColumnStatistics[] result = new ColumnStatistics[fileStats.size()];
        for (int i = 0; i < result.length; ++i) {
            TypeDescription subschema = schema == null ? null : schema.findSubtype(i);
            result[i] = ColumnStatisticsImpl.deserialize(subschema, fileStats.get(i), this.writerUsedProlepticGregorian(), this.getConvertToProlepticGregorian());
        }
        return result;
    }

    @Override
    public TypeDescription getSchema() {
        return this.schema;
    }

    protected static void ensureOrcFooter(FSDataInputStream in, Path path, int psLen, ByteBuffer buffer) throws IOException {
        int magicLength = "ORC".length();
        int fullLength = magicLength + 1;
        if (psLen < fullLength || buffer.remaining() < fullLength) {
            throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - fullLength;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)magicLength).equals("ORC")) {
            byte[] header = new byte[magicLength];
            in.readFully(0L, header, 0, magicLength);
            if (!Text.decode((byte[])header, (int)0, (int)magicLength).equals("ORC")) {
                throw new FileFormatException("Malformed ORC file " + path + ". Invalid postscript.");
            }
        }
    }

    protected static void ensureOrcFooter(ByteBuffer buffer, int psLen) throws IOException {
        int magicLength = "ORC".length();
        int fullLength = magicLength + 1;
        if (psLen < fullLength || buffer.remaining() < fullLength) {
            throw new FileFormatException("Malformed ORC file. Invalid postscript length " + psLen);
        }
        int offset = buffer.arrayOffset() + buffer.position() + buffer.limit() - fullLength;
        byte[] array = buffer.array();
        if (!Text.decode((byte[])array, (int)offset, (int)magicLength).equals("ORC") && !Text.decode((byte[])buffer.array(), (int)0, (int)magicLength).equals("ORC")) {
            throw new FileFormatException("Malformed ORC file. Invalid postscript length " + psLen);
        }
    }

    private static String versionString(List<Integer> version) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < version.size(); ++i) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(version.get(i));
        }
        return buffer.toString();
    }

    protected static void checkOrcVersion(Path path, OrcProto.PostScript postscript) throws IOException {
        List<Integer> version = postscript.getVersionList();
        if (ReaderImpl.getFileVersion(version) == OrcFile.Version.FUTURE) {
            throw new IOException(path + " was written by a future ORC version " + ReaderImpl.versionString(version) + ". This file is not readable by this version of ORC.\nPostscript: " + TextFormat.shortDebugString(postscript));
        }
    }

    public ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        this.path = path;
        this.options = options;
        this.conf = options.getConfiguration();
        this.maxLength = options.getMaxLength();
        this.useUTCTimestamp = options.getUseUTCTimestamp();
        FileMetadata fileMetadata = options.getFileMetadata();
        if (fileMetadata != null) {
            this.compressionKind = fileMetadata.getCompressionKind();
            this.bufferSize = fileMetadata.getCompressionBufferSize();
            this.metadataSize = fileMetadata.getMetadataSize();
            this.stripeStatistics = fileMetadata.getStripeStats();
            this.versionList = fileMetadata.getVersionList();
            OrcFile.WriterImplementation writer = OrcFile.WriterImplementation.from(fileMetadata.getWriterImplementation());
            this.writerVersion = OrcFile.WriterVersion.from(writer, fileMetadata.getWriterVersionNum());
            List<OrcProto.Type> types = fileMetadata.getTypes();
            OrcUtils.isValidTypeTree(types, 0);
            this.schema = OrcUtils.convertTypeFromProtobuf(types, 0);
            this.rowIndexStride = fileMetadata.getRowIndexStride();
            this.contentLength = fileMetadata.getContentLength();
            this.numberOfRows = fileMetadata.getNumberOfRows();
            this.fileStats = fileMetadata.getFileStats();
            this.stripes = fileMetadata.getStripes();
            this.tail = null;
            this.userMetadata = null;
            this.encryption = new ReaderEncryption();
            this.softwareVersion = null;
        } else {
            OrcTail orcTail = options.getOrcTail();
            if (orcTail == null) {
                this.tail = this.extractFileTail(this.getFileSystem(), path, options.getMaxLength());
                options.orcTail(this.tail);
            } else {
                ReaderImpl.checkOrcVersion(path, orcTail.getPostScript());
                this.tail = orcTail;
            }
            this.compressionKind = this.tail.getCompressionKind();
            this.bufferSize = this.tail.getCompressionBufferSize();
            this.metadataSize = this.tail.getMetadataSize();
            this.versionList = this.tail.getPostScript().getVersionList();
            this.schema = this.tail.getSchema();
            this.rowIndexStride = this.tail.getFooter().getRowIndexStride();
            this.contentLength = this.tail.getFooter().getContentLength();
            this.numberOfRows = this.tail.getFooter().getNumberOfRows();
            this.userMetadata = this.tail.getFooter().getMetadataList();
            this.fileStats = this.tail.getFooter().getStatisticsList();
            this.writerVersion = this.tail.getWriterVersion();
            this.stripes = this.tail.getStripes();
            this.stripeStatistics = null;
            OrcProto.Footer footer = this.tail.getFooter();
            this.encryption = new ReaderEncryption(footer, this.schema, this.tail.getStripeStatisticsOffset(), this.tail.getTailBuffer(), this.stripes, options.getKeyProvider(), this.conf);
            this.softwareVersion = OrcUtils.getSoftwareVersion(footer.getWriter(), footer.getSoftwareVersion());
        }
        this.types = OrcUtils.getOrcTypes(this.schema);
    }

    protected FileSystem getFileSystem() throws IOException {
        FileSystem fileSystem = this.options.getFilesystem();
        if (fileSystem == null) {
            fileSystem = this.path.getFileSystem(this.options.getConfiguration());
            this.options.filesystem(fileSystem);
        }
        return fileSystem;
    }

    protected Supplier<FileSystem> getFileSystemSupplier() {
        return () -> {
            try {
                return this.getFileSystem();
            }
            catch (IOException e) {
                throw new RuntimeException("Can't create filesystem", e);
            }
        };
    }

    public static OrcFile.WriterVersion getWriterVersion(int writerVersion) {
        for (OrcFile.WriterVersion version : OrcFile.WriterVersion.values()) {
            if (version.getId() != writerVersion) continue;
            return version;
        }
        return OrcFile.WriterVersion.FUTURE;
    }

    public static OrcProto.Metadata extractMetadata(ByteBuffer bb, int metadataAbsPos, int metadataSize, InStream.StreamOptions options) throws IOException {
        bb.position(metadataAbsPos);
        bb.limit(metadataAbsPos + metadataSize);
        return OrcProto.Metadata.parseFrom(InStream.createCodedInputStream(InStream.create("metadata", new BufferChunk(bb, 0L), 0L, metadataSize, options)));
    }

    private static OrcProto.PostScript extractPostScript(BufferChunk buffer, Path path, int psLen, long psOffset) throws IOException {
        CodedInputStream in = InStream.createCodedInputStream(InStream.create("ps", buffer, psOffset, psLen));
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(in);
        ReaderImpl.checkOrcVersion(path, ps);
        switch (ps.getCompression()) {
            case NONE: 
            case ZLIB: 
            case SNAPPY: 
            case LZO: 
            case LZ4: 
            case ZSTD: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compression");
            }
        }
        return ps;
    }

    OrcTail buildEmptyTail() throws IOException {
        OrcProto.PostScript.Builder postscript = OrcProto.PostScript.newBuilder();
        OrcFile.Version version = OrcFile.Version.CURRENT;
        postscript.setMagic("ORC").setCompression(OrcProto.CompressionKind.NONE).setFooterLength(0L).addVersion(version.getMajor()).addVersion(version.getMinor()).setMetadataLength(0L).setWriterVersion(OrcFile.CURRENT_WRITER.getId());
        OrcProto.Type.Builder struct = OrcProto.Type.newBuilder();
        struct.setKind(OrcProto.Type.Kind.STRUCT);
        OrcProto.Footer.Builder footer = OrcProto.Footer.newBuilder();
        footer.setHeaderLength(0L).setContentLength(0L).addTypes(struct).setNumberOfRows(0L).setRowIndexStride(0);
        OrcProto.FileTail.Builder result = OrcProto.FileTail.newBuilder();
        result.setFooter(footer);
        result.setPostscript(postscript);
        result.setFileLength(0L);
        result.setPostscriptLength(0L);
        return new OrcTail(result.build(), new BufferChunk(0L, 0), -1L, this);
    }

    private static void read(FSDataInputStream file, BufferChunk chunks) throws IOException {
        while (chunks != null) {
            if (!chunks.hasData()) {
                int len = chunks.getLength();
                ByteBuffer bb = ByteBuffer.allocate(len);
                file.readFully(chunks.getOffset(), bb.array(), bb.arrayOffset(), len);
                chunks.setChunk(bb);
            }
            chunks = (BufferChunk)chunks.next;
        }
    }

    public static OrcTail extractFileTail(ByteBuffer buffer) throws IOException {
        return ReaderImpl.extractFileTail(buffer, -1L, -1L);
    }

    public static int getCompressionBlockSize(OrcProto.PostScript postScript) {
        if (postScript.hasCompressionBlockSize()) {
            return (int)postScript.getCompressionBlockSize();
        }
        return 262144;
    }

    public static OrcTail extractFileTail(ByteBuffer buffer, long fileLen, long modificationTime) throws IOException {
        long readSize = buffer.limit();
        OrcProto.FileTail.Builder fileTailBuilder = OrcProto.FileTail.newBuilder();
        fileTailBuilder.setFileLength(fileLen != -1L ? fileLen : readSize);
        int psLen = buffer.get((int)(readSize - 1L)) & 0xFF;
        int psOffset = (int)(readSize - 1L - (long)psLen);
        ReaderImpl.ensureOrcFooter(buffer, psLen);
        byte[] psBuffer = new byte[psLen];
        System.arraycopy(buffer.array(), psOffset, psBuffer, 0, psLen);
        OrcProto.PostScript ps = OrcProto.PostScript.parseFrom(psBuffer);
        int footerSize = (int)ps.getFooterLength();
        CompressionKind compressionKind = CompressionKind.valueOf(ps.getCompression().name());
        fileTailBuilder.setPostscriptLength(psLen).setPostscript(ps);
        InStream.StreamOptions compression = new InStream.StreamOptions();
        try (CompressionCodec codec = OrcCodecPool.getCodec(compressionKind);){
            if (codec != null) {
                compression.withCodec(codec).withBufferSize(ReaderImpl.getCompressionBlockSize(ps));
            }
            OrcProto.Footer footer = OrcProto.Footer.parseFrom(InStream.createCodedInputStream(InStream.create("footer", new BufferChunk(buffer, 0L), psOffset - footerSize, footerSize, compression)));
            fileTailBuilder.setPostscriptLength(psLen).setFooter(footer);
        }
        buffer.clear();
        return new OrcTail(fileTailBuilder.build(), new BufferChunk(buffer.slice(), 0L), modificationTime);
    }

    protected OrcTail extractFileTail(FileSystem fs, Path path, long maxFileLength) throws IOException {
        BufferChunk buffer;
        long modificationTime;
        OrcProto.FileTail.Builder fileTailBuilder = OrcProto.FileTail.newBuilder();
        this.file = fs.open(path);
        try {
            long size;
            if (maxFileLength == Long.MAX_VALUE) {
                FileStatus fileStatus = fs.getFileStatus(path);
                size = fileStatus.getLen();
                modificationTime = fileStatus.getModificationTime();
            } else {
                size = maxFileLength;
                modificationTime = -1L;
            }
            if (size == 0L) {
                return this.buildEmptyTail();
            }
            if (size <= (long)"ORC".length()) {
                throw new FileFormatException("Not a valid ORC file " + path + " (maxFileLength= " + maxFileLength + ")");
            }
            fileTailBuilder.setFileLength(size);
            int readSize = (int)Math.min(size, 16384L);
            buffer = new BufferChunk(size - (long)readSize, readSize);
            ReaderImpl.read(this.file, buffer);
            ByteBuffer bb = buffer.getData();
            int psLen = bb.get(readSize - 1) & 0xFF;
            ReaderImpl.ensureOrcFooter(this.file, path, psLen, bb);
            long psOffset = size - 1L - (long)psLen;
            OrcProto.PostScript ps = ReaderImpl.extractPostScript(buffer, path, psLen, psOffset);
            CompressionKind compressionKind = CompressionKind.valueOf(ps.getCompression().name());
            fileTailBuilder.setPostscriptLength(psLen).setPostscript(ps);
            int footerSize = (int)ps.getFooterLength();
            int metadataSize = (int)ps.getMetadataLength();
            int stripeStatSize = (int)ps.getStripeStatisticsLength();
            int tailSize = 1 + psLen + footerSize + metadataSize + stripeStatSize;
            int extra = Math.max(0, tailSize - readSize);
            if (extra > 0) {
                BufferChunk orig = buffer;
                buffer = new BufferChunk(size - (long)tailSize, extra);
                buffer.next = orig;
                orig.prev = buffer;
                ReaderImpl.read(this.file, buffer);
            }
            InStream.StreamOptions compression = new InStream.StreamOptions();
            try (CompressionCodec codec = OrcCodecPool.getCodec(compressionKind);){
                if (codec != null) {
                    compression.withCodec(codec).withBufferSize(ReaderImpl.getCompressionBlockSize(ps));
                }
                OrcProto.Footer footer = OrcProto.Footer.parseFrom(InStream.createCodedInputStream(InStream.create("footer", buffer, psOffset - (long)footerSize, footerSize, compression)));
                fileTailBuilder.setFooter(footer);
            }
        }
        catch (Throwable thr) {
            try {
                this.close();
            }
            catch (IOException except) {
                LOG.info("Ignoring secondary exception in close of " + path, (Throwable)except);
            }
            throw thr instanceof IOException ? (IOException)thr : new IOException("Problem reading file footer " + path, thr);
        }
        return new OrcTail(fileTailBuilder.build(), buffer, modificationTime, this);
    }

    @Override
    public ByteBuffer getSerializedFileFooter() {
        return this.tail.getSerializedTail();
    }

    @Override
    public boolean writerUsedProlepticGregorian() {
        OrcProto.Footer footer = this.tail.getFooter();
        return footer.hasCalendar() ? footer.getCalendar() == OrcProto.CalendarKind.PROLEPTIC_GREGORIAN : OrcConf.PROLEPTIC_GREGORIAN_DEFAULT.getBoolean(this.conf);
    }

    @Override
    public boolean getConvertToProlepticGregorian() {
        return this.options.getConvertToProlepticGregorian();
    }

    @Override
    public Reader.Options options() {
        return new Reader.Options(this.conf);
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rows(this.options());
    }

    @Override
    public RecordReader rows(Reader.Options options) throws IOException {
        LOG.info("Reading ORC rows from " + this.path + " with " + options);
        return new RecordReaderImpl(this, options);
    }

    @Override
    public long getRawDataSize() {
        if (this.deserializedSize == -1L) {
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (int i = 0; i < this.fileStats.size(); ++i) {
                indices.add(i);
            }
            this.deserializedSize = this.getRawDataSizeFromColIndices(indices);
        }
        return this.deserializedSize;
    }

    @Override
    public long getRawDataSizeFromColIndices(List<Integer> colIndices) {
        boolean[] include = new boolean[this.schema.getMaximumId() + 1];
        for (Integer rootId : colIndices) {
            TypeDescription root = this.schema.findSubtype(rootId);
            for (int c = root.getId(); c <= root.getMaximumId(); ++c) {
                include[c] = true;
            }
        }
        return ReaderImpl.getRawDataSizeFromColIndices(include, this.schema, this.fileStats);
    }

    public static long getRawDataSizeFromColIndices(List<Integer> colIndices, List<OrcProto.Type> types, List<OrcProto.ColumnStatistics> stats) throws FileFormatException {
        TypeDescription schema = OrcUtils.convertTypeFromProtobuf(types, 0);
        boolean[] include = new boolean[schema.getMaximumId() + 1];
        for (Integer rootId : colIndices) {
            TypeDescription root = schema.findSubtype(rootId);
            for (int c = root.getId(); c <= root.getMaximumId(); ++c) {
                include[c] = true;
            }
        }
        return ReaderImpl.getRawDataSizeFromColIndices(include, schema, stats);
    }

    static long getRawDataSizeFromColIndices(boolean[] include, TypeDescription schema, List<OrcProto.ColumnStatistics> stats) {
        long result = 0L;
        for (int c = schema.getId(); c <= schema.getMaximumId(); ++c) {
            if (!include[c]) continue;
            result += ReaderImpl.getRawDataSizeOfColumn(schema.findSubtype(c), stats);
        }
        return result;
    }

    private static long getRawDataSizeOfColumn(TypeDescription column, List<OrcProto.ColumnStatistics> stats) {
        OrcProto.ColumnStatistics colStat = stats.get(column.getId());
        long numVals = colStat.getNumberOfValues();
        switch (column.getCategory()) {
            case BINARY: {
                return colStat.getBinaryStatistics().getSum();
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                numVals = numVals == 0L ? 1L : numVals;
                int avgStrLen = (int)(colStat.getStringStatistics().getSum() / numVals);
                return numVals * (long)JavaDataModel.get().lengthForStringOfLength(avgStrLen);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return numVals * (long)JavaDataModel.get().lengthOfTimestamp();
            }
            case DATE: {
                return numVals * (long)JavaDataModel.get().lengthOfDate();
            }
            case DECIMAL: {
                return numVals * (long)JavaDataModel.get().lengthOfDecimal();
            }
            case DOUBLE: 
            case LONG: {
                return numVals * (long)JavaDataModel.get().primitive2();
            }
            case FLOAT: 
            case INT: 
            case SHORT: 
            case BOOLEAN: 
            case BYTE: 
            case STRUCT: 
            case UNION: 
            case MAP: 
            case LIST: {
                return numVals * (long)JavaDataModel.get().primitive1();
            }
        }
        LOG.debug("Unknown primitive category: {}", (Object)column.getCategory());
        return 0L;
    }

    @Override
    public long getRawDataSizeOfColumns(List<String> colNames) {
        boolean[] include = new boolean[this.schema.getMaximumId() + 1];
        for (String name : colNames) {
            TypeDescription sub = this.schema.findSubtype(name);
            for (int c = sub.getId(); c <= sub.getMaximumId(); ++c) {
                include[c] = true;
            }
        }
        return ReaderImpl.getRawDataSizeFromColIndices(include, this.schema, this.fileStats);
    }

    @Override
    public List<OrcProto.StripeStatistics> getOrcProtoStripeStatistics() {
        if (this.stripeStatistics == null) {
            try (CompressionCodec codec = OrcCodecPool.getCodec(this.compressionKind);){
                InStream.StreamOptions options = new InStream.StreamOptions();
                if (codec != null) {
                    options.withCodec(codec).withBufferSize(this.bufferSize);
                }
                this.stripeStatistics = ReaderImpl.deserializeStripeStats(this.tail.getTailBuffer(), this.tail.getMetadataOffset(), this.tail.getMetadataSize(), options);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Can't deserialize stripe stats", ioe);
            }
        }
        return this.stripeStatistics;
    }

    @Override
    public List<OrcProto.ColumnStatistics> getOrcProtoFileStatistics() {
        return this.fileStats;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<OrcProto.StripeStatistics> deserializeStripeStats(BufferChunk tailBuffer, long offset, int length, InStream.StreamOptions options) throws IOException {
        try (InStream stream = InStream.create("stripe stats", tailBuffer, offset, length, options);){
            OrcProto.Metadata meta = OrcProto.Metadata.parseFrom(InStream.createCodedInputStream(stream));
            List<OrcProto.StripeStatistics> list = meta.getStripeStatsList();
            return list;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.warn("Failed to parse stripe statistics", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<StripeStatistics> convertFromProto(List<OrcProto.StripeStatistics> list) {
        if (list == null) {
            return null;
        }
        ArrayList<StripeStatistics> result = new ArrayList<StripeStatistics>(list.size());
        for (OrcProto.StripeStatistics ss : this.stripeStatistics) {
            result.add(new StripeStatisticsImpl(this.schema, new ArrayList<OrcProto.ColumnStatistics>(ss.getColStatsList()), this.writerUsedProlepticGregorian(), this.getConvertToProlepticGregorian()));
        }
        return result;
    }

    @Override
    public List<StripeStatistics> getStripeStatistics() throws IOException {
        return this.getStripeStatistics(null);
    }

    @Override
    public List<StripeStatistics> getStripeStatistics(boolean[] included) throws IOException {
        List<StripeStatistics> result = this.convertFromProto(this.stripeStatistics);
        if (result == null || this.encryption.getVariants().length > 0) {
            try (CompressionCodec codec = OrcCodecPool.getCodec(this.compressionKind);){
                InStream.StreamOptions options = new InStream.StreamOptions();
                if (codec != null) {
                    options.withCodec(codec).withBufferSize(this.bufferSize);
                }
                result = this.getVariantStripeStatistics(null);
                if (this.encryption.getVariants().length > 0) {
                    for (int c = this.schema.getId(); c <= this.schema.getMaximumId(); ++c) {
                        ReaderEncryptionVariant variant;
                        if (included != null && !included[c] || (variant = this.encryption.getVariant(c)) == null) continue;
                        TypeDescription variantType = variant.getRoot();
                        List<StripeStatistics> colStats = variant.getStripeStatistics(included, options, this);
                        for (int sub = c; sub <= variantType.getMaximumId(); ++sub) {
                            if (included != null && !included[sub]) continue;
                            for (int s = 0; s < colStats.size(); ++s) {
                                StripeStatisticsImpl resultElem = (StripeStatisticsImpl)result.get(s);
                                resultElem.updateColumn(sub, colStats.get(s).getColumn(sub - variantType.getId()));
                            }
                        }
                        c = variantType.getMaximumId();
                    }
                }
            }
        }
        return result;
    }

    @Override
    public List<Integer> getVersionList() {
        return this.versionList;
    }

    @Override
    public int getMetadataSize() {
        return this.metadataSize;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("ORC Reader(");
        buffer.append(this.path);
        if (this.maxLength != -1L) {
            buffer.append(", ");
            buffer.append(this.maxLength);
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.file != null) {
            this.file.close();
        }
    }

    public FSDataInputStream takeFile() {
        FSDataInputStream result = this.file;
        this.file = null;
        return result;
    }

    public static class StripeInformationImpl
    implements StripeInformation {
        private final long stripeId;
        private final long originalStripeId;
        private final byte[][] encryptedKeys;
        private final OrcProto.StripeInformation stripe;

        public StripeInformationImpl(OrcProto.StripeInformation stripe, long stripeId, long previousOriginalStripeId, byte[][] previousKeys) {
            this.stripe = stripe;
            this.stripeId = stripeId;
            this.originalStripeId = stripe.hasEncryptStripeId() ? stripe.getEncryptStripeId() : previousOriginalStripeId + 1L;
            if (stripe.getEncryptedLocalKeysCount() != 0) {
                this.encryptedKeys = new byte[stripe.getEncryptedLocalKeysCount()][];
                for (int v = 0; v < this.encryptedKeys.length; ++v) {
                    this.encryptedKeys[v] = stripe.getEncryptedLocalKeys(v).toByteArray();
                }
            } else {
                this.encryptedKeys = previousKeys;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StripeInformationImpl that = (StripeInformationImpl)o;
            return this.stripeId == that.stripeId && this.originalStripeId == that.originalStripeId && Arrays.deepEquals((Object[])this.encryptedKeys, (Object[])that.encryptedKeys) && this.stripe.equals(that.stripe);
        }

        public int hashCode() {
            int result = Objects.hash(this.stripeId, this.originalStripeId, this.stripe);
            result = 31 * result + Arrays.hashCode((Object[])this.encryptedKeys);
            return result;
        }

        @Override
        public long getOffset() {
            return this.stripe.getOffset();
        }

        @Override
        public long getLength() {
            return this.stripe.getDataLength() + this.getIndexLength() + this.getFooterLength();
        }

        @Override
        public long getDataLength() {
            return this.stripe.getDataLength();
        }

        @Override
        public long getFooterLength() {
            return this.stripe.getFooterLength();
        }

        @Override
        public long getIndexLength() {
            return this.stripe.getIndexLength();
        }

        @Override
        public long getNumberOfRows() {
            return this.stripe.getNumberOfRows();
        }

        @Override
        public long getStripeId() {
            return this.stripeId;
        }

        @Override
        public boolean hasEncryptionStripeId() {
            return this.stripe.hasEncryptStripeId();
        }

        @Override
        public long getEncryptionStripeId() {
            return this.originalStripeId;
        }

        @Override
        public byte[][] getEncryptedLocalKeys() {
            return this.encryptedKeys;
        }

        public String toString() {
            return "offset: " + this.getOffset() + " data: " + this.getDataLength() + " rows: " + this.getNumberOfRows() + " tail: " + this.getFooterLength() + " index: " + this.getIndexLength() + (!this.hasEncryptionStripeId() || this.stripeId == this.originalStripeId - 1L ? "" : " encryption id: " + this.originalStripeId);
        }
    }
}

