/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.http.HttpServer;
import org.apache.hive.service.server.HiveServer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HS2LeadershipStatus
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(HS2LeadershipStatus.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = this.getServletContext();
        if (!HttpServer.isInstrumentationAccessAllowed(context, request, response)) {
            LOG.warn("Unauthorized to perform GET action. remoteUser: {}", (Object)request.getRemoteUser());
            return;
        }
        this.setResponseHeaders(response);
        ServletContext ctx = this.getServletContext();
        AtomicBoolean isLeader = (AtomicBoolean)ctx.getAttribute("hs2.isLeader");
        LOG.info("Returning isLeader: {}", (Object)isLeader);
        ObjectMapper mapper = new ObjectMapper();
        mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)response.getWriter(), (Object)isLeader);
        response.setStatus(200);
        response.flushBuffer();
    }

    private void setResponseHeaders(HttpServletResponse response) {
        response.setContentType("application/json; charset=utf8");
        response.setHeader("Access-Control-Allow-Methods", "GET,DELETE");
        response.setHeader("Access-Control-Allow-Origin", "*");
    }

    public void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = this.getServletContext();
        if (!HttpServer.isInstrumentationAccessAllowedStrict(context, request, response)) {
            LOG.warn("Unauthorized to perform DELETE action. remoteUser: {}", (Object)request.getRemoteUser());
            return;
        }
        this.setResponseHeaders(response);
        LOG.info("DELETE handler invoked for failover..");
        ObjectMapper mapper = new ObjectMapper();
        FailoverResponse failoverResponse = new FailoverResponse();
        AtomicBoolean isLeader = (AtomicBoolean)context.getAttribute("hs2.isLeader");
        if (!isLeader.get()) {
            String msg = "Cannot failover an instance that is not a leader";
            LOG.info(msg);
            failoverResponse.setSuccess(false);
            failoverResponse.setMessage(msg);
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)response.getWriter(), (Object)failoverResponse);
            response.setStatus(403);
            return;
        }
        HiveServer2.FailoverHandlerCallback failoverHandler = (HiveServer2.FailoverHandlerCallback)context.getAttribute("hs2.failover.callback");
        try {
            String msg = "Failover successful!";
            LOG.info(msg);
            failoverHandler.failover();
            failoverResponse.setSuccess(true);
            failoverResponse.setMessage(msg);
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)response.getWriter(), (Object)failoverResponse);
            response.setStatus(200);
        }
        catch (Exception e) {
            String errMsg = "Cannot perform failover of HS2 instance. err: " + e.getMessage();
            LOG.error(errMsg, e);
            failoverResponse.setSuccess(false);
            failoverResponse.setMessage(errMsg);
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)response.getWriter(), (Object)failoverResponse);
            response.setStatus(500);
        }
    }

    private class FailoverResponse {
        private boolean success;
        private String message;

        FailoverResponse() {
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

