/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.io.SessionStream;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorException;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.service.ServiceUtils;
import org.apache.hive.service.cli.FetchOrientation;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.RowSetFactory;
import org.apache.hive.service.cli.TableSchema;
import org.apache.hive.service.cli.operation.ExecuteStatementOperation;
import org.apache.hive.service.cli.session.HiveSession;

public class HiveCommandOperation
extends ExecuteStatementOperation {
    private final CommandProcessor commandProcessor;
    private TableSchema resultSchema = null;
    private BufferedReader resultReader;

    protected HiveCommandOperation(HiveSession parentSession, String statement, CommandProcessor commandProcessor, Map<String, String> confOverlay) {
        super(parentSession, statement, confOverlay);
        this.commandProcessor = commandProcessor;
        this.setupSessionIO(parentSession.getSessionState());
    }

    private void setupSessionIO(SessionState sessionState) {
        try {
            this.log.info("Putting temp output to file " + sessionState.getTmpOutputFile() + " and error output to file " + sessionState.getTmpErrOutputFile());
            sessionState.in = null;
            sessionState.out = new SessionStream((OutputStream)new FileOutputStream(sessionState.getTmpOutputFile()), true, StandardCharsets.UTF_8.name());
            sessionState.err = new SessionStream((OutputStream)new FileOutputStream(sessionState.getTmpErrOutputFile()), true, StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            this.log.error("Error in creating temp output file", e);
            ServiceUtils.cleanup(this.log, this.parentSession.getSessionState().out, this.parentSession.getSessionState().err);
            try {
                sessionState.in = null;
                sessionState.out = new SessionStream((OutputStream)System.out, true, StandardCharsets.UTF_8.name());
                sessionState.err = new SessionStream((OutputStream)System.err, true, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException ee) {
                this.log.error("Error creating PrintStream", e);
                sessionState.out = null;
                sessionState.err = null;
            }
        }
    }

    private void tearDownSessionIO() {
        ServiceUtils.cleanup(this.log, this.parentSession.getSessionState().out, this.parentSession.getSessionState().err);
    }

    @Override
    public void runInternal() throws HiveSQLException {
        this.setState(OperationState.RUNNING);
        try {
            String command = this.getStatement().trim();
            String[] tokens = command.split("\\s");
            String commandArgs = command.substring(tokens[0].length()).trim();
            CommandProcessorResponse response = this.commandProcessor.run(commandArgs);
            Schema schema = response.getSchema();
            if (schema != null) {
                this.setHasResultSet(true);
                this.resultSchema = new TableSchema(schema);
            } else {
                this.setHasResultSet(false);
                this.resultSchema = new TableSchema();
            }
            if (response.getMessage() != null) {
                this.log.info(response.getMessage());
            }
        }
        catch (CommandProcessorException e) {
            this.setState(OperationState.ERROR);
            throw this.toSQLException("Error while processing statement", e);
        }
        catch (Exception e) {
            this.setState(OperationState.ERROR);
            throw new HiveSQLException("Error running query: " + e.toString(), e);
        }
        this.setState(OperationState.FINISHED);
    }

    @Override
    public void close() throws HiveSQLException {
        this.setState(OperationState.CLOSED);
        this.tearDownSessionIO();
        this.cleanTmpFile();
        this.cleanupOperationLog(0L);
    }

    @Override
    public TableSchema getResultSetSchema() throws HiveSQLException {
        return this.resultSchema;
    }

    @Override
    public RowSet getNextRowSet(FetchOrientation orientation, long maxRows) throws HiveSQLException {
        this.validateDefaultFetchOrientation(orientation);
        if (orientation.equals((Object)FetchOrientation.FETCH_FIRST)) {
            this.resetResultReader();
        }
        List<String> rows = this.readResults((int)maxRows);
        RowSet rowSet = RowSetFactory.create(this.resultSchema, this.getProtocolVersion(), false);
        if (this.resultSchema != null && this.resultSchema.getSize() > 1) {
            for (String row : rows) {
                rowSet.addRow(row.split("\\t"));
            }
        } else {
            for (String row : rows) {
                rowSet.addRow(new String[]{row});
            }
        }
        return rowSet;
    }

    private List<String> readResults(int nLines) throws HiveSQLException {
        if (this.resultReader == null) {
            SessionState sessionState = this.getParentSession().getSessionState();
            File tmp = sessionState.getTmpOutputFile();
            try {
                this.resultReader = new BufferedReader(new FileReader(tmp));
            }
            catch (FileNotFoundException e) {
                throw new HiveSQLException("File " + tmp + " not found", e);
            }
        }
        ArrayList<String> results = new ArrayList<String>();
        for (int i = 0; i < nLines || nLines <= 0; ++i) {
            try {
                String line = this.resultReader.readLine();
                if (line == null) break;
                results.add(line);
                continue;
            }
            catch (IOException e) {
                throw new HiveSQLException("Unable to read line from file", e);
            }
        }
        return results;
    }

    private void cleanTmpFile() {
        this.resetResultReader();
        SessionState sessionState = this.getParentSession().getSessionState();
        sessionState.deleteTmpOutputFile();
        sessionState.deleteTmpErrOutputFile();
    }

    private void resetResultReader() {
        if (this.resultReader != null) {
            ServiceUtils.cleanup(this.log, this.resultReader);
            this.resultReader = null;
        }
    }

    @Override
    public void cancel(OperationState stateAfterCancel) throws HiveSQLException {
        throw new UnsupportedOperationException("HiveCommandOperation.cancel()");
    }
}

