/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.security.Security;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthenticationException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.apache.hive.org.apache.thrift.TProcessor;
import org.apache.hive.org.apache.thrift.TProcessorFactory;
import org.apache.hive.org.apache.thrift.transport.TSaslClientTransport;
import org.apache.hive.org.apache.thrift.transport.TSaslServerTransport;
import org.apache.hive.org.apache.thrift.transport.TSocket;
import org.apache.hive.org.apache.thrift.transport.TTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.apache.hive.org.apache.thrift.transport.TTransportFactory;
import org.apache.hive.service.auth.AuthenticationProviderFactory;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;
import org.apache.hive.service.auth.PlainSaslServer;
import org.apache.hive.service.auth.TSetIpAddressProcessor;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlainSaslHelper {
    private static final Logger LOG = LoggerFactory.getLogger(PlainSaslHelper.class);

    public static TProcessorFactory getPlainProcessorFactory(TCLIService.Iface service) {
        return new SQLPlainProcessorFactory(service);
    }

    public static TTransportFactory getPlainTransportFactory(String authTypeStr) throws LoginException {
        TSaslServerTransport.Factory saslFactory = new TSaslServerTransport.Factory();
        try {
            saslFactory.addServerDefinition("PLAIN", authTypeStr, null, new HashMap<String, String>(), new PlainServerCallbackHandler(authTypeStr));
        }
        catch (AuthenticationException e) {
            throw new LoginException("Error setting callback handler" + e);
        }
        return saslFactory;
    }

    static TTransportFactory getDualPlainTransportFactory(TTransportFactory otherTrans, String trustedDomain) throws LoginException {
        LOG.info("Created additional transport factory for skipping authentication when client connection is from the same domain.");
        return new DualSaslTransportFactory(otherTrans, trustedDomain);
    }

    public static TTransport getPlainTransport(String username, String password, TTransport underlyingTransport) throws SaslException, TTransportException {
        return new TSaslClientTransport("PLAIN", null, null, null, new HashMap<String, String>(), new PlainCallbackHandler(username, password), underlyingTransport);
    }

    public static boolean isHostFromTrustedDomain(String remoteHost, String trustedDomain) {
        return remoteHost.endsWith(trustedDomain);
    }

    private PlainSaslHelper() {
        throw new UnsupportedOperationException("Can't initialize class");
    }

    static {
        Security.addProvider(new PlainSaslServer.SaslPlainProvider());
    }

    private static final class SQLPlainProcessorFactory
    extends TProcessorFactory {
        private final TCLIService.Iface service;

        SQLPlainProcessorFactory(TCLIService.Iface service) {
            super(null);
            this.service = service;
        }

        @Override
        public TProcessor getProcessor(TTransport trans) {
            return new TSetIpAddressProcessor(this.service);
        }
    }

    public static class PlainCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public PlainCallbackHandler(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passCallback = (PasswordCallback)callback;
                    passCallback.setPassword(this.password.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
        }
    }

    public static final class PlainServerCallbackHandler
    implements CallbackHandler {
        private final AuthenticationProviderFactory.AuthMethods authMethod;

        PlainServerCallbackHandler(String authMethodStr) throws AuthenticationException {
            this.authMethod = AuthenticationProviderFactory.AuthMethods.getValidAuthMethod(authMethodStr);
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            String username = null;
            String password = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    username = nc.getName();
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    password = new String(pc.getPassword());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback);
            }
            PasswdAuthenticationProvider provider = AuthenticationProviderFactory.getAuthenticationProvider(this.authMethod);
            try {
                provider.Authenticate(username, password);
            }
            catch (Exception e) {
                LOG.error("Login attempt is failed for user : " + username + ". Error Messsage : " + e.getMessage());
                throw e;
            }
            if (ac != null) {
                ac.setAuthorized(true);
            }
        }
    }

    static final class DualSaslTransportFactory
    extends TTransportFactory {
        TTransportFactory otherFactory;
        TTransportFactory noAuthFactory = PlainSaslHelper.getPlainTransportFactory(AuthenticationProviderFactory.AuthMethods.NONE.toString());
        String trustedDomain;

        DualSaslTransportFactory(TTransportFactory otherFactory, String trustedDomain) throws LoginException {
            this.otherFactory = otherFactory;
            this.trustedDomain = trustedDomain;
        }

        @Override
        public TTransport getTransport(TTransport trans) throws TTransportException {
            String remoteHost;
            TSocket tSocket = null;
            if (trans instanceof TSocket) {
                tSocket = (TSocket)trans;
            } else if (trans instanceof TSaslServerTransport) {
                TSaslServerTransport saslTrans = (TSaslServerTransport)trans;
                tSocket = (TSocket)saslTrans.getUnderlyingTransport();
            }
            String string = remoteHost = tSocket != null ? tSocket.getSocket().getInetAddress().getCanonicalHostName() : null;
            if (remoteHost != null && PlainSaslHelper.isHostFromTrustedDomain(remoteHost, this.trustedDomain)) {
                LOG.info("No authentication performed because the connecting host " + remoteHost + " is from the trusted domain " + this.trustedDomain);
                return this.noAuthFactory.getTransport(trans);
            }
            return this.otherFactory.getTransport(trans);
        }
    }
}

