/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.security.DBTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.MetastoreDelegationTokenManager;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hive.org.apache.thrift.TProcessorFactory;
import org.apache.hive.org.apache.thrift.transport.TSaslServerTransport;
import org.apache.hive.org.apache.thrift.transport.TTransportException;
import org.apache.hive.org.apache.thrift.transport.TTransportFactory;
import org.apache.hive.service.auth.AuthType;
import org.apache.hive.service.auth.HiveAuthConstants;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.rpc.thrift.TCLIService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthFactory.class);
    private HadoopThriftAuthBridge.Server saslServer;
    private final HiveConf conf;
    private final AuthType authType;
    private String hadoopAuth;
    private MetastoreDelegationTokenManager delegationTokenManager = null;

    public HiveAuthFactory(HiveConf conf, boolean isHttpMode) throws TTransportException {
        this.conf = conf;
        this.hadoopAuth = conf.get("hadoop.security.authentication", "simple");
        this.authType = AuthType.authTypeFromConf(conf, isHttpMode);
        if (this.isSASLWithKerberizedHadoop()) {
            this.saslServer = HadoopThriftAuthBridge.getBridge().createServer(conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL), conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_CLIENT_KERBEROS_PRINCIPAL));
            this.delegationTokenManager = new MetastoreDelegationTokenManager();
            try {
                Class<Hive> baseHandler = null;
                String tokenStoreClass = MetaStoreServerUtils.getTokenStoreClassName((Configuration)conf);
                if (tokenStoreClass.equals(DBTokenStore.class.getName())) {
                    baseHandler = Hive.class;
                }
                this.delegationTokenManager.startDelegationTokenSecretManager((Configuration)conf, baseHandler, HadoopThriftAuthBridge.Server.ServerMode.HIVESERVER2);
                this.saslServer.setSecretManager(this.delegationTokenManager.getSecretManager());
            }
            catch (IOException e) {
                throw new TTransportException("Failed to start token manager", (Throwable)e);
            }
        }
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        TTransportFactory transportFactory;
        String authTypeStr;
        if (this.isSASLWithKerberizedHadoop()) {
            TSaslServerTransport.Factory serverTransportFactory;
            try {
                serverTransportFactory = this.saslServer.createSaslServerTransportFactory(this.getSaslProperties());
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
            if (this.authType.isPasswordBasedAuthEnabled()) {
                authTypeStr = this.authType.getPasswordBasedAuthStr();
                try {
                    serverTransportFactory.addServerDefinition("PLAIN", authTypeStr, null, new HashMap<String, String>(), new PlainSaslHelper.PlainServerCallbackHandler(authTypeStr));
                }
                catch (AuthenticationException e) {
                    throw new LoginException("Error setting callback handler" + e);
                }
            }
            transportFactory = this.saslServer.wrapTransportFactory(serverTransportFactory);
        } else if (this.authType.isPasswordBasedAuthEnabled()) {
            authTypeStr = this.authType.getPasswordBasedAuthStr();
            transportFactory = PlainSaslHelper.getPlainTransportFactory(authTypeStr);
        } else if (this.authType.isEnabled(HiveAuthConstants.AuthTypes.NOSASL)) {
            transportFactory = new TTransportFactory();
        } else {
            throw new LoginException("Unsupported authentication type " + this.authType.getAuthTypes());
        }
        String trustedDomain = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_TRUSTED_DOMAIN).trim();
        if (!trustedDomain.isEmpty()) {
            transportFactory = PlainSaslHelper.getDualPlainTransportFactory(transportFactory, trustedDomain);
        }
        return transportFactory;
    }

    public TProcessorFactory getAuthProcFactory(TCLIService.Iface service) throws LoginException {
        if (this.isSASLWithKerberizedHadoop()) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        return this.saslServer == null ? null : this.saslServer.getRemoteUser();
    }

    public String getIpAddress() {
        if (this.saslServer == null || this.saslServer.getRemoteAddress() == null) {
            return null;
        }
        return this.saslServer.getRemoteAddress().getHostAddress();
    }

    public String getUserAuthMechanism() {
        return this.saslServer == null ? null : this.saslServer.getUserAuthMechanism();
    }

    public boolean isSASLWithKerberizedHadoop() {
        return "kerberos".equalsIgnoreCase(this.hadoopAuth) && !this.authType.isEnabled(HiveAuthConstants.AuthTypes.NOSASL);
    }

    public boolean isSASLKerberosUser() {
        return SaslRpcServer.AuthMethod.KERBEROS.getMechanismName().equals(this.getUserAuthMechanism()) || SaslRpcServer.AuthMethod.TOKEN.getMechanismName().equals(this.getUserAuthMechanism());
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 Kerberos principal or keytab is not correctly configured");
        }
        UserGroupInformation.loginUserFromKeytab(SecurityUtil.getServerPrincipal(principal, "0.0.0.0"), keyTabFile);
    }

    public static UserGroupInformation loginFromSpnegoKeytabAndReturnUGI(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 SPNEGO principal or keytab is not correctly configured");
        }
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI(SecurityUtil.getServerPrincipal(principal, "0.0.0.0"), keyTabFile);
    }

    public String getDelegationToken(String owner, String renewer, String remoteAddr) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            String tokenStr = this.delegationTokenManager.getDelegationTokenWithService(owner, renewer, "hiveserver2ClientToken", remoteAddr);
            if (tokenStr == null || tokenStr.isEmpty()) {
                throw new HiveSQLException("Received empty retrieving delegation token for user " + owner, "08S01");
            }
            return tokenStr;
        }
        catch (IOException e) {
            throw new HiveSQLException("Error retrieving delegation token for user " + owner, "08S01", e);
        }
        catch (InterruptedException e) {
            throw new HiveSQLException("delegation token retrieval interrupted", "08S01", e);
        }
    }

    public void cancelDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.delegationTokenManager.cancelDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error canceling delegation token " + delegationToken, "08S01", e);
        }
    }

    public void renewDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.delegationTokenManager.renewDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error renewing delegation token " + delegationToken, "08S01", e);
        }
    }

    public String verifyDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.delegationTokenManager.verifyDelegationToken(delegationToken);
        }
        catch (IOException e) {
            String msg = "Error verifying delegation token " + delegationToken;
            LOG.error(msg, e);
            throw new HiveSQLException(msg, "08S01", e);
        }
    }

    public String getUserFromToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.delegationTokenManager.getUserFromToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error extracting user from delegation token " + delegationToken, "08S01", e);
        }
    }

    public static void verifyProxyAccess(String realUser, String proxyUser, String ipAddress, HiveConf hiveConf) throws HiveSQLException {
        try {
            UserGroupInformation sessionUgi;
            if (UserGroupInformation.isSecurityEnabled()) {
                HadoopShims.KerberosNameShim kerbName = ShimLoader.getHadoopShims().getKerberosNameShim(realUser);
                sessionUgi = UserGroupInformation.createProxyUser(kerbName.getServiceName(), UserGroupInformation.getLoginUser());
            } else {
                sessionUgi = UserGroupInformation.createRemoteUser(realUser);
            }
            if (!proxyUser.equalsIgnoreCase(realUser)) {
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)hiveConf);
                ProxyUsers.authorize((UserGroupInformation)UserGroupInformation.createProxyUser(proxyUser, sessionUgi), (String)ipAddress, (Configuration)hiveConf);
            }
        }
        catch (IOException e) {
            throw new HiveSQLException("Failed to validate proxy privilege of " + realUser + " for " + proxyUser, "08S01", e);
        }
    }
}

