/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.curator.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.hive.org.apache.curator.shaded.com.google.common.base.Throwables;
import org.apache.hive.org.apache.curator.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtils.class);

    public static boolean checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
            return true;
        }
        return false;
    }

    public static ExecutorService newSingleThreadExecutor(String processName) {
        return Executors.newSingleThreadExecutor(ThreadUtils.newThreadFactory(processName));
    }

    public static ExecutorService newFixedThreadPool(int qty, String processName) {
        return Executors.newFixedThreadPool(qty, ThreadUtils.newThreadFactory(processName));
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String processName) {
        return Executors.newSingleThreadScheduledExecutor(ThreadUtils.newThreadFactory(processName));
    }

    public static ScheduledExecutorService newFixedThreadScheduledPool(int qty, String processName) {
        return Executors.newScheduledThreadPool(qty, ThreadUtils.newThreadFactory(processName));
    }

    public static ThreadFactory newThreadFactory(String processName) {
        return ThreadUtils.newGenericThreadFactory("Curator-" + processName);
    }

    public static ThreadFactory newGenericThreadFactory(String processName) {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Unexpected exception in thread: " + t, e);
                Throwables.propagate(e);
            }
        };
        return new ThreadFactoryBuilder().setNameFormat(processName + "-%d").setDaemon(true).setUncaughtExceptionHandler(uncaughtExceptionHandler).build();
    }

    public static String getProcessName(Class<?> clazz) {
        if (clazz.isAnonymousClass()) {
            return ThreadUtils.getProcessName(clazz.getEnclosingClass());
        }
        return clazz.getSimpleName();
    }
}

