/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hplsql;

import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hive.hplsql.Hplsql;

public class Utils {
    public static String unquoteString(String s2) {
        if (s2 == null) {
            return null;
        }
        int len = s2.length();
        StringBuilder s22 = new StringBuilder(len);
        boolean isEscape = true;
        for (int i = 0; i < len; ++i) {
            char ch2;
            char ch = s2.charAt(i);
            char c = ch2 = i < len - 1 ? s2.charAt(i + 1) : (char)'\u0000';
            if ((i == 0 || i == len - 1) && (ch == '\'' || ch == '\"')) continue;
            if (ch == '\\' && ch2 == '\'' || ch == '\'' && ch2 == '\'' && isEscape && i != len - 2) {
                isEscape = false;
                continue;
            }
            isEscape = true;
            s22.append(ch);
        }
        return s22.toString();
    }

    public static String quoteString(String s2) {
        if (s2 == null) {
            return null;
        }
        int len = s2.length();
        StringBuilder s22 = new StringBuilder(len + 2).append('\'');
        for (int i = 0; i < len; ++i) {
            char ch = s2.charAt(i);
            s22.append(ch);
            if (ch != '\'') continue;
            s22.append(ch);
        }
        s22.append('\'');
        return s22.toString();
    }

    public static String mergeQuotedStrings(String s1, String s2) {
        if (s1 == null || s2 == null) {
            return null;
        }
        int len1 = s1.length();
        int len2 = s2.length();
        if (len1 == 0 || len2 == 0) {
            return s1;
        }
        return s1.substring(0, len1 - 1) + s2.substring(1);
    }

    public static Date toDate(String s2) {
        int len = s2.length();
        if (len >= 10) {
            char c4 = s2.charAt(4);
            char c7 = s2.charAt(7);
            if (c4 == '-' && c7 == '-') {
                return Date.valueOf(s2.substring(0, 10));
            }
        }
        return null;
    }

    public static Timestamp toTimestamp(String s2) {
        int len = s2.length();
        if (len >= 10) {
            char c4 = s2.charAt(4);
            char c7 = s2.charAt(7);
            if (c4 == '-' && c7 == '-') {
                if (len > 19) {
                    if (s2.charAt(10) == '-') {
                        String s22 = s2.substring(0, 10) + ' ' + s2.substring(11, 13) + ':' + s2.substring(14, 16) + ':' + s2.substring(17);
                        return Timestamp.valueOf(s22);
                    }
                } else if (len == 10) {
                    s2 = s2 + " 00:00:00.000";
                }
                return Timestamp.valueOf(s2);
            }
        }
        return null;
    }

    public static String minMaxString(String s1, String s2, boolean max) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        int cmp = s1.compareTo(s2);
        if (max && cmp < 0 || !max && cmp > 0) {
            return s2;
        }
        return s1;
    }

    public static Long minMaxInt(Long i1, String s2, boolean max) {
        Long i2 = null;
        try {
            i2 = Long.parseLong(s2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        if (max && i1 < i2 || !max && i1 > i2) {
            return i2;
        }
        return i1;
    }

    public static Date minMaxDate(Date d1, String s2, boolean max) {
        Date d2 = Utils.toDate(s2);
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        if (max && d1.before(d2) || !max && d1.after(d2)) {
            return d2;
        }
        return d1;
    }

    public static String toString(String[] a, char del) {
        StringBuilder s2 = new StringBuilder();
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                s2.append(del);
            }
            s2.append(a[i]);
        }
        return s2.toString();
    }

    public static String convertSqlDatetimeFormat(String in) {
        StringBuilder out = new StringBuilder();
        int len = in.length();
        int i = 0;
        while (i < len) {
            if (i + 4 <= len && (in.substring(i, i + 4).compareTo("YYYY") == 0 || in.substring(i, i + 4).compareTo("yyyy") == 0)) {
                out.append("uuuu");
                i += 4;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareTo("mm") == 0) {
                out.append("MM");
                i += 2;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareTo("DD") == 0) {
                out.append("dd");
                i += 2;
                continue;
            }
            if (i + 4 <= len && in.substring(i, i + 4).compareToIgnoreCase("HH24") == 0) {
                out.append("HH");
                i += 4;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareToIgnoreCase("MI") == 0) {
                out.append("mm");
                i += 2;
                continue;
            }
            if (i + 2 <= len && in.substring(i, i + 2).compareTo("SS") == 0) {
                out.append("ss");
                i += 2;
                continue;
            }
            out.append(in.charAt(i));
            ++i;
        }
        return out.toString();
    }

    public static String getExecDir() {
        String dir = Hplsql.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (dir.endsWith(".jar")) {
            dir = dir.substring(0, dir.lastIndexOf("/") + 1);
        }
        return dir;
    }

    public static String formatSizeInBytes(long bytes, String postfix) {
        String out = bytes == 1L ? bytes + " byte" : (bytes < 1024L ? bytes + " bytes" : (bytes < 0x100000L ? String.format("%.1f", Float.valueOf((float)bytes / 1024.0f)) + " KB" : (bytes < 0x40000000L ? String.format("%.1f", Float.valueOf((float)bytes / 1048576.0f)) + " MB" : String.format("%.1f", Float.valueOf((float)bytes / 1.0737418E9f)) + " GB")));
        if (postfix != null && !postfix.isEmpty()) {
            out = out + postfix;
        }
        return out;
    }

    public static String formatSizeInBytes(long bytes) {
        return Utils.formatSizeInBytes(bytes, null);
    }

    public static String formatTime(long msElapsed) {
        if (msElapsed < 60000L) {
            return msElapsed / 1000L + " sec";
        }
        if (msElapsed < 3600000L) {
            return msElapsed / 60000L + " min " + msElapsed % 60000L / 1000L + " sec";
        }
        return "";
    }

    public static String formatBytesPerSec(long bytes, long msElapsed) {
        if (msElapsed < 30L) {
            return "n/a";
        }
        float bytesPerSec = (float)bytes / (float)msElapsed * 1000.0f;
        return Utils.formatSizeInBytes((long)bytesPerSec, "/sec");
    }

    public static String formatPercent(long current, long all) {
        return String.format("%.1f", Float.valueOf((float)current / (float)all * 100.0f)) + "%";
    }

    public static String formatCnt(long value, String suffix) {
        if (value == 1L) {
            return value + " " + suffix;
        }
        return value + " " + suffix + "s";
    }

    public static String formatCnt(long value, String suffix, String suffix2) {
        if (value == 1L) {
            return value + " " + suffix;
        }
        return value + " " + suffix2;
    }

    static <T> String join(T[] array, String separator) {
        return org.antlr.v4.runtime.misc.Utils.join((Object[])array, (String)separator);
    }
}

