/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.server.services;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.PathIsNotEmptyDirectoryException;
import org.apache.hadoop.fs.PathNotFoundException;
import org.apache.hadoop.registry.client.binding.RegistryPathUtils;
import org.apache.hadoop.registry.client.binding.RegistryUtils;
import org.apache.hadoop.registry.client.exceptions.InvalidRecordException;
import org.apache.hadoop.registry.client.exceptions.NoPathPermissionsException;
import org.apache.hadoop.registry.client.exceptions.NoRecordException;
import org.apache.hadoop.registry.client.impl.zk.RegistryBindingSource;
import org.apache.hadoop.registry.client.impl.zk.RegistryOperationsService;
import org.apache.hadoop.registry.client.impl.zk.RegistrySecurity;
import org.apache.hadoop.registry.client.types.RegistryPathStatus;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.apache.hive.org.apache.curator.framework.api.BackgroundCallback;
import org.apache.hive.org.apache.zookeeper.CreateMode;
import org.apache.hive.org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryAdminService
extends RegistryOperationsService {
    private static final Logger LOG = LoggerFactory.getLogger(RegistryAdminService.class);
    public static final int USER_HOMEDIR_ACL_PERMISSIONS = 15;
    protected final ExecutorService executor = HadoopExecutors.newCachedThreadPool((ThreadFactory)new ThreadFactory(){
        private AtomicInteger counter = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "RegistryAdminService " + this.counter.getAndIncrement());
        }
    });

    public RegistryAdminService(String name) {
        this(name, null);
    }

    public RegistryAdminService(String name, RegistryBindingSource bindingSource) {
        super(name, bindingSource);
    }

    @Override
    protected void serviceStop() throws Exception {
        this.stopExecutor();
        super.serviceStop();
    }

    protected synchronized void stopExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    protected ExecutorService getExecutor() {
        return this.executor;
    }

    public <V> Future<V> submit(Callable<V> callable) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Submitting {}", (Object)callable);
        }
        return this.getExecutor().submit(callable);
    }

    public Future<Boolean> createDirAsync(final String path, final List<ACL> acls, final boolean createParents) throws IOException {
        return this.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RegistryAdminService.this.maybeCreate(path, CreateMode.PERSISTENT, acls, createParents);
            }
        });
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        RegistrySecurity registrySecurity = this.getRegistrySecurity();
        if (registrySecurity.isSecureRegistry()) {
            ACL sasl = registrySecurity.createSaslACLFromCurrentUser(31);
            registrySecurity.addSystemACL(sasl);
            LOG.info("Registry System ACLs:", (Object)RegistrySecurity.aclsToString(registrySecurity.getSystemACLs()));
        }
    }

    @Override
    protected void serviceStart() throws Exception {
        super.serviceStart();
        try {
            this.createRootRegistryPaths();
        }
        catch (NoPathPermissionsException e) {
            String message = String.format(Locale.ENGLISH, "Failed to create root paths {%s};%ndiagnostics={%s}%ncurrent registry is:%n{%s}", e, this.bindingDiagnosticDetails(), this.dumpRegistryRobustly(true));
            LOG.error(" Failure {}", (Object)e, (Object)e);
            LOG.error(message);
            throw new NoPathPermissionsException(e.getPath().toString(), message, e);
        }
    }

    @VisibleForTesting
    public void createRootRegistryPaths() throws IOException {
        List<ACL> systemACLs = this.getRegistrySecurity().getSystemACLs();
        LOG.info("System ACLs {}", (Object)RegistrySecurity.aclsToString(systemACLs));
        this.maybeCreate("", CreateMode.PERSISTENT, systemACLs, false);
        this.maybeCreate("/users/", CreateMode.PERSISTENT, systemACLs, false);
        this.maybeCreate("/services/", CreateMode.PERSISTENT, systemACLs, false);
    }

    protected String homeDir(String username) {
        return RegistryUtils.homePathForUser(username);
    }

    public List<ACL> aclsForUser(String username, int perms) throws IOException {
        List<ACL> clientACLs = this.getClientAcls();
        RegistrySecurity security = this.getRegistrySecurity();
        if (security.isSecureRegistry()) {
            clientACLs.add(security.createACLfromUsername(username, perms));
        }
        return clientACLs;
    }

    public Future<Boolean> initUserRegistryAsync(String shortname) throws IOException {
        String homeDir = this.homeDir(shortname);
        if (!this.exists(homeDir)) {
            return this.createDirAsync(homeDir, this.aclsForUser(shortname, 15), false);
        }
        return null;
    }

    public String initUserRegistry(String username) throws IOException {
        try {
            Future<Boolean> future = this.initUserRegistryAsync(username);
            future.get();
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException(e.toString()).initCause(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause.toString(), cause);
        }
        return this.homeDir(username);
    }

    protected void verifyRealmValidity() throws ServiceStateException {
        if (this.isSecure()) {
            String realm = this.getRegistrySecurity().getKerberosRealm();
            if (StringUtils.isEmpty(realm)) {
                throw new ServiceStateException("Cannot determine service realm");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started Registry operations in realm {}", (Object)realm);
            }
        }
    }

    @VisibleForTesting
    public int purge(String path, NodeSelector selector, PurgePolicy purgePolicy, BackgroundCallback callback) throws IOException {
        Collection<RegistryPathStatus> entries;
        boolean toDelete = false;
        try {
            Map<String, RegistryPathStatus> childEntries = RegistryUtils.statChildren(this, path);
            entries = childEntries.values();
        }
        catch (PathNotFoundException e) {
            return 0;
        }
        try {
            RegistryPathStatus registryPathStatus = this.stat(path);
            ServiceRecord serviceRecord = this.resolve(path);
            toDelete = selector.shouldSelect(path, registryPathStatus, serviceRecord);
        }
        catch (EOFException registryPathStatus) {
        }
        catch (InvalidRecordException registryPathStatus) {
        }
        catch (NoRecordException registryPathStatus) {
        }
        catch (PathNotFoundException e) {
            return 0;
        }
        if (toDelete && !entries.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Match on record @ {} with children ", (Object)path);
            }
            switch (purgePolicy) {
                case SkipOnChildren: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping deletion");
                    }
                    toDelete = false;
                    break;
                }
                case PurgeAll: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Scheduling for deletion with children");
                    }
                    toDelete = true;
                    entries = new ArrayList<RegistryPathStatus>(0);
                    break;
                }
                case FailOnChildren: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Failing deletion operation");
                    }
                    throw new PathIsNotEmptyDirectoryException(path);
                }
            }
        }
        int deleteOps = 0;
        if (toDelete) {
            try {
                this.zkDelete(path, true, callback);
            }
            catch (PathNotFoundException e) {
                return deleteOps;
            }
            ++deleteOps;
        }
        for (RegistryPathStatus status : entries) {
            String childname = status.path;
            String childpath = RegistryPathUtils.join(path, childname);
            deleteOps += this.purge(childpath, selector, purgePolicy, callback);
        }
        return deleteOps;
    }

    public class AsyncPurge
    implements Callable<Integer> {
        private final BackgroundCallback callback;
        private final NodeSelector selector;
        private final String path;
        private final PurgePolicy purgePolicy;

        public AsyncPurge(String path, NodeSelector selector, PurgePolicy purgePolicy, BackgroundCallback callback) {
            this.callback = callback;
            this.selector = selector;
            this.path = path;
            this.purgePolicy = purgePolicy;
        }

        @Override
        public Integer call() throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing {}", (Object)this);
            }
            return RegistryAdminService.this.purge(this.path, this.selector, this.purgePolicy, this.callback);
        }

        public String toString() {
            return String.format("Record purge under %s with selector %s", this.path, this.selector);
        }
    }

    public static interface NodeSelector {
        public boolean shouldSelect(String var1, RegistryPathStatus var2, ServiceRecord var3);
    }

    public static enum PurgePolicy {
        PurgeAll,
        FailOnChildren,
        SkipOnChildren;

    }
}

