/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hive.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TableMapping
extends CachedDNSToSwitchMapping {
    private static final Logger LOG = LoggerFactory.getLogger(TableMapping.class);

    public TableMapping() {
        super(new RawTableMapping());
    }

    private RawTableMapping getRawMapping() {
        return (RawTableMapping)this.rawMapping;
    }

    @Override
    public Configuration getConf() {
        return this.getRawMapping().getConf();
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        this.getRawMapping().setConf(conf);
    }

    @Override
    public void reloadCachedMappings() {
        super.reloadCachedMappings();
        this.getRawMapping().reloadCachedMappings();
    }

    private static final class RawTableMapping
    extends Configured
    implements DNSToSwitchMapping {
        private Map<String, String> map;

        private RawTableMapping() {
        }

        private Map<String, String> load() {
            HashMap<String, String> loadMap = new HashMap<String, String>();
            String filename = this.getConf().get("net.topology.table.file.name", null);
            if (StringUtils.isBlank(filename)) {
                LOG.warn("net.topology.table.file.name not configured. ");
                return null;
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(filename, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() != 0 && line.charAt(0) != '#') {
                        String[] columns = line.split("\\s+");
                        if (columns.length == 2) {
                            loadMap.put(columns[0], columns[1]);
                        } else {
                            LOG.warn("Line does not have two columns. Ignoring. " + line);
                        }
                    }
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                LOG.warn(filename + " cannot be read.", e);
                return null;
            }
            return loadMap;
        }

        @Override
        public synchronized List<String> resolve(List<String> names) {
            if (this.map == null) {
                this.map = this.load();
                if (this.map == null) {
                    LOG.warn("Failed to read topology table. /default-rack will be used for all nodes.");
                    this.map = new HashMap<String, String>();
                }
            }
            ArrayList<String> results = new ArrayList<String>(names.size());
            for (String name : names) {
                String result = this.map.get(name);
                if (result != null) {
                    results.add(result);
                    continue;
                }
                results.add("/default-rack");
            }
            return results;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reloadCachedMappings() {
            Map<String, String> newMap = this.load();
            if (newMap == null) {
                LOG.error("Failed to reload the topology table.  The cached mappings will not be cleared.");
            } else {
                RawTableMapping rawTableMapping = this;
                synchronized (rawTableMapping) {
                    this.map = newMap;
                }
            }
        }

        @Override
        public void reloadCachedMappings(List<String> names) {
            this.reloadCachedMappings();
        }
    }
}

